<?php

add_action( 'vc_load_default_templates_action','nectar_custom_studio_templates_for_vc' ); 


/**
 * Salient Studio templates.
 *
 * @since 1.0
 */
if( !function_exists('nectar_custom_studio_templates_for_vc') ) {
	
function nectar_custom_studio_templates_for_vc() {

$cat_display_names = array(
	'about' => esc_html__('About', 'salient-core'),
	'blog' => esc_html__('Blog', 'salient-core'),
	'cta' => esc_html__('Call To Action', 'salient-core'),
	'counters' => esc_html__('Counters', 'salient-core'),
	'general' => esc_html__('General', 'salient-core'),
	'icons' => esc_html__('Icons', 'salient-core'),
	'hero_section' => esc_html__('Hero Section', 'salient-core'),
	'google_map' => esc_html__('Map', 'salient-core'),
	'portfolio' => esc_html__('Project', 'salient-core'),
	'pricing' => esc_html__('Pricing', 'salient-core'),
	'services' => esc_html__('Services', 'salient-core'),
	'team' => esc_html__('Team', 'salient-core'),
	'testimonials' => esc_html__('Testimonials', 'salient-core'),
	'shop' => esc_html__('Shop', 'salient-core')
);



$data = array();
$data['name'] = esc_html__( 'SVG Draw Animation Icons', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons']  .', '. $cat_display_names['general'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/svg_icon_draw.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#3a6ee8" scene_position="center" text_color="light" text_align="center" top_padding="16%" bottom_padding="5%" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-software-transform-bezier" icon_size="60"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h6>Sexy Design</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-basic-mixer2" icon_size="60" animation_delay="500"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="500"][vc_column_text]
<h6>True Power</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-weather-wind-fullmoon" icon_size="60" animation_delay="1000"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="1000"][vc_column_text]
<h6>Icon Paradise</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-software-layout-header-complex" icon_size="60" animation_delay="1500"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="1500"][vc_column_text]
<h6>Page Builder</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-ecommerce-diamond" icon_size="60" animation_delay="2000"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="2000"][vc_column_text]
<h6>Top Quality</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Extra-Color-3" icon_padding="0px" icon_linea="icon-software-paintroller" icon_size="60" animation_delay="2500"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="2500"][vc_column_text]
<h6>Customizable</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#3a6ee8" scene_position="center" text_color="light" text_align="left" bottom_padding="17%" overlay_strength="0.3" shape_divider_position="bottom"][vc_column enable_animation="true" animation="fade-in" column_padding="padding-1-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3 style="text-align: right;">Hello. We're Salient, A Creative Agency Located In New York City. Take A Look Around &amp; Don't Be Shy.</h3>
[/vc_column_text][/vc_column][vc_column enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#cdf4f4" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]Phasellus enim libero, blandit vel sapien vitae, condimentum ultricies magna et. Quisque euismod orci ut et lobortis aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Mouse Based Parallax', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'about hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/mouse_parallax.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" mouse_based_parallax_bg="true" scene_position="center" mouse_sensitivity="19" layer_one_image="http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/Comp-1-0-00-15-11_1.jpg" layer_one_strength="0.11" layer_two_image="http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/mountains.png" layer_two_strength="0.24" layer_three_image="http://themenectar.com/demo/salient-frostwave/wp-content/uploads/2013/03/ground-revised.png" layer_three_strength="0.5" text_color="light" text_align="left" top_padding="20%" bottom_padding="18%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<h1 class="jumbo">Hello</h1><h5><i>We are Salient. It's nice to meet you!</i></h5>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fondly Simple Service List', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['icons'] .', '. $cat_display_names['services'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'icons services general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/services-icons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="We make it simple to share your ideas with target audiences." font_container="tag:h2|font_size:48px|text_align:center|line_height:57px" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485869848994{padding-right: 13% !important;padding-left: 13% !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Upload-toCloud" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869613252{margin-bottom: 15px !important;}"]
<h5>Upload your ideas to Salient</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-D-Eyeglasses2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869633028{margin-bottom: 15px !important;}"]
<h5>Watch the magic happen</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Happy" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869652646{margin-bottom: 15px !important;}"]
<h5>Enjoy your increased revenue</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through-2" color_override="#b2b2b2" hover_color_override="#0a0a0a" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Learn More" margin_top="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Restaurant CTA', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/eat-with-us.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/iRguZkRTQyA" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#000000" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#000000" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1487011499391{margin-bottom: 35px !important;}"]
<h2>Come in and eat with us</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text]<strong>Monday – Thursday:</strong> 9:00 am – 10:00 pm[/vc_column_text][vc_custom_heading text="<i>Food service until 9:00 pm</i>" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text]<strong>Friday - Saturday:</strong> 9:00 am – Midnight[/vc_column_text][vc_custom_heading text="<i>Food service until 10:00 pm</i>" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text]<strong>Sunday:</strong> 11:00 am – 10:00 pm[/vc_column_text][vc_custom_heading text="<i>Food service until 9:00 pm</i>" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][nectar_btn size="jumbo" open_new_tab="true" button_style="regular" button_color_2="Accent-Color" icon_family="none" url="http://opentable.com" text="Make A Reservation" margin_top="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Tour Schedule Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-tour.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/ePfBHXM0tyA" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#111111" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0a0a" overlay_strength="0.95"][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486348408362{margin-bottom: 90px !important;}"]
<h1>USA Tour</h1>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="May 24" col_2_content="Massey Hall" col_3_content="Toronto, ON" cta_1_text="Buy Tickets"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="May 28" col_2_content="Electric Factory" col_3_content="Philadelphia, PA" cta_1_text="Buy Tickets"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="June 12" col_2_content="Manhattan Center" col_3_content="New York, NY" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="June 25" col_2_content="BB&amp;T Pavilion" col_3_content="Camden, NJ" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 02" col_2_content="Aragon Ballroom" col_3_content="Chicago, IL" cta_1_text="Buy Tickets"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 08" col_2_content="WaMu Theater" col_3_content="Seattle, WA" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 15" col_2_content="Fox Theater" col_3_content="Oakland, CA" cta_1_text="Buy Tickets" cta_1_url="#"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="small_first_last" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" font_family="h6" hover_color="accent-color" col_1_content="July 21" col_2_content="Shrine Expo Hall" col_3_content="Los Angeles" cta_1_text="Buy Tickets"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Awesome Shape Divider Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/corporate-2-landing.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" video_bg="use_video" video_mute="true" video_webm="" video_mp4="" video_external="https://www.youtube.com/watch?v=4BfKFCOCJe8" text_color="light" text_align="left" top_padding="12%" bottom_padding="7%" enable_gradient="true" color_overlay="#3452ff" color_overlay_2="#ff1053" gradient_direction="left_t_to_right_b" overlay_strength="0.8" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="250" shape_type="curve"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1504325323751{margin-bottom: 15px !important;}"]
<h5>Have you noticed</h5>
[/vc_column_text][split_line_heading]
<h1>Small details create</h1>
<h1>the big picture</h1>
[/split_line_heading][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#creative-services" text="Learn More" margin_top="25" css_animation="slideInUp" margin_bottom="85"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" bottom_margin="-26%" width="1/1" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://source.unsplash.com/800x600/daily/?face,happy" hover_effect="defaut" box_shadow="x_large_depth" border_radius="10px" play_button_size="larger" video_url="https://www.youtube.com/watch?v=i9NZfXRnA70"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Color Changing Client Rows', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/clients-hover-color.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle"  bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][clients columns="4" hover_effect="greyscale_to_color" additional_padding="4"][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894777216-0-4" tab_id="1502894621516-2" url="#" name="elevate"]  [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894065-1-80" tab_id="1502894621516-3" url="#" name="harper"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894782547-0-5" tab_id="1502894621516-4" url="#" name="waveform"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894777848-0-9" tab_id="1502894621516-5" url="#" name="brooklyn"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894784816-0-0" tab_id="1502894621516-9" url="#" name="camallero"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1503948180817-0-9" tab_id="1502894621516-6" url="#" name="ollostream"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1503948181836-0-4" tab_id="1502894621516-7" url="#" name="golden grid"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894776482-0-6" tab_id="1502894621516-8" url="#" name="jacks"] [/client][/clients][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Delightful Service Blocks', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colorful-services.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" id="creative-services" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Striving to make the web a more beautiful place every single day</h3>
[/vc_column_text][vc_column_text css=".vc_custom_1504286255898{padding-right: 10% !important;}"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes.[/vc_column_text][nectar_btn size="large" button_style="see-through-2" color_override="#ff1053" hover_color_override="#ff1053" hover_text_color_override="#ffffff" icon_family="default_arrow" url="#explainer" text="Learn More" margin_top="15"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#2ac4ea" content_color="#ffffff" box_color_opacity="0.6" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#http://google.com" icon_iconsmind="iconsmind-Environmental-3" css=".vc_custom_1504285427120{margin-top: 50px !important;margin-bottom: 2em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Natural Flow</h4>
Sed cursus turpis vitae tortor donec eaque ipsa quaeab illo.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Sun" css=".vc_custom_1504285795178{margin-bottom: 50px !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Hot Looks</h4>
Nemo enim ipsam volup tatem quia vol uptas sit sunt in.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#ff1053" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Rock-andRoll" css=".vc_custom_1504285430965{margin-bottom: 2em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" delay="100" icon_size="40"]
<h4>Awesome Design</h4>
Nam libero tempore, cum soluta nobis placeat facere.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#fbbc05" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Atom" delay="100" css=".vc_custom_1504286112774{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Unrivaled Quality</h4>
At vero eos et lorem accusamus et iusto ullam corporis.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#2f88d6" content_color="#ffffff" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Motorcycle" css=".vc_custom_1504286068726{margin-top: 50px !important;margin-bottom: 2em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" delay="200" icon_size="40"]
<h4>Visual Builder</h4>
Ipsum totam rem aperiam, eaque ipsa quae ab illo.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#34a853" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="0" link_url="#" icon_iconsmind="iconsmind-Folder-Organizing" delay="200" css=".vc_custom_1504286089409{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Ton of Features</h4>
Incidunt ut labore et dolore magnam ali quam quaerat.[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quick FAQ & Overflowing Image', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quick-faq-and-image.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" id="explainer" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1505433788851{margin-bottom: 30px !important;}"]
<h3>Salient Studio changes the WordPress game forever.</h3>
[/vc_column_text][toggles style="minimal_small" accordion="true"][toggle color="Default" title="Over 200 Section Templates"][vc_column_text]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque.[/vc_column_text][/toggle][toggle color="Default" title="Available Directly in Page Builder"][vc_column_text]Malesuada fames ac turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus quis mi.[/vc_column_text][/toggle][toggle color="Default" title="One Click Template Insert"][vc_column_text]Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero.[/vc_column_text][/toggle][/toggles][nectar_btn size="large" button_style="see-through-2" color_override="#3452ff" hover_text_color_override="#ffffff" icon_family="default_arrow" url="http://themenectar.com/demo/salient-corporate-2/about-us" text="Learn More" margin_top="35"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/1200x800/daily/?office" alignment="" animation="Fade In From Right" border_radius="10px" box_shadow="x_large_depth" max_width="150%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Monotone Milestones', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['counters'];
$data['custom_class'] = 'counters';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal-milestones.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text max_width="500"]
<h3>Helping people reclaim their time</h3>
[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="97" symbol="%" subject="Percent of users recommend us to friends and family" number_font_size="92" symbol_font_size="40"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="350" subject="Companies have shifted to using us recently" number_font_size="92" symbol="+" symbol_font_size="42"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="16" subject="We deliver so much more than the competition " number_font_size="92" symbol="x" symbol_font_size="40"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Auto Masonry Recent Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/auto-masonry-recent-posts.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text max_width="500" css=".vc_custom_1503969123885{margin-bottom: 40px !important;}"]
<h3>Our Recent Writings</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][nectar_blog layout="masonry-blog-fullwidth" blog_masonry_style="auto_meta_overlaid_spaced" auto_masonry_spacing="16px" category="all" load_in_animation="none" order="DESC" orderby="date" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" bottom_margin="20" width="1/1" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="material" heading_tag="h4" text_color="#34a853" link_type="regular" alignment="center" text="Like what you see?" link_text="See more posts" url="http://themenectar.com/demo/salient-corporate-2/news"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Rounded Box Over Shape Divider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/color-box-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f2f2f2" scene_position="center" text_color="dark" text_align="left" top_padding="60" overlay_strength="0.3" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="top" shape_divider_height="80" shape_type="curve"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" translate_y="-50%"][vc_row_inner column_margin="default" translate_y="-50%" text_align="left"][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color="#ff1053" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="x_large_depth" column_border_radius="20px" top_margin="15" width="1/1" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="15"][vc_custom_heading text="Build your dream website today." font_container="tag:h3|text_align:center" google_fonts="font_family:Nunito%3A300%2Cregular%2C700|font_style:700%20bold%20regular%3A700%3Anormal"][nectar_btn size="large" open_new_tab="true" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="https://themeforest.net/item/salient-responsive-multipurpose-theme/4363266" text="Purchase Salient" margin_top="30" margin_bottom="1"][divider line_type="No Line" custom_height="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Impactful Header Text', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'general hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/impactful-header.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="10%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_gradient_text heading_tag="h5" color="extra-color-gradient-2" gradient_direction="horizontal" text="Together We Build Dreams"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504326206457{margin-bottom: 20px !important;}"]
<h2>A wonderful serenity <strong>has</strong> <strong>taken possession</strong> of my entire soul, like these sweet mornings of spring which I enjoy with my <strong>whole heart</strong>.</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Testimonial Popout', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonial-popout.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="250"][/vc_column][/vc_row][vc_row type="in_container" full_screen_row_position="middle" equal_height="yes" content_placement="bottom" bg_image="https://source.unsplash.com/featured/daily/?happy" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" enable_gradient="true" color_overlay_2="rgba(10,10,10,0.87)" gradient_direction="left_t_to_right_b" overlay_strength="0.5" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" translate_y="-50%" translate_x="-17%" text_align="left"][vc_column_inner column_padding="padding-17-percent" column_padding_position="all" background_color="#ff3366" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="small_modern" image="https://source.unsplash.com/featured/200x200/daily/?face" color="Default" quote="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. " name="Jessie Cohen" subtitle="Web Developer"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" color_override="#ffffff" icon_family="none" url="#team" text="Meet The Team"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Team Overlapping Section Below', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['team'];
$data['custom_class'] = 'team';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/team-overlap-milestones.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" bottom_margin="-6%" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="60" text_align="left" el_id="team"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Say hello to your team" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][divider line_type="Small Line" line_thickness="2" divider_color="accent-color" animate="yes" custom_height="40" custom_line_width="40"][vc_column_text max_width="650"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec quis nisi vel dui porttitor volutpat. Curabitur vel maximus mauris. Sed in dictum sem.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?man" bio_image_url="https://source.unsplash.com/featured/600x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Claire Kozlov" job_position="Graphic Designer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-facebook" social_link_1="# " social_icon_2="fa fa-twitter" social_link_2="# " social_icon_3="fa fa-instagram" social_link_3="# "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?girl" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Mark Jones" job_position="Back-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-github-alt" social_icon_2="fa fa-instagram" social_icon_3="fa fa-facebook"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?face" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Andrea Smith" job_position="Fine Artist" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-dribbble" social_link_1="# " social_icon_2="fa fa-deviantart" social_link_2="# " social_icon_3="fa fa-instagram" social_link_3="# "][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?person" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Ethan Young" job_position="Team Leader" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#" social_icon_3="fa fa-linkedin" social_link_3="#"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?happy" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?happy" team_memeber_style="bio_fullscreen" name="Ava Morgan" job_position="The SEO Expert" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-instagram" social_link_1="#" social_icon_2="fa fa-twitter" social_link_2="#"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?woman" bio_image_url="https://source.unsplash.com/featured/700x1000/daily/?woman" team_memeber_style="bio_fullscreen" name="James Anderson" job_position="Front-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-twitter" social_link_1="#" social_icon_2="fa fa-youtube-play" social_link_2="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_image="7094" background_image_mobile_hidden="true" bg_position="center top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="18%" bottom_padding="13%" enable_gradient="true" color_overlay="#3452ff" color_overlay_2="#ff1053" gradient_direction="left_t_to_right_b" overlay_strength="0.8" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="250" shape_type="curve_opacity"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Percent Increase" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504326242419{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" subject_padding="2%" color="Default" effect="count" milestone_alignment="default" number="87" number_font_size="92"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Referrals " font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504290730551{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="479" symbol="+" number_font_size="92" symbol_font_size="40"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="New Accounts" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504288841908{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" subject_padding="2%" color="Default" effect="count" milestone_alignment="default" number="247" number_font_size="92"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Subscribers" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.63)" use_theme_fonts="yes" css=".vc_custom_1504290761477{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" milestone_alignment="default" number="13" number_font_size="92" symbol="k" symbol_font_size="40"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overflowing Testimonials & Text Snippet', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonial-carousel-with-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" id="testimonials" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="30" bottom_margin="30" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][carousel script="flickity" flickity_formatting="fixed_text_content_fullwidth" flickity_fixed_content="
<h4>What they've said about us</h4>
lorem ipsum dolor set amet et it lorem ipsum dolor set amet et it" button_color="Accent-Color" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="1" column_padding="50px" autorotate="true" column_color="#ffffff" border_radius="10px" enable_column_border="true" cta_button_text="Contact Us" cta_button_url="#" autorotation_speed="7000"][item id="1504038498-1-94" tab_id="1504038676473-4" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?girl" quote="I've learned that people will forget what you said, people will forget what you did, but people will never forget how you made them feel." name="Ray Jackson" subtitle="Structural Engineer "][/item][item id="1504055252242-0-2" tab_id="1504038676473-4" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?man" quote="Science is fun. Science is curiosity. We all have natural curiosity. Science is a process of investigating. It's posing questions and coming up with a method. It's delving in." name="Sam Murray " subtitle="Lead Architect"][/item][item id="1504038498-2-81" tab_id="1504038676738-8" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?face" quote="I feel confident imposing change on myself. It's a lot more fun progressing than looking back. That's why I need to throw curve balls." name="Jake Smith" subtitle="Salient Corp"][/item][item id="1504038498-3-53" tab_id="1504038677047-7" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?happy" quote="Our task must be to free ourselves by widening our circle of compassion to embrace all living creatures and the whole of nature and its beauty." name="Alice Johnson" subtitle="Writer at ThemeNectar"][/item][/carousel][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Info/Contact Box Overlapping Map', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/contact-box-overlaying-map.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="5715" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="dark" text_align="left" top_padding="14%" zindex="100" enable_gradient="true" color_overlay="rgba(52,82,255,0.93)" color_overlay_2="rgba(255,16,83,0.92)" gradient_direction="left_t_to_right_b" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="7%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Available booking space</h5>
<h2>Have a project in mind?</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-6-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" column_border_radius="10px" bottom_margin="-25%" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5 style="text-align:center;">Check this out.</h5>
<h2 style="text-align:center;">This are is where <br/> your text or contact<br/> form can go.</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="14" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" ultra_flat="1" size="650" map_center_lat="39.955" map_center_lng="-75.171" map_markers="39.949|-75.171|Our Location "][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Company Values & Quote Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials']  .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/header-overlapping-quote.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="-3%" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" translate_y="13%" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/featured/750x900/daily/?mountains" alignment="" animation="None" border_radius="10px" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="4%" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Read this first" font_container="tag:h5|text_align:left|color:%237a7a7a" use_theme_fonts="yes" css=".vc_custom_1504390675021{margin-top: 65px !important;margin-bottom: 10px !important;}"][vc_custom_heading text="Company Values" font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes" css=".vc_custom_1504033815057{margin-bottom: 30px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][vc_column_text css_animation="none" css=".vc_custom_1504394228032{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h4>Honest</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, onecis et mollis." font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-xs-8" delay="50"][vc_column_text css_animation="none" css=".vc_custom_1504394232676{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h4>Efficient</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, onecis et mollis." font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css_animation="none" css=".vc_custom_1504394236447{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h4>Helpful</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, onecis et mollis." font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" delay="150"][vc_column_text css_animation="none" css=".vc_custom_1504394240503{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h4>Quality</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, onecis et mollis." font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="15" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_cta btn_style="material" heading_tag="h4" text_color="#ff1053" link_type="regular" alignment="left" link_text="Why we're different" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/1600x800/daily/?business" bg_position="center center" bg_repeat="no-repeat" bg_color="#272729" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="8%" color_overlay="rgba(28,28,30,0.93)" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1504394107673{margin-bottom: 0px !important;}"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504392885908{margin-bottom: 20px !important;}"]
<h4>Words to live by</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading]
<h2>Kind words creates confidence.</h2>
<h2>Kind thinking creates profoundness.</h2>
<h2>Kind giving creates love.</h2>
[/split_line_heading][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overflowing Team Members & Text Snippet', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['team'];
$data['custom_class'] = 'team';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-carousel-fixed-content.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="13%" id="team" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][carousel script="flickity" flickity_formatting="fixed_text_content_fullwidth" flickity_fixed_content="
<h5>Our Mugshots</h5>
<h3>Say hello to your potential team, each a master of their respective craft.</h3>
" button_color="Accent-Color" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="1" column_padding="0" border_radius="10px"][item id="1504038676473-46596-9e8f" title="Item" tab_id="1508882258172-9"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?girl" bio_image_url="https://source.unsplash.com/featured/800x1000/daily/?girl" team_memeber_style="bio_fullscreen" name="Ethan Young" job_position="Team Leader" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#" social_icon_3="fa fa-linkedin" social_link_3="#"][/item][item id="1504038676473-46596-56gj" title="Item" tab_id="1508882258184-4"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?man" bio_image_url="https://source.unsplash.com/featured/800x1000/daily/?man" team_memeber_style="bio_fullscreen" name="Ava Morgan" job_position="The SEO Expert" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-instagram" social_link_1="#" social_icon_2="fa fa-twitter" social_link_2="#"][/item][item id="1504038676738-86596-mh3d" title="Item" tab_id="1508882258210-7"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?person" bio_image_url="https://source.unsplash.com/featured/800x1000/daily/?person" team_memeber_style="bio_fullscreen" name="James Anderson" job_position="Front-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-twitter" social_link_1="#" social_icon_2="fa fa-youtube-play" social_link_2="#"][/item][item id="1504038677047-76596-33hf" title="Item" tab_id="1508882258235-10"][team_member image_url="https://source.unsplash.com/featured/600x400/daily/?happy" bio_image_url="https://source.unsplash.com/featured/800x1000/daily/?happy" team_memeber_style="bio_fullscreen" name="Mark Jones" job_position="Back-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. " social_icon_1="fa fa-github-alt" social_icon_2="fa fa-instagram" social_icon_3="fa fa-facebook"][/item][/carousel][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Team About Us Blurb', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'];
$data['custom_class'] = 'about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-us-row.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/1600x600/daily/?company" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" top_padding="14%" bottom_padding="12%" enable_gradient="true" color_overlay="#0a0000" color_overlay_2="rgba(10,10,10,0.5)" gradient_direction="left_to_right" overlay_strength="0.5" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="350" shape_type="waves_opacity_alt"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-lg-6 vc_col-md-6 vc_col-xs-12"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1504392866047{margin-bottom: 15px !important;}"]
<h5>Fun and freedom</h5>
[/vc_column_text][split_line_heading]
<h2>We put emphasis on having</h2>
<h2>a creative work environment</h2>
[/split_line_heading][nectar_btn size="large" button_style="regular" button_color_2="Extra-Color-1" icon_family="default_arrow" url="#team" text="Meet the team" margin_top="25" css_animation="slideInUp"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-6-percent" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Fancy Box Hover Color Effect', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/fancy-box-hover-color.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f7f7f7" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="2%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="Accent-Color" box_alignment="left" icon_iconsmind="iconsmind-Split-FourSquareWindow" min_height="200"]
<h4>Massive Element Library</h4>
Aenean massa. Cum sociis natoque penatibus et magnis dis aenean.[/fancy_box][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="100"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="Accent-Color" box_alignment="left" icon_iconsmind="iconsmind-Book" min_height="200"]
<h4>Great Documentation</h4>
Aenean massa. Cum sociis natoque penatibus et magnis dis aenean.[/fancy_box][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="Accent-Color" box_alignment="left" icon_iconsmind="iconsmind-Paint-Bucket" min_height="200"]
<h4>Killer Design Work</h4>
Aenean massa. Cum sociis natoque penatibus et magnis dis aenean.[/fancy_box][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f7f7f7" scene_position="center" text_color="dark" text_align="left" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="Accent-Color" box_alignment="left" icon_iconsmind="iconsmind-Scooter" min_height="200"]
<h4>Attention Grabbing Looks</h4>
Aenean massa. Cum sociis natoque penatibus et magnis dis aenean.[/fancy_box][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="100"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="Accent-Color" box_alignment="left" icon_iconsmind="iconsmind-Love2" min_height="200"]
<h4>Saves Precious Time</h4>
Aenean massa. Cum sociis natoque penatibus et magnis dis aenean.[/fancy_box][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="Accent-Color" box_alignment="left" icon_iconsmind="iconsmind-D-Eyeglasses" min_height="200"]
<h4>Visual Page Builder</h4>
Aenean massa. Cum sociis natoque penatibus et magnis dis aenean.[/fancy_box][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Two Rounded Color Boxes Over Shape Divider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dual-color-boxes.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f2f2f2" scene_position="center" text_color="light" text_align="left" top_padding="2%" overlay_strength="0.3" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="top" shape_divider_height="80" shape_type="curve"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" translate_y="-50%"][vc_row_inner column_margin="default" translate_y="-100" text_align="left"][vc_column_inner column_padding="padding-6-percent" column_padding_position="all" centered_text="true" background_color="#ff1053" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="medium_depth" column_border_radius="15px" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Don't forget we blog too!" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#" text="Read our posts" margin_top="30" margin_bottom="1"][/vc_column_inner][vc_column_inner column_padding="padding-6-percent" column_padding_position="all" centered_text="true" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="medium_depth" column_border_radius="10px" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Ready to have a conversation? " font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#" text="Contact Us" margin_top="30" margin_bottom="1"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Creative Header With Shape Divider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/creative-header.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/1600x800/daily/?company" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#ff0059" scene_position="center" text_color="light" text_align="left" top_padding="13%" bottom_padding="19%" enable_gradient="true" color_overlay="rgba(255,0,89,0.94)" color_overlay_2="rgba(255,50,0,0.71)" gradient_direction="left_t_to_right_b" overlay_strength="0.95" enable_shape_divider="true" shape_divider_position="bottom" shape_divider_height="350" shape_type="waves_opacity_alt"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h1>WordPress Design</h1>
<h1>as it should be</h1>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="3/4" column_border_width="none" column_border_style="solid" delay="200"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts The Big Oxmox advised her." font_container="tag:h4|font_size:20|text_align:left|color:rgba(255%2C255%2C255%2C0.7)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid" delay="300"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][nectar_btn size="jumbo" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#discover" text="Discover More" margin_top="30"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Clever Overlapping Quote', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-quote.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" id="discover" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1504128844236{margin-right: -1px !important;}"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="bold" color="Extra-Color-1" style="bold" quote="A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/featured/800x600/daily/?white" alignment="right" animation="Grow In" border_radius="none" box_shadow="none" max_width="175%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fancy Box Fullwidth Parallax', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/parallax-fancy-box.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][fancy_box box_style="parallax_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/featured/800x600/daily/?mountains" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Snow" min_height="600"]
<h2>Exclusive Design</h2>
<h5>Lorem Ipsum</h5>
[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][fancy_box box_style="parallax_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/featured/800x600/daily/?girl" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Drag-Down" min_height="600"]
<h2>Visual Builder</h2>
<h5>Lorem Ipsum</h5>
[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][fancy_box box_style="parallax_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/featured/800x600/daily/?tech" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" link_url="#" icon_iconsmind="iconsmind-Crown-2" min_height="600"]
<h2>Powerful Tools</h2>
<h5>Lorem Ipsum</h5>
[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][fancy_box box_style="parallax_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/featured/800x600/daily/?view" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" link_url="#" icon_iconsmind="iconsmind-Snow" min_height="600"]
<h2>Quick Importer</h2>
<h5>Lorem Ipsum</h5>
[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Gradient Header And Text', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-header-and-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][nectar_gradient_text heading_tag="h2" color="extra-color-gradient-2" gradient_direction="diagonal" text="If you wish to make an apple pie from scratch, you must first invent the universe."][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504205183336{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504205188668{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Fancy Box Color Hover Gradient', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general']  .', '. $cat_display_names['services'];
$data['custom_class'] = 'general services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-fancy-box-color-hover.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504200789745{padding-top: 10% !important;}"]
<h2>An exceptionally unique experience tailored to you</h2>
[/vc_column_text][nectar_btn size="large" button_style="see-through" button_color_2="extra-color-gradient-2" icon_family="default_arrow" url="#" text="Learn More" margin_top="15"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1504187365562{margin-bottom: 2% !important;}"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="extra-color-gradient-2" box_alignment="left" icon_iconsmind="iconsmind-Yacht" min_height="200"]
<h3>Fast Turnaround</h3>
I throw myself down among the tall grass by the stream as I lie close to the earth.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="extra-color-gradient-2" box_alignment="left" icon_iconsmind="iconsmind-Butterfly" min_height="200"]
<h3>Elegant Design</h3>
And the meridian sun strikes the upper surface of the impenetrable foliage.[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="extra-color-gradient-2" box_alignment="left" icon_iconsmind="iconsmind-Cool-Guy" min_height="200"]
<h3>Super Fresh</h3>
I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="iconsmind" color="extra-color-gradient-2" box_alignment="left" icon_iconsmind="iconsmind-Trophy" min_height="200"]
<h3>Award Winning</h3>
As I lie close to the earth, a thousand unknown plants are noticed by me.[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Row of Featured Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-blog-featured-3.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="50" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Our Recent Writings</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="0" text_align="left" css=".vc_custom_1504236091614{margin-bottom: 0px !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][recent_posts style="list_featured_first_row" category="all" columns="3" order="DESC" orderby="date" posts_per_page="3"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through" button_color_2="extra-color-gradient-2" icon_family="default_arrow" url="#" text="See Full Blog" margin_top="15" css_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Posts Slider Right Nav', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-slider-right-nav.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="multiple_large_featured" category="all" multiple_large_featured_num="3" auto_rotate="8000" large_featured_padding="14%" mlf_navigation_location="side" button_color="Accent-Color" bg_overlay="solid_color" order="DESC" orderby="date"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overlapping Posts Slider & Masonry Blog', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-slider-masonry-overlap.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="multiple_large_featured" category="all" multiple_large_featured_num="3" auto_rotate="8000" large_featured_padding="14%" mlf_navigation_location="side" button_color="Accent-Color" bg_overlay="solid_color" order="DESC" orderby="date"][/vc_column][/vc_row][vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="-5%" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_blog layout="masonry-blog-fullwidth" blog_masonry_style="material" category="all" load_in_animation="perspective" order="DESC" orderby="date" posts_per_page="6" post_offset="3"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Sidebar & Left Featured Image Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/fixed-sidebar-featured-left.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_blog layout="std-blog-sidebar" blog_standard_style="featured_img_left" category="all" enable_ss="true" load_in_animation="none" order="DESC" orderby="date" posts_per_page="4" post_offset="9"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Multiple Visible Recent Post Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-multple-vis.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" top_padding="3%" bottom_padding="3%" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1506507046942{margin-top: 60px !important;margin-bottom: 60px !important;}"]<h2 style="text-align: center;">Recent Posts</h2>[/vc_column_text][recent_posts style="slider_multiple_visible" category="all" columns="3" button_color="Accent-Color" order="DESC" orderby="date" posts_per_page="6"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Random Posts Featured Top Row', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-featured-top-row.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1505076927694{margin-top: 20px !important;margin-bottom: 60px !important;}"]
<h2 style="text-align: center;">An Assorted Pick</h2>
[/vc_column_text][recent_posts style="list_featured_first_row" category="all" columns="3" order="ASC" orderby="rand" posts_per_page="9"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Cool Dark Auto Masonry Blog & Featured Top Post', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/auto-masonry-blog-overlap-featured.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="single_large_featured" category="all" large_featured_padding="12%" button_color="extra-color-gradient-2" bg_overlay="diagonal_gradient" order="DESC" orderby="date"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="-5%" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_blog layout="masonry-blog-fullwidth" blog_masonry_style="auto_meta_overlaid_spaced" auto_masonry_spacing="4px" category="all" load_in_animation="none" order="DESC" orderby="date" posts_per_page="6" post_offset="1"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Pretty Dark CTA Gradient Button', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/daily/?mountains" bg_position="center bottom" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" enable_gradient="true" color_overlay="#0a0a0a" color_overlay_2="rgba(17,17,17,0.31)" gradient_direction="top_to_bottom" overlay_strength="1" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="left-right" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Let's Start This Party" font_container="tag:h2|font_size:52|text_align:center|line_height:52px" use_theme_fonts="yes" css_animation="fadeInUp"][divider line_type="No Line" custom_height="10"][vc_custom_heading text="Like Nothing You've Seen. Purchase Today &amp; Experience Salient" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1504487727704{margin-top: 10px !important;margin-bottom: 10px !important;}"][nectar_btn size="jumbo" button_style="regular" button_color_2="extra-color-gradient-2" icon_family="default_arrow" url="https://themeforest.net/item/salient-responsive-multipurpose-theme/4363266" text="Learn More" css_animation="zoomIn"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Two Recent Posts Dark Background', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/two-recent-posts-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="4%" bottom_padding="3%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1504490629058{margin-bottom: 60px !important;}"]
<h2 style="text-align: center;">Latest In Travel Ideas</h2>
[/vc_column_text][recent_posts style="list_featured_first_row" category="all" columns="2" order="DESC" orderby="date" posts_per_page="2" post_offset="2"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Bottom Navigation Recent Post Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-bottom-nav.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" bottom_padding="4%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="multiple_large_featured" category="all" multiple_large_featured_num="4" auto_rotate="9000" large_featured_padding="14%" mlf_navigation_location="bottom" button_color="extra-color-gradient-1" bg_overlay="solid_color" order="DESC" orderby="date"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Pricing Gradient Boxes', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/pricing-table-gradient.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?mountains" color="extra-color-gradient-2" box_alignment="center" min_height="450"]
<h5>Try It Now</h5>
<h2>Basic</h2>
Get a free domain name and custom cookies delivered to your door every month.
<h3>Free</h3>
&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?happy" color="extra-color-gradient-2" box_alignment="center" min_height="450"]
<h5>Most Popular</h5>
<h2>Premium</h2>
Get a free domain name and 24/7 customer support &amp; month of free bandwidth.
<h3>$30/mo</h3>
&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?tech" color="extra-color-gradient-2" box_alignment="center" min_height="450"]
<h5>Good Value</h5>
<h2>Ultimate</h2>
Get a free domain name and 24/7 customer support &amp; design consultation &amp; premium support
<h3>$49.99/mo</h3>
&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Simple Single Quote', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general']  .', '. $cat_display_names['testimonials'];
$data['custom_class'] = 'general testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/simple-quote.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="50" bottom_padding="50" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="bold" color="Accent-Color" quote="But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her" name="Robert Johnson" subtitle="ThemeNectar"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Material Masonry Blog Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/material-blog.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_blog layout="masonry-blog-fullwidth" blog_masonry_style="material" category="all" enable_pagination="true" pagination_type="default" load_in_animation="fade_in_from_bottom" order="DESC" orderby="date" posts_per_page="20"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Posts With Featured Row & Sticky Sidebar', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/featured-row-recent-posts-sticky-sidebar.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="list_featured_first_row_tall" category="all" columns="3" order="DESC" orderby="date" posts_per_page="9"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="left" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_widget_sidebar enable_sticky="true" sidebar_id="blog-sidebar"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Four Boxes And Text With Dark Image BG ', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/four-cols-right.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/daily/?workshop" bg_position="left top" bg_repeat="no-repeat" bg_color="#141414" scene_position="center" text_color="light" text_align="left" top_padding="9%" bottom_padding="8%" color_overlay="#212121" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1507069609150{margin-bottom: 5px !important;}"]
<h5>Check This Out</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1507069688019{padding-right: 5% !important;}"]
<h2>Always striving to make the web beautiful</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1507069647653{margin-bottom: 30px !important;padding-right: 10% !important;}" max_width="550"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes.[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="#explainer" text="Learn More" margin_top="15"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#ffffff" content_color="#3452ff" box_color_opacity="0.6" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="200" link_url="#" icon_iconsmind="iconsmind-Environmental-3" css=".vc_custom_1507069485243{margin-bottom: 1.8em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Natural Flow</h4>
Sed cursus turpis vitae tortor donec eaque ipsa quaeab illo.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#ffffff" content_color="#3452ff" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="200" link_url="" icon_iconsmind="iconsmind-Sun" css=".vc_custom_1507069237522{margin-bottom: 50px !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Hot Looks</h4>
Nemo enim ipsam volup tatem quia vol uptas sit sunt in.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#ffffff" content_color="#3452ff" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="200" link_url="" icon_iconsmind="iconsmind-Rock-andRoll" css=".vc_custom_1507069493020{margin-bottom: 1.8em !important;padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" delay="100" icon_size="40"]
<h4>Awesome Design</h4>
Nam libero tempore, cum soluta nobis placeat facere.[/fancy_box][fancy_box box_style="color_box_basic" icon_family="iconsmind" box_color="#ffffff" content_color="#3452ff" box_color_opacity="1" box_alignment="left" enable_animation="true" animation="fade-in-from-bottom" color_scheme="none" secondary_content="here's some awesome text that would only be shown on hover" min_height="200" icon_iconsmind="iconsmind-Atom" delay="100" css=".vc_custom_1507069246915{padding-top: 15% !important;padding-right: 15% !important;padding-bottom: 15% !important;padding-left: 15% !important;}" icon_size="40"]
<h4>Unrivaled Quality</h4>
At vero eos et lorem accusamus et iusto ullam corporis.[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Grid Based Testimonials Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/separate-testimonials.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/daily/?craft" bg_position="left top" bg_repeat="no-repeat" bg_color="#141414" scene_position="center" text_color="light" text_align="left" top_padding="9%" bottom_padding="8%" color_overlay="#212121" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1507069609150{margin-bottom: 5px !important;}"]
<h5>Check This Out</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1507070135832{padding-right: 5% !important;}"]
<h2>What They're Saying About Us</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/12" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?girl" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Alley Cohen " subtitle="Designer"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/12" column_border_width="none" column_border_style="solid" delay="150"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?guy" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Jason Smith" subtitle="Developer "][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/12" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?dude" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Kara Lucas" subtitle="Interior Decorator "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/12" column_border_width="none" column_border_style="solid" delay="150"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?woman" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Casey Jacobs " subtitle="Cookie Monster"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" text="See All Testimonials" margin_top="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Pricing Gradient Boxes', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/pricing-table-gradient-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/daily/?craft" bg_position="left top" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#232323" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?mountains" color="extra-color-gradient-1" box_alignment="center" min_height="450"]
<h5>Try It Now</h5>
<h2>Basic</h2>
Get a free domain name and custom cookies delivered to your door every month.
<h3>Free</h3>
&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?happy" color="extra-color-gradient-1" box_alignment="center" min_height="450"]
<h5>Most Popular</h5>
<h2>Premium</h2>
Get a free domain name and 24/7 customer support &amp; month of free bandwidth.
<h3>$30/mo</h3>
&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?tech" color="extra-color-gradient-1" box_alignment="center" min_height="450"]
<h5>Good Value</h5>
<h2>Ultimate</h2>
Get a free domain name and 24/7 customer support &amp; design consultation &amp; premium support
<h3>$49.99/mo</h3>
&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Service Boxes Dark Gradient Coloring', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/text-gradient-hover-boxes.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/daily/?happy" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#212121" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#212121" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1507121674772{margin-bottom: 10px !important;}"]
<h5>How We Can Help</h5>
[/vc_column_text][vc_column_text]
<h2>An exceptional experience</h2>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque finibus ullamcorper dui et eleifend. In hac habitasse platea dictumst. Mauris sit amet feugiat tortor, a fermentum mi." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.72)" use_theme_fonts="yes"][nectar_btn size="large" button_style="regular" button_color_2="extra-color-gradient-1" icon_family="default_arrow" url="#" text="Learn More" margin_top="15"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1504187365562{margin-bottom: 2% !important;}"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" color="extra-color-gradient-1" box_alignment="left" min_height="140"]
<h3>Fast Turnaround</h3>
I throw myself down among the tall grass by the stream as I lie close to the earth.[/fancy_box][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" delay="150"][fancy_box box_style="color_box_hover" icon_family="none" color="extra-color-gradient-1" box_alignment="left" min_height="140"]
<h3>Elegant Design</h3>
And the meridian sun strikes the upper surface of the impenetrable foliage.[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" color="extra-color-gradient-1" box_alignment="left" min_height="140"]
<h3>Super Fresh</h3>
I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence.[/fancy_box][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" column_border_width="none" column_border_style="solid" delay="150"][fancy_box box_style="color_box_hover" icon_family="none" color="extra-color-gradient-1" box_alignment="left" min_height="140"]
<h3>Award Winning</h3>
As I lie close to the earth, a thousand unknown plants are noticed by me.[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Excellent Hero With BG Image', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/bg-landing-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/daily/?office" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="4%" color_overlay="#0a0a0a" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Are you ready?" font_container="tag:h5|font_size:20|text_align:center|color:%23ffffff|line_height:26px" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1507127425871{margin-bottom: -10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="We're Salient" font_container="tag:h4|font_size:94|text_align:center|color:%23ffffff|line_height:114px" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1507127344251{margin-bottom: -10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" column_border_width="none" column_border_style="solid" delay="200"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" column_border_width="none" column_border_style="solid" delay="150"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast." font_container="tag:p|font_size:18|text_align:center|color:rgba(255%2C255%2C255%2C0.74)|line_height:28px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css_animation="none" css=".vc_custom_1485614418364{padding-right: 5% !important;padding-left: 5% !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="5%" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][nectar_btn size="large" button_style="regular" button_color_2="Extra-Color-1" icon_family="default_arrow" url="#" text="Learn More" margin_top="30"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426628130{margin-bottom: 15px !important;}"]
<h5>There For You</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418797897{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426637035{margin-bottom: 15px !important;}"]
<h5>Pristine Quality</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418801921{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426643514{margin-bottom: 15px !important;}"]
<h5>Heavily Awarded</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418805797{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426698874{margin-bottom: 15px !important;}"]
<h5>Documentation</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418809890{padding-right: 20% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Simple Client Carousel', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/clients-carousel.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][clients columns="6" hover_effect="opacity" additional_padding="4" carousel="true"][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-25bfe-029b" url="#" name="elevate" tab_id="1507130915658-5"]  [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-35bfe-029b" url="#" name="harper" tab_id="1507130915688-2"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-45bfe-029b" url="#" name="waveform" tab_id="1507130915722-3"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-55bfe-029b" url="#" name="brooklyn" tab_id="1507130915763-3"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-95bfe-029b" url="#" name="camallero" tab_id="1507130915805-3"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-65bfe-029b" url="#" name="ollostream" tab_id="1507130915846-4"] [/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-75bfe-029b" url="#" name="golden grid" tab_id="1507130915873-4"][/client][client image="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" title="Client" id="1502894621516-85bfe-029b" url="#" name="jacks" tab_id="1507130915901-6"] [/client][/clients][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Shape Divider Hero Solid Color', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/blue-hero-shape-divider.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="13%" bottom_padding="19%" color_overlay="rgba(52,82,255,0.94)" overlay_strength="0.95" enable_shape_divider="true" shape_divider_position="bottom" shape_divider_height="350" shape_type="mountains"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h1>WordPress Design</h1>
<h1>as it should be</h1>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" column_border_width="none" column_border_style="solid" delay="200"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts The Big Oxmox advised her." font_container="tag:h4|font_size:20|text_align:center|color:rgba(255%2C255%2C255%2C0.7)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1507135671940{padding-right: 5% !important;padding-left: 5% !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#discover" text="Discover More" margin_top="40"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Image And Text With Dark Image BG', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-and-text-btn.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/?exciting" bg_position="left top" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#0a0a0a" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" css=".vc_custom_1487084437567{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h5>Salient Powered</h5>
[/vc_column_text][vc_custom_heading text=" it's easy to feel the charm of existence in this spot." use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, they live." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="#" text="Learn More" margin_top="25"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="https://source.unsplash.com/featured/700x500/daily/?happy" alignment="" animation="Grow In" border_radius="10px" box_shadow="large_depth" max_width="100%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Pricing Table 4 Column Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/4-col-pricing.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/daily/?craft" bg_position="left top" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#232323" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?mountains" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Try It Now</h5>
<h2>$5.99</h2>
Get a free domain name and custom cookies delivered to your door every month.

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?happy" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Most Popular</h5>
<h2>$9.99</h2>
Get a free domain name and 24/7 customer support &amp; month of free bandwidth.

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?tech" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Good Value</h5>
<h2>$19.99</h2>
Get a free domain name and 24/7 customer support &amp; design consultation &amp; premium support

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="none" image_url="https://source.unsplash.com/featured/daily/?view" color="Extra-Color-1" box_alignment="center" min_height="400"]
<h5>Ultimate</h5>
<h2>$49.99</h2>
Everything the other plans have plus an annual subscription to nectar magazine

&nbsp;

[nectar_cta btn_style="see-through" heading_tag="h5" link_type="regular" alignment="center" link_text="Purchase now"][/fancy_box][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'FAQ Toggles And Image', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/faq-and-img.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/1600x900/daily/?underwater" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#1c1c1c" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#1e1e1e" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1505433788851{margin-bottom: 30px !important;}"]
<h3>Salient Studio changes the WordPress game forever.</h3>
[/vc_column_text][toggles style="minimal_small" accordion="true"][toggle color="Default" title="Over 200 Section Templates"][vc_column_text]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque.[/vc_column_text][/toggle][toggle color="Default" title="Available Directly in Page Builder"][vc_column_text]Malesuada fames ac turpis egestas. Ut non enim eleifend felis pretium feugiat. Vivamus quis mi.[/vc_column_text][/toggle][toggle color="Default" title="One Click Template Insert"][vc_column_text]Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero.[/vc_column_text][/toggle][/toggles][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="" text="Learn More" margin_top="40"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/featured/800x600/daily/?whale" alignment="" animation="Fade In From Right" border_radius="10px" box_shadow="x_large_depth" max_width="100%"][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Huge Image Transition Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-trans.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/daily/?music" bg_position="center top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="16%" bottom_padding="16%" id="intro" row_name="Intro" enable_gradient="true" color_overlay="rgba(16,16,16,0.2)" color_overlay_2="#101010" gradient_direction="top_to_bottom" overlay_strength="image_trans"][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Salient" font_container="tag:h1|font_size:103|text_align:center|color:%23ffffff|line_height:116px" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_btn size="large" button_style="see-through-3" color_override="#3452ff" hover_color_override="#3452ff" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="View Tour Dates" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#101010" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="THE STORY" font_container="tag:h5|font_size:14|text_align:center|color:%233452ff|line_height:24px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text css=".vc_custom_1486330423766{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h3>An American progressive band from Washington, D.C</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layout Text Block Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-text-block.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#101010" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="THE STORY" font_container="tag:h5|font_size:14|text_align:center|color:%233452ff|line_height:24px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text css=".vc_custom_1486330423766{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h3>An American progressive band from Washington, D.C</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth." font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.69)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Pricing Table', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal_pricing.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="4%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][pricing_table style="flat-alternative" columns="3"][pricing_column color="Extra-Color-1" title="Free" price="0.00" currency_symbol="$" interval="Per Month" id="1435950853864-5" tab_id="1435950853865-3"]<ul class="features"><li>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Custom Domain</li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] 24/7 Customer Support</del></li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Month Of Free Bandwidth</del></li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Free WordPress Setup</del></li><li><del>[icon color="Extra-Color-1" size="tiny" image="fa-check"] Cake Delivered Daily</del></li></ul>[button color="see-through" hover_text_color_override="#fff" size="large" url="#" text="Get Free" color_override="#3a6ee8" image="default-arrow"][/pricing_column][pricing_column color="Extra-Color-2" title="Plus" price="7.99" currency_symbol="$" interval="Per Month" id="1435950853864-2" tab_id="1435950853865-2"]<ul class="features"><li>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Custom Domain</li><li>[icon color="Extra-Color-2" size="tiny" image="fa-check"] 24/7 Customer Support</li><li>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Month Of Free Bandwidth</li><li><del>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Free WordPress Setup</del></li><li><del>[icon color="Extra-Color-2" size="tiny" image="fa-check"] Cake Delivered Daily</del></li></ul>[button color="see-through" hover_text_color_override="#fff" size="large" url="#" text="Sign Up Now" color_override="#fd0025" image="default-arrow"][/pricing_column][pricing_column highlight="true" color="Accent-Color" title="Premium" highlight_reason="Recommended" price="19.99" currency_symbol="$" interval="Per Month" id="1435950853953-5" tab_id="1435950853954-0"]<ul class="features"><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Custom Domain</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] 24/7 Customer Support</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Month Of Free Bandwidth</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Free WordPress Setup</li><li>[icon color="Accent-Color" size="tiny" image="fa-check"] Cake Delivered Daily</li></ul>[button size="large" url="#" text="Sign Up Now" color="Accent-Color" image="default-arrow"][/pricing_column][/pricing_table][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" bottom_padding="4%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<h4>Are there more plans?</h4>[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec porta, mi ut facilisis ullamcorper, magna risus vehicula augue, eget faucibus magna massa at justo. Nulla a arcu ut massa hendrerit.[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<h4>Plan Discounts</h4>[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec porta, mi ut facilisis ullamcorper, magna risus vehicula augue, eget faucibus magna massa at justo. Nulla a arcu ut massa hendrerit[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Team Members Full Width Meta Overlaid', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['team'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'team about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-meta-overlaid.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" name="Jake Graham" image_url="https://source.unsplash.com/BZ2PNGD5Emw/500x500" job_position="Founder"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/tBt9JxuQBYs/500x500" name="Aura Brooks" job_position="Graphic Designer"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/R5tHd-aYmPs/500x500" name="Eve Crawford" job_position="Product Designer"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="1%" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/HZGkX1vKJvo/500x500" name="Alex Parker" job_position="Founder"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/featured/daily/?face" name="Ashley Collins" job_position="Graphic Designer"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member team_memeber_style="meta_overlaid_alt" image_url="https://source.unsplash.com/5lexwsAzUT4/500x500" name="Luke Smith" job_position="Web Developer"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Incisive Text Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/three-cols.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" css=".vc_custom_1486920762999{margin-bottom: 15px !important;}"]
<h4>Customer Support</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1486920757884{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css_animation="none" css=".vc_custom_1486920768475{margin-bottom: 15px !important;}"]
<h4>Web Design</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1486920774094{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text css_animation="none" css=".vc_custom_1486920745710{margin-bottom: 15px !important;}"]
<h4>Quality Assurance</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1486920740195{padding-right: 10% !important;}"][nectar_cta heading_tag="h5" text_color="#3452ff" link_type="regular" alignment="left" link_text="Discover More" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Enhanced Recent Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent_posts.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#eaeaea" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="classic_enhanced" category="all" columns="3" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="View All Posts" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Youtube Video Background Row With Video Lightbox', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/youtube-video-bg.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" video_bg="use_video" video_external="https://www.youtube.com/watch?v=4BfKFCOCJe8" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" enable_gradient="true" color_overlay="#585b64" color_overlay_2="#2c2f38" gradient_direction="left_to_right" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Overflowing Left Of Screen & Gradient Header', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/img-overflow-left.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="4%" bottom_padding="4%" id="save-time" row_name="Save Time" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="7/12" tablet_text_alignment="default" phone_text_alignment="default"][image_with_animation image_url="http://themenectar.com/dummy_data_creation/wp-content/uploads/2016/07/app-1.jpg" alignment="right" animation="Fade In From Left" box_shadow="none" max_width="165%"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="5/12" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="diagonal" text="Save Yourself Time By Using Salient"][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" delay="150"][vc_column_text]Handling how you manage payments online is very important. Salient is a new innovative and easy to use method of sending &amp; receiving money online. It's fast, secure and free to sign up.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" delay="300"][fancy-ul icon_type="standard_dash" color="Extra-Color-3"]
<ul>
	<li>Top Customer Support</li>
	<li>Most Liked Company</li>
	<li>Best In Class 2016</li>
	<li>Friendliest Group</li>
	<li>Innovative Brand</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Flip Box Carousel', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/flipbox-carousel.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" id="core-features" row_name="Core Features" overlay_strength="0.3"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1469639641867{padding-bottom: 10px !important;}"]
<h2>Our Awesome Core Features</h2>
[/vc_column_text][divider line_type="Small Line" line_thickness="3" divider_color="extra-color-1" animate="yes" custom_height="30" custom_line_width="120" delay="100"][vc_column_text max_width="450"]<span style="color: #999999;">There are countless reasons why our service is better than the rest, but here you can learn about why we're different.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][carousel script="owl_carousel" desktop_cols="3" desktop_small_cols="2" tablet_cols="2" mobile_cols="1" column_padding="15px" enable_animation="true" delay="100"][item id="1485907949923-10af59-8004" title="Item" tab_id="1485999357987-9"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/467163/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/467163/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Use It Anywhere</h3>
Nullam gravida tellus lectus, in bibendum quam euismod" min_height="300" icon_size="44" icon_steadysets="steadysets-icon-map"]
<h3>Use It Anywhere</h3>
This is an amazing Nectar Flip Box element. Any content can be displayed on both sides to suit your specific project needs.[/nectar_flip_box][/item][item id="1485907949937-4af59-8004" title="Item" tab_id="1485999358001-10"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/310797/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/310797/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Secure Payments</h3>
Duis lorem magna, bibendum sed suscipit ut nec mauris." min_height="300" icon_size="44" icon_steadysets="steadysets-icon-lock"]
<h3>Secure Payments</h3>
You have control over the background image &amp; color in addition to the optional color overlay as well.[/nectar_flip_box][/item][item id="1485907949953-10af59-8004" title="Item" tab_id="1485999358019-1"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/190727/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/190727/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Detailed Statistics</h3>
In pharetra imperdiet facilisis. Integer elementum augue" min_height="300" icon_size="44" icon_steadysets="steadysets-icon-browser"]
<h3>Detailed Statistics</h3>
You also can control the flip direction. This example shows the "horizontal flip to left" option exclusively though.[/nectar_flip_box][/item][item id="1485907949982-6af59-8004" title="Item" tab_id="1485999358051-10"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/467163/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="steadysets" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/467163/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Scheduled Payments</h3>
Nullam gravida tellus lectus, in bibendum quam euismod" min_height="300" icon_size="44" icon_steadysets="steadysets-icon-bookmark"]
<h3>Scheduled Payments</h3>
You can also control the X and Y axis for content positioning. This example shows all set to the middle.[/nectar_flip_box][/item][item id="1485907950009-2af59-8004" title="Item" tab_id="1485999358072-7"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/422400/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_color="Extra-Color-1" image_url_2="https://source.unsplash.com/collection/422400/daily" bg_color_2="#0a0a0a" bg_color_overlay_2="true" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Visa Gateway</h3>
Interdum et malesuada fames ac ante ipsum primis" min_height="300" icon_size="42" icon_fontawesome="fa fa-credit-card"]
<h3>Visa Gateway</h3>
These flip boxes are also placed within a carousel element which is completely optional. They can live in regular columns if desired.[/nectar_flip_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Pricing Table Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-pricing.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#1c1c1c" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" font_color="#919191" width="1/3" column_border_width="2px" column_border_color="#3a3a3a" column_border_style="solid"][vc_column_text css=".vc_custom_1485706251777{margin-bottom: 5px !important;}"]
<h5>Basic</h5>
[/vc_column_text][vc_custom_heading text="$10" font_container="tag:h2|font_size:80|text_align:center|color:%23ffffff|line_height:80px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="/month" font_container="tag:h4|font_size:24|text_align:center|color:%23ffffff|line_height:34px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="40"][fancy-ul icon_type="none" alignment="center"]
<ul>
 	<li>Custom Domain</li>
 	<li>24/7 Customer Support</li>
 	<li>Month Of Free Bandwidth</li>
 	<li>-</li>
 	<li>-</li>
 	<li>-</li>
 	<li>-</li>
</ul>
[/fancy-ul][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="Buy Now" margin_top="20" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" font_color="#919191" width="1/3" column_border_width="2px" column_border_color="#3a3a3a" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485706256916{margin-bottom: 5px !important;}"]
<h5>Premium</h5>
[/vc_column_text][vc_custom_heading text="$20" font_container="tag:h2|font_size:80|text_align:center|color:%23ffffff|line_height:80px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="/month" font_container="tag:h4|font_size:24|text_align:center|color:%23ffffff|line_height:34px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="40"][fancy-ul icon_type="none" alignment="center"]
<ul>
 	<li>Custom Domain</li>
 	<li>24/7 Customer Support</li>
 	<li>Month Of Free Bandwidth</li>
 	<li>Free WordPress Setup</li>
 	<li>Cake Delivered Daily</li>
 	<li>-</li>
 	<li>-</li>
</ul>
[/fancy-ul][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="Buy Now" margin_top="20" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" font_color="#919191" width="1/3" column_border_width="2px" column_border_color="#3a3a3a" column_border_style="solid" delay="200"][vc_column_text css=".vc_custom_1485706261609{margin-bottom: 5px !important;}"]
<h5>Developer</h5>
[/vc_column_text][vc_custom_heading text="$40" font_container="tag:h2|font_size:80|text_align:center|color:%23ffffff|line_height:80px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="/month" font_container="tag:h4|font_size:24|text_align:center|color:%23ffffff|line_height:34px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="40"][fancy-ul icon_type="none" alignment="center"]
<ul>
 	<li>Custom Domain</li>
 	<li>24/7 Customer Support</li>
 	<li>Month Of Free Bandwidth</li>
 	<li>Free WordPress Setup</li>
 	<li>Cake Delivered Daily</li>
 	<li>Premium Support</li>
 	<li>Design Consultation</li>
</ul>
[/fancy-ul][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="iconsmind" url="#" text="Buy Now" margin_top="20" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Overflowing Right Of Screen & Numerical Icon List', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/img-overflow-right.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ecf7ff" scene_position="center" text_color="dark" text_align="left" id="steps" row_name="Sign Up Steps" overlay_strength="0.3"][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][nectar_icon_list animate="true" color="default" icon_size="small" icon_style="border"][nectar_icon_list_item icon_type="numerical" title="List Item" id="1469496380463-1039da-01ea" header="Sign Up For Free" text="Create your free account in a matter of minutes with our patented awesome sign up process." tab_id="1485703048239-5"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1469496380621-239da-01ea" header="Sell Goods Online" text="Next start integrating it with your e-commerce platform of choice and start accepting payments." tab_id="1485703048245-4"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1469496416453-939da-01ea" header="Love Your Life" text="Sit back, relax and pop a cold one because your life just got a whole lot easier by using Salient." tab_id="1485703048251-2"][/nectar_icon_list_item][/nectar_icon_list][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="http://themenectar.com/dummy_data_creation/wp-content/uploads/2016/07/laptop.jpg" alignment="" animation="Fade In From Right" box_shadow="none" max_width="175%"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Simple Text Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/text-columns.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="40" bottom_padding="35" text_align="left"][vc_column_inner enable_animation="true" animation="none" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="default" animate="yes" custom_height="1"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-King-2" icon_size="36"][vc_column_text css=".vc_custom_1486918825917{padding-bottom: 10px !important;}"]
<h5>Who are we</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1486918759317{padding-right: 10% !important;}"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Duplicate-Window" icon_size="36"][vc_column_text css=".vc_custom_1486918830515{padding-bottom: 10px !important;}"]
<h5>What we do</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1486919428207{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Testimonial Slider Parallax', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/parallax-testimonial.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/rMmibFe4czY" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#383838" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][testimonial_slider style="minimal" star_rating_color="accent-color" disable_height_animation="true"][testimonial star_rating="none" title="Testimonial" id="1475858133769-1f702-2797" name="Eve Crawford" subtitle="Product Designer" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel at ease. The design ended up being better than I could have envisioned!" tab_id="1486839778816-4"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="none" title="Testimonial" id="1475858133938-7f702-2797" name="Aura Brooks" subtitle="Graphic Designer" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team!" tab_id="1486839779007-9"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="none" title="Testimonial" id="1475867833938-7f702-2797" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site!" tab_id="1486839779963-10"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="none" title="Testimonial" id="1475858133939-7f702-2797" name="Jack Graham" subtitle="Co Founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" tab_id="1486839779323-6"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Practical Map & Contact Info Split', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['google_map'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/map-color-split.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" bg_color="#141414" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][nectar_gmap zoom="6" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" ultra_flat="1" dark_color_scheme="1" size="750" map_center_lat="40.793" map_center_lng="-73.954" map_markers="37.748458|-122.475586|Our Location
40.793|-73.954|Our Location #2"][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="padding-8-percent" column_padding_position="all" background_color="#3452ff" background_color_opacity="0.9" background_hover_color_opacity="1" background_image="123" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="300"][vc_column_text css_animation="none"]
<h3>Contact.</h3>
We’re currently in look of a few new designers – If you’re a passionate worker and think you have what it takes, send your resume and details to for all opportunities.

&nbsp;
<h5>San Francisco</h5>
123 Nectar St. Suite 4917
hello@themenectar.com
<h5></h5>
<h5>New York</h5>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Map & Contact Info Split', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['google_map'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/map-split-light.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="16" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" dark_color_scheme="1" size="750" map_center_lat="39.949" map_center_lng="-75.172" map_markers="39.949|-75.171|
"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Contact.</h3>
We’re currently in look of a few new designers – If you’re a passionate worker and think you have what it takes, send your resume and details to <a href="http://themenectar.com/demo/salient-corporate/contact/#">jobs@demo.com</a> for all opportunities.

&nbsp;
<h5>San Francisco</h5>
123 Nectar St. Suite 4917
hello@themenectar.com
<h5></h5>
<h5>New York</h5>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'The Awards Section Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-awards.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.95"][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486836945876{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h2>They Appreciate Us</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Design Awards" col_2_content="Nectar Convention" col_3_content="2016-01-23"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="UI Convention" col_2_content="Salient Awards" col_3_content="2016-04-12"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Web Design Envy" col_2_content="ThemeNectar" col_3_content="2016-06-15"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Design Fusion" col_2_content="Salient Team" col_3_content="2016-07-28"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" font_family="p" hover_color="accent-color" col_1_content="Nectar Gathering" col_2_content="Frostwave" col_3_content="2016-09-23"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Well-made Intro Section Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-text-section.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h3>If you wish to make an apple</h3>
<h3>pie from scratch, you must first</h3>
<h3>invent the universe.</h3>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.71)" use_theme_fonts="yes" css=".vc_custom_1486839091142{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.71)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="default_arrow" url="#" text="Start a project" css_animation="none" margin_top="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fullscreen Recent Project Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'portfolio hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-proj-slider.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_projects category="all" project_style="fullscreen_zoom_slider" slider_controls="both" slider_text_color="light" overlay_strength="0.4" number_to_display="10"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Dark About Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'];
$data['custom_class'] = 'about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-about.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" full_height="yes" columns_placement="stretch" bg_color="#141414" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Philip Martinez" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1485193607322{margin-bottom: 10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text css=".vc_custom_1485195197203{margin-top: 30px !important;margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Facebook-2" icon_size="29" margin_left="-20px" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Twitter" icon_size="29" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Dribble" icon_size="29" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/daily/?personsitting" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="300"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Video Background Testimonial Slider Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'testimonials about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-bg-testimonials.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#333333" scene_position="center" video_bg="use_video" enable_video_color_overlay="true" video_overlay_color="#000000" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" id="services" overlay_strength="0.3"][vc_column enable_animation="true" animation="flip-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][testimonial_slider style="default"][testimonial name="Carly Young, ThemeNectar" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you won't find any better!" id="1484513879050-1f107-50ab" title="Testimonial" tab_id="1485366100980-9"][/testimonial][testimonial name="Jeff Gemmell, ThemeNectar" quote="It was really fun getting to know the team during the project. They were all helpful in answering questions and made me feel at ease. The design ended up being better than I could've envisioned!" id="1484513879156-2f107-50ab" title="Testimonial" tab_id="1485366100985-3"][/testimonial][testimonial name="Mark Levin, ThemeNectar" quote="I'm wondering why I never contacted these guys sooner! They have commendable talent in their fields and knocked my concept out of the ballpark. An amazing experience!" id="1484513879236-7f107-50ab" title="Testimonial" tab_id="1485366101002-0"][/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Restaurant Food Menu (Tabbed)', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/food-menu.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="3%" bottom_padding="5%" text_align="left" id="menu"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="2px" column_border_color="#000000" column_border_style="double_offset" enable_border_animation="true"][vc_column_text]
<h3>The Menu</h3>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][tabbed_section style="minimal_alt" alignment="center" cta_button_style="extra-color-3"][tab title="Breakfast &amp; Brunch" id="1483371702-1-88" tab_id="1483371715854-2"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484520003986{margin-bottom: 30px !important;}"]
<h5>The Griddle</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Western Sunrise" text="$9" item_price="$19" item_description="Two fried eggs with cheese &amp;two breakfast meats made to perfection"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$17" item_description="You know it's good, just order it"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Fried Eggs &amp; Ham" text="$9" item_price="$12" item_description="It's just plain and simple, but also tasty"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484520027757{margin-bottom: 30px !important;}"]
<h5>Omelettes &amp; Skillets</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Mr. Nectar Benedict " text="$9" item_price="$13" item_description="The best grilled English muffin, two poached eggs"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Great Waffles" text="$9" item_price="$17" item_description="Chocolate chips, imported syrup"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Country`` Breakfast" text="$9" item_price="$12" item_description="Biscuits with fresh sausage patties &amp; country gravy"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484520078924{margin-bottom: 30px !important;}"]
<h5>Pancakes</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="American Pancakes" text="$9" item_price="$9" item_description="Large stack of three with maple syrup "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Danish Style Pancakes" text="$9" item_price="$7" item_description="Served with pigs in a blanket"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Sweet Tooth" text="$9" item_price="$9" item_description="Basically just a dessert "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Can't make up my mind``" text="$9" item_price="$12" item_description="Served with a sample of French toast"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="2px" column_border_color="#3452ff" column_border_style="double_offset" enable_border_animation="true"][vc_column_text css=".vc_custom_1484520037671{margin-bottom: 30px !important;}"]
<h5>Breakfast Specials</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Salient Style" text="$9" item_price="$17" item_description="Three scrambled eggs, bacon &amp; a side of hash browns"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Really Good Stuff" text="$9" item_price="$12" item_description="It's just plain and simple"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$11" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left" css=".vc_custom_1486083303611{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Sodas" text="$9" item_price="$4" item_description="Coca cola, Pepsi, Sprite, Fanta, Nectar Soda, Salient Fizz"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Tea" text="$9" item_price="$6" item_description="Green, Red, Black, Yellow, White Warm &amp; Hot"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Juices" text="$9" item_price="$3" item_description="Orange, Apple, Vegetable, Strawberry, Blackberry, Lime"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Water" text="$9" item_price="$1" item_description="Tap, Distilled, Reverse Osmosis "][/vc_column_inner][/vc_row_inner][/tab][tab title="Lunch" id="1486682634354-4-7" tab_id="1483371745398-1"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682668056{margin-bottom: 30px !important;}"]
<h5>Appetizers</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Shrimp Cocktail" text="$9" item_price="$10" item_description="A little shrimp, a little cocktail "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Fried Mozzarella " text="$9" item_price="$8" item_description="It's just plain and simple, but also tasty"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$11" item_description="You know it's good, just order it"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682675326{margin-bottom: 30px !important;}"]
<h5>Pasta</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar Linguine " text="$9" item_price="$15" item_description="The best pasta you'll ever eat"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Ravioli " text="$9" item_price="$17" item_description="Cooked to perfection by Chef Nectar "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Very Big`` Bowl" text="$9" item_price="$22" item_description="Made to share, four separate samples in one "][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682685532{margin-bottom: 30px !important;}"]
<h5>Sandwiches</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Italian" text="$9" item_price="$13" item_description="Smoked ham, peppers and your choice of cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Double Decker Club" text="$9" item_price="$12" item_description="Grilled chicken, tomato and cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic BLT" text="$9" item_price="$13" item_description="Bacon, Lettuce and Tomatoes "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Can't make up my mind``" text="$9" item_price="$12" item_description="Served with a sample of everything"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="2px" column_border_color="#3452ff" column_border_style="double_offset" enable_border_animation="true"][vc_column_text css=".vc_custom_1486682692238{margin-bottom: 30px !important;}"]
<h5>Lunch Specials</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Salient Style" text="$9" item_price="$17" item_description="Warn homemade chicken with melted cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Really Good Stuff" text="$9" item_price="$12" item_description="It's just plain and simple"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$11" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left" css=".vc_custom_1486083303611{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Sodas" text="$9" item_price="$4" item_description="Coca cola, Pepsi, Sprite, Fanta, Nectar Soda, Salient Fizz"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Tea" text="$9" item_price="$6" item_description="Green, Red, Black, Yellow, White Warm &amp; Hot"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Juices" text="$9" item_price="$3" item_description="Orange, Apple, Vegetable, Strawberry, Blackberry, Lime"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Water" text="$9" item_price="$1" item_description="Tap, Distilled, Reverse Osmosis "][/vc_column_inner][/vc_row_inner][/tab][tab title="Dinner" id="1486683129769-4-9" tab_id="1483371745354-1"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486682668056{margin-bottom: 30px !important;}"]
<h5>Appetizers</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Fried Mozzarella " text="$9" item_price="$8" item_description="It's just plain and simple, but also tasty"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Shrimp Cocktail" text="$9" item_price="$10" item_description="A little shrimp, a little cocktail "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$11" item_description="You know it's good, just order it"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683213935{margin-bottom: 30px !important;}"]
<h5>Salads</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Caesar " text="$9" item_price="$13" item_description="Served with choice of chicken &amp; cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Stuffed Tomato" text="$9" item_price="$12" item_description="Chicken Salad stuffed with Roma Tomatoes "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Club Salda" text="$9" item_price="$12" item_description="Fresh romaine lettuce &amp; grated cheese"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683207946{margin-bottom: 30px !important;}"]
<h5>Pasta</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Ravioli " text="$9" item_price="$27" item_description="Cooked to perfection by Chef Nectar "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar Linguine " text="$9" item_price="$25" item_description="The best pasta you'll ever eat"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Vodka Sauce" text="$9" item_price="$22" item_description="With Grilled chicken, tomato and cheese "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="``Very Big`` Bowl" text="$9" item_price="$22" item_description="Made to share, four separate samples in one "][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="2px" column_border_color="#3452ff" column_border_style="double_offset" enable_border_animation="true"][vc_column_text css=".vc_custom_1486683185332{margin-bottom: 30px !important;}"]
<h5>Steak &amp; Seafood</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Salient Filet" text="$9" item_price="$37" item_description="Served best medium rare "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Oscar Salient FIlet" text="$9" item_price="$42" item_description="The Salient Filet with crab meat"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$31" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left" css=".vc_custom_1486083303611{padding-right: 2% !important;padding-left: 2% !important;}"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Sodas" text="$9" item_price="$4" item_description="Coca cola, Pepsi, Sprite, Fanta, Nectar Soda, Salient Fizz"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Tea" text="$9" item_price="$6" item_description="Green, Red, Black, Yellow, White Warm &amp; Hot"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Juices" text="$9" item_price="$3" item_description="Orange, Apple, Vegetable, Strawberry, Blackberry, Lime"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][nectar_food_menu_item style="default" item_name_heading_tag="h4" item_name="Water" text="$9" item_price="$1" item_description="Tap, Distilled, Reverse Osmosis "][/vc_column_inner][/vc_row_inner][/tab][tab title="Drink List" id="1486683598327-4-5" tab_id="1483371745312-1"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683632214{margin-bottom: 30px !important;}"]
<h5>Reds</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Gina Pinot Noir" text="$9" item_price="$8" item_description="Black cherry notes, light bodied "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Guilty Pleasure Merlot" text="$9" item_price="$10" item_description="Medium to full bodied, premium taste"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Classic California" text="$9" item_price="$11" item_description="You know it's good, just order it"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683638682{margin-bottom: 30px !important;}"]
<h5>Whites</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Flawless Pinot Grigo" text="$9" item_price="$10" item_description="Fresh, medium bodied "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Sauvignon Blanc " text="$9" item_price="$12" item_description="The perfect medium bodied white"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Chardon-hey " text="$9" item_price="$12" item_description="Chardonnay with a little twist"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683647410{margin-bottom: 30px !important;}"]
<h5>Rose</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Pacific Heights" text="$9" item_price="$12" item_description="A fun light tasty addition "][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Friday night out" text="$9" item_price="$11" item_description="Medium - full bodied mix"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="The Gavel" text="$9" item_price="$12" item_description="Earthy flavorsome notes "][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486683943715{margin-bottom: 30px !important;}"]
<h5>Blends</h5>
[/vc_column_text][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Petit Verdot " text="$9" item_price="$17" item_description="Once you try it, you'll never want anything else"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Shiraz Dom" text="$9" item_price="$12" item_description="The drink to end your dinner with"][nectar_food_menu_item style="line_between" item_name_heading_tag="h4" item_name="Nectar's Choice" text="$9" item_price="$17" item_description="Ask your server for more details"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Enticing Dual Fancy Box', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'tgeneral about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dual-fancy-box.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#f7f7f7" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box link_new_tab="true" color="Accent-Color" min_height="100" link_url="https://www.google.com/maps" link_text="Get Directions"]
<h3>San Francisco</h3>
123 Nectar St. Suite 4917
hello@themenectar.com[/fancy_box][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][fancy_box image_url="6135" link_new_tab="true" color="Extra-Color-1" min_height="100" link_url="https://www.google.com/maps" link_text="Get Directions"]
<h3>British Columbia</h3>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Innovative Gradient Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'hero_section about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-header.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/430468/daily" bg_position="center center" bg_repeat="no-repeat" bg_color="#454156" scene_position="center" text_color="light" text_align="left" top_padding="9%" bottom_padding="9%" id="intro" row_name="Intro" enable_gradient="true" color_overlay="#0a0a0a" color_overlay_2="rgba(102,102,102,0.74)" gradient_direction="left_b_to_right_t" overlay_strength="0.95"][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="We craft experiences from customer information" font_container="tag:h1|font_size:83|text_align:center|color:%23ffffff|line_height:96px" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1485550874781{margin-top: -10px !important;}"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="We're changing the way people are connected by stories.
" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="Show Me How" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Modern Recent Posts Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-parallax.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/daily" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#eaeaea" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="classic_enhanced_alt" category="all" columns="3" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="View All Posts" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Weather Animated Icon Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['icons'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'icons about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/weather-icons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="center" top_padding="3%" bottom_padding="3%" overlay_strength="0.3"][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color="Extra-Color-1" icon_padding="10px" icon_linea="icon-weather-sunset" icon_size="64"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="10"][vc_column_text]<i>Item No. 01</i>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3>Summer</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color="Extra-Color-1" icon_padding="10px" icon_linea="icon-weather-fog-halfmoon" icon_size="64" animation_delay="300"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][divider line_type="No Line" custom_height="10"][vc_column_text]<i>Item No. 02</i>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3>Fall</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color="Extra-Color-1" icon_padding="10px" icon_linea="icon-weather-snow-halfmoon" icon_size="64" animation_delay="600"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="1000"][divider line_type="No Line" custom_height="10"][vc_column_text]<i>Item No. 03</i>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3>Winter</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color="Extra-Color-1" icon_padding="10px" icon_linea="icon-weather-downpour-sun" icon_size="64" animation_delay="900"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="1500"][divider line_type="No Line" custom_height="10"][vc_column_text]<i>Item No. 04</i>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3>Spring</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Exciting Services', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'services icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/services.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="top" bg_image="https://source.unsplash.com/collection/190727/daily" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#1e1e1e" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" enable_gradient="true" color_overlay="#0069ff" color_overlay_2="#ff3a6f" gradient_direction="left_b_to_right_t" overlay_strength="0.95"][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="We Offer Awesome Services" font_container="tag:h2|font_size:88px|text_align:left|line_height:97px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="none"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Diamond" margin_top="20"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485371914654{margin-bottom: 15px !important;}"]
<h4>Design</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637636687{padding-right: 10% !important;}"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Helicopter" margin_top="30"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485371926430{margin-bottom: 15px !important;}"]
<h4>Deploy</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637641512{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Gear-2" margin_top="20"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485371920498{margin-bottom: 15px !important;}"]
<h4>Develop</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637652526{padding-right: 10% !important;}"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Life-Jacket" margin_top="30"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485371933853{margin-bottom: 15px !important;}"]
<h4>Support</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637646805{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Gradient Testimonials With Star Ratings', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/new-testimonials.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#f2f2f2" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][testimonial_slider style="multiple_visible_minimal" star_rating_color="extra-color-gradient-1"][testimonial star_rating="100%" title="Testimonial" id="1485890278273-28f9f-ae83" name="Aura Brooks" subtitle="Graphic Designer, Owl Eyes" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team! " tab_id="1485906261983-10"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="80%" title="Testimonial" id="1485890278280-18f9f-ae83" name="Eve Crawford" subtitle="Product Designer, That Biz" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel completely at ease. The design ended up being twice as good as I could have ever envisioned!" tab_id="1485906261988-8"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="91%" title="Testimonial" id="1485890278299-28f9f-ae83" name="Jack Graham" subtitle="Co founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" tab_id="1485906262005-7"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="91%" title="Testimonial" id="1485890278307-98f9f-ae83" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site! " tab_id="1485906262024-5"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="100%" title="Testimonial" id="1485890278307-98f9f-ae33" name="Jake Smith" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site! " tab_id="1485906262039-2"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Dark Testimonials', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-testimonials.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#202020" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][testimonial_slider style="multiple_visible_minimal" star_rating_color="accent-color" add_border="true"][testimonial star_rating="100%" title="Testimonial" id="1485890278273-2fa6a-5d72" name="Aura Brooks" subtitle="Graphic Designer, Owl Eyes" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team! " tab_id="1485906178798-1"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="80%" title="Testimonial" id="1485890278280-1fa6a-5d72" name="Eve Crawford" subtitle="Product Designer, That Biz" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel completely at ease. The design ended up being twice as good as I could have ever envisioned!" tab_id="1485906178802-3"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="91%" title="Testimonial" id="1485890278299-2fa6a-5d72" name="Jack Graham" subtitle="Co founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" tab_id="1485906178807-9"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="91%" title="Testimonial" id="1485890278307-9fa6a-5d72" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site! " tab_id="1485906178826-9"] Click the edit button to add your testimonial. [/testimonial][testimonial star_rating="100%" title="Testimonial" id="1485890278307-9fa6a-5d61" name="Jake Smith" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site! " tab_id="1485906178832-7"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'About Me - Fullscreen vCard', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['counters'];
$data['custom_class'] = 'about counters';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-me.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" full_height="yes" columns_placement="stretch" bg_color="#232323" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Philip Martinez" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1485193607322{margin-bottom: 10px !important;}"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485195197203{margin-top: 30px !important;margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia[/vc_column_text][bar color="extra-color-gradient-1" title="Web Design" percent="70"][bar color="extra-color-gradient-1" title="UI Design" percent="85"][bar color="extra-color-gradient-1" title="Video Editing" percent="65"][divider line_type="No Line" custom_height="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="black" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Facebook-2" icon_size="29" margin_left="-20px" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="black" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Reddit" icon_size="29" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="black" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Dribble" icon_size="29" url="#"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/166572/daily" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Section CTA', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cta-alt-see-through-btn.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/collection/422400/daily" bg_position="center center" bg_repeat="no-repeat" bg_color="#1e1e1e" scene_position="center" text_color="light" text_align="left" top_padding="5%" bottom_padding="5%" color_overlay="#242838" overlay_strength="0.95"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="left-right" centered_text="true" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Your turn to make a move" font_container="tag:h2|font_size:52|text_align:center|line_height:52px" use_theme_fonts="yes"][divider line_type="No Line" custom_height="10"][vc_custom_heading text="Like Nothing You've Seen. Sign Up Today &amp; Experience Salient" font_container="tag:p|font_size:18|text_align:center|color:rgba(255%2C255%2C255%2C0.7)|line_height:26px" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-3" color_override="#ff3067" hover_color_override="#ff3067" hover_text_color_override="#ffffff" icon_family="fontawesome" url="#" icon_fontawesome="fa fa-long-arrow-right" margin_top="25"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Intense Colorful CTA Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'hero_section cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cta-green.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" overlay_strength="0.3"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485448432282{margin-bottom: 5px !important;}"]
<h5>Look Inside</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1485448368496{margin-bottom: 45px !important;}" max_width="800"]
<h2>Discover Salient App With Our <em>Free Download</em></h2>
[/vc_column_text][divider line_type="No Line" custom_height="10"][nectar_btn size="jumbo" button_style="see-through" button_color_2="Accent-Color" icon_family="fontawesome" url="#" text="Download Now" icon_fontawesome="fa fa-apple"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Motion Blur Milestone', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['counters'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'general counters';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/milestone-motion-blur.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="right" top_padding="8%" bottom_padding="8%" id="reasons" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][milestone symbol_position="after" color="Accent-Color" effect="motion_blur" symbol_alignment="Superscript" number="35" symbol="*" number_font_size="200" symbol_font_size="60"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="20"][vc_column_text]
<h5 style="text-align: left;"><span style="color: #933ded;">Thousand </span></h5>
<h4 style="text-align: left;"><span style="color: #933ded;">Theme Users</span></h4>
<p style="text-align: left;">It takes a lot to be one of the most trusted themes on the market. Read more below why users keep coming back over and over again.</p>

[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Modern Service List', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'icons services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-services.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Our Specialties " font_container="tag:h2|font_size:48px|text_align:center|line_height:57px" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Umbrella-2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629426540{margin-bottom: 15px !important;}"]
<h4>Customer Support</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Diamond" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629480716{margin-bottom: 15px !important;}"]
<h4>Web Design</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Trophy-2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629439769{margin-bottom: 15px !important;}"]
<h4>Quality Assurance</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-T-Shirt" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629445076{margin-bottom: 15px !important;}"]
<h4>eCommerce</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Wolf" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629457675{margin-bottom: 15px !important;}"]
<h4>Event Planning</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Grave" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629467303{margin-bottom: 15px !important;}"]
<h4>Killing Competition</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Three Fullwidth Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/three-col-fullwidth.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="light" text_align="left" top_padding="0" bottom_padding="0" overlay_strength="0.3" background_color="#171920"][vc_column enable_animation="true" animation="flip-in" column_padding="padding-4-percent" column_padding_position="all" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][vc_column_text]
<h3>A Breeze To Build With</h3>
Take full control of the power Salient has to offer with our new exciting page builder. You'll be grinning in delight when you see just how easy it is to create stunning layouts with little effort.[/vc_column_text][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" icon_family="steadysets" url="#" text="Discover More" icon_steadysets="steadysets-icon-diamond" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="flip-in" column_padding="padding-4-percent" column_padding_position="all" background_color="#ff1e5a" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][vc_column_text]
<h3>Tutorials To Help</h3>
The days of being overwhelmed by long documents without any visual guidance are over - We have an entire video tutorial series available for you that's narrated through the duration.[/vc_column_text][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" icon_family="steadysets" url="#" text="See The Tutorials" icon_steadysets="steadysets-icon-screen" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="flip-in" column_padding="padding-4-percent" column_padding_position="all" background_color="#42d671" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][vc_column_text]
<h3>Show Off In Style</h3>
The looks &amp; functionality you've been dying for are finally easily accessible. We know you'll enjoy the freedom to showcase your content in the way that it deserves.[/vc_column_text][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" icon_family="steadysets" url="#" text="Shine Like A Star" icon_steadysets="steadysets-icon-star" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Interesting Milestones', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['counters'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'counters about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/milestone-interesting.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/QfEfkWk1Uhk" background_image_mobile_hidden="true" bg_position="center top" bg_repeat="no-repeat" scene_position="center" text_color="dark" text_align="left" top_padding="13%" bottom_padding="13%" enable_gradient="true" color_overlay="#f2f2f2" color_overlay_2="rgba(242,242,242,0.01)" gradient_direction="top_to_bottom" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Business Increase" font_container="tag:h5|text_align:left|color:%23a5a5a5" use_theme_fonts="yes" css=".vc_custom_1486418466709{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" symbol_position="after" subject_padding="2%" color="Accent-Color" effect="count" symbol_alignment="Superscript" milestone_alignment="left" number="87" symbol="%" number_font_size="92" symbol_font_size="40"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="New Accounts" font_container="tag:h5|text_align:left|color:%23a5a5a5" use_theme_fonts="yes" css=".vc_custom_1486418472478{margin-bottom: 10px !important;}"][milestone heading_inherit="h5" subject_padding="2%" color="Accent-Color" effect="count" milestone_alignment="left" number="247" number_font_size="92"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="The Difference" font_container="tag:h5|text_align:left|color:%23a5a5a5" use_theme_fonts="yes" css=".vc_custom_1486418478917{margin-bottom: 10px !important;}"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Experience true business performance increases" font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Learn More" margin_top="25"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Alternating Split Sections', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/alt-split.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color="#f4f4f4" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Our Company Values" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1486408368541{margin-bottom: 10px !important;}"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.6)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/Nj0mCM6nikI" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/nvzvOPQW0gc" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="A Little Of Our Story" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1486408382586{margin-bottom: 10px !important;}"][vc_custom_heading text="We were simply born to paint pixels for a living" font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia" font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.6)" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="See Our Story" margin_top="30"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Flawless Business Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'hero_section about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/business-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/UmWW77lYEcA" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" top_padding="4%" bottom_padding="4%" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" top_padding="15%" bottom_padding="14%" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-lg-6 vc_col-md-6 vc_col-xs-12"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426562428{margin-bottom: 15px !important;}"]
<h5>Let's Do This</h5>
[/vc_column_text][split_line_heading]
<h2>We're Salient, A Creative</h2>
<h2>Startup Based in Philly</h2>
[/split_line_heading][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="#" text="Learn More" margin_top="25" css_animation="slideInUp"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][vc_custom_heading text=" " google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:100%20light%20regular%3A100%3Anormal"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-6-percent" column_padding_position="bottom" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426628130{margin-bottom: 15px !important;}"]
<h5>There For You</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418797897{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426637035{margin-bottom: 15px !important;}"]
<h5>Pristine Quality</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418801921{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426643514{margin-bottom: 15px !important;}"]
<h5>Heavily Awarded</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418805797{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1486426698874{margin-bottom: 15px !important;}"]
<h5>Documentation</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word, far from the countries." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486418809890{padding-right: 20% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Phone & Icon List', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/phone-icons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Refresh" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485632968860{margin-bottom: 15px !important;}"]
<h4>AJAX Loading</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia place." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][divider line_type="No Line" custom_height="40"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-T-Shirt" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629445076{margin-bottom: 15px !important;}"]
<h4>eCommerce</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia place." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/phone-normal.jpg" alignment="" animation="None" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Quill-2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485632976739{margin-bottom: 15px !important;}"]
<h4>UI Design</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia place." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][divider line_type="No Line" custom_height="40"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Trophy-2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485629439769{margin-bottom: 15px !important;}"]
<h4>Quality Assurance</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia place." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Cascading Image & Text Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'];
$data['custom_class'] = 'about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-highlight.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/collection/179646/daily" bg_position="left top" bg_repeat="no-repeat" bg_color="#6a6b6f" scene_position="center" text_color="light" text_align="left" top_padding="5%" bottom_padding="5%" id="built-by-riders" row_name="Built By Riders" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#2b4bff" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="0%" image_1_rotate_sign="+" image_1_rotate="none" image_1_animation="Grow In" image_1_box_shadow="none" image_2_url="https://unsplash.it/500/350/" image_2_offset_x_sign="+" image_2_offset_x="15%" image_2_offset_y_sign="+" image_2_offset_y="25%" image_2_rotate_sign="+" image_2_rotate="none" image_2_animation="Grow In" image_2_box_shadow="none" image_3_url="https://unsplash.it/570/370/" image_3_offset_x_sign="-" image_3_offset_x="30%" image_3_offset_y_sign="-" image_3_offset_y="30%" image_3_rotate_sign="+" image_3_rotate="none" image_3_animation="Grow In" image_3_box_shadow="x_large_depth" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_animation="Fade In" image_4_box_shadow="none"][/vc_column][vc_column enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_animated_title heading_tag="h6" style="color-strip-reveal" color="Extra-Color-1" text="Handmade Quality "][vc_column_text]
<h2>Built By Actual Riders</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1485702321346{margin-top: 20px !important;padding-right: 10% !important;}"]Everyone at Salient bike industries is a die hard rider, and what this translates into ultimately is a higher quality product. We know the trails you want to go on so rest assured; we know exactly what's needed to handle them.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Gradient Pricing Columns', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'pricing services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-pricing.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f7f7f7" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" id="pricing" row_name="Pricing" overlay_strength="0.95"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" centered_text="true" width="1/1"][vc_column_text css=".vc_custom_1469641915676{padding-bottom: 10px !important;}"]
<h2>Affordable Pricing</h2>
[/vc_column_text][divider line_type="Small Line" line_thickness="3" divider_color="extra-color-gradient-1" animate="yes" custom_height="30" custom_line_width="120" delay="100"][vc_column_text max_width="450" css=".vc_custom_1469652796078{margin-bottom: 30px !important;}"]<span style="color: #999999;">You've reached the pricing plans. Choose from one of our three plans or start your free 30 day trial risk-free.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" boxed="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" centered_text="true" width="1/3" column_link="#"][vc_column_text]
<h5>Basic</h5>
[/vc_column_text][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="horizontal" text="$10"][nectar_gradient_text heading_tag="h6" color="extra-color-gradient-1" gradient_direction="horizontal" text="/month" margin_top="-40px"][vc_column_text css=".vc_custom_1469649138903{margin-top: -20px !important;}"]Up to 5 Users[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" boxed="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" centered_text="true" width="1/3" delay="200" column_link="#"][vc_column_text]
<h5>Premium</h5>
[/vc_column_text][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="horizontal" text="$20"][nectar_gradient_text heading_tag="h6" color="extra-color-gradient-1" gradient_direction="horizontal" text="/month" margin_top="-40px"][vc_column_text css=".vc_custom_1469649167245{margin-top: -20px !important;}"]Up to 50 Users[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" boxed="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" centered_text="true" width="1/3" delay="400" column_link="#"][vc_column_text]
<h5>Developer</h5>
[/vc_column_text][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="horizontal" text="$40"][nectar_gradient_text heading_tag="h6" color="extra-color-gradient-1" gradient_direction="horizontal" text="/month" margin_top="-40px"][vc_column_text css=".vc_custom_1469649229899{margin-top: -20px !important;}"]No Limit On Users[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Fullscreen Pricing Grid', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['pricing'];
$data['custom_class'] = 'pricing';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-pricing-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" full_height="yes" columns_placement="stretch" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-7-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_color_hover="#f4f4f4" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Basic</h5>
[/vc_column_text][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="horizontal" text="$10"][nectar_gradient_text heading_tag="h6" color="extra-color-gradient-1" gradient_direction="horizontal" text="/month" margin_top="-40px"][vc_column_text css=".vc_custom_1485375453676{margin-top: 20px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic[/vc_column_text][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#0a0101" icon_family="iconsmind" url="#" text="Buy Now" margin_top="80" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column][vc_column centered_text="true" column_padding="padding-7-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_color_hover="#f4f4f4" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Premium</h5>
[/vc_column_text][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="horizontal" text="$20"][nectar_gradient_text heading_tag="h6" color="extra-color-gradient-1" gradient_direction="horizontal" text="/month" margin_top="-40px"][vc_column_text css=".vc_custom_1485375453676{margin-top: 20px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic[/vc_column_text][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#0a0101" icon_family="iconsmind" url="#" text="Buy Now" margin_top="80" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column][vc_column centered_text="true" column_padding="padding-7-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_color_hover="#f4f4f4" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Developer</h5>
[/vc_column_text][nectar_gradient_text heading_tag="h1" color="extra-color-gradient-1" gradient_direction="horizontal" text="$40"][nectar_gradient_text heading_tag="h6" color="extra-color-gradient-1" gradient_direction="horizontal" text="/month" margin_top="-40px"][vc_column_text css=".vc_custom_1485375453676{margin-top: 20px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic[/vc_column_text][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#0a0101" icon_family="iconsmind" url="#" text="Buy Now" margin_top="80" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Full Width Parallax Posts Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-slider-full.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="slider" category="all" slider_size="650" posts_per_page="3"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Color CTA Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/color-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="60" bottom_padding="60" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Sign Up Today" font_container="tag:h5|text_align:left" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Get 30 days free when you create an account" font_container="tag:h5|text_align:center" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="10"][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" icon_family="none" url="#" text="Sign Up Now" margin_bottom="0"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Video Lightbox  Inline With Text', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/374707/daily" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" font_style="h3" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="Watch Our Intro Video"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Layout Text Block', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/text-block.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="THE STORY" font_container="tag:h5|font_size:14|text_align:center|color:%233452ff|line_height:24px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text css=".vc_custom_1486153382692{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h3>A Good Design Solves A Problem. A Bad Design Will Create One.</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Imaginative Video CTA Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'cta general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/right-gradient-section.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/faAVWMeB3dw" bg_position="center center" bg_repeat="no-repeat" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" enable_gradient="true" color_overlay="rgba(10,10,10,0.2)" color_overlay_2="#000000" gradient_direction="left_to_right" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h3>Let's Change How We</h3>
<h3>Manage Business</h3>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" font_style="p" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="View Explainer Video"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Parallax Posts Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-slider.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="slider" category="all" slider_size="650" posts_per_page="3"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Moving CTA Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/DsiJRE5F23I" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="rgba(10,6,6,0.84)" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="left-right" centered_text="true" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Let's Start This Party" font_container="tag:h2|font_size:52|text_align:center|line_height:52px" use_theme_fonts="yes" css_animation="fadeInUp"][divider line_type="No Line" custom_height="10"][vc_custom_heading text="Like Nothing You've Seen. Sign Up Today &amp; Experience Salient" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486565241232{margin-top: 10px !important;margin-bottom: 10px !important;}"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="default_arrow" url="#" text="Learn More" css_animation="zoomIn"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Sweet Hero Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hero-inline-video-link.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/190728/daily" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>Every Human Has</h2>
<h2>A Story To Tell</h2>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid" delay="300"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts The Big Oxmox advised her." font_container="tag:h5|font_size:20|text_align:left|color:rgba(255%2C255%2C255%2C0.7)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" font_style="h5" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="Watch Our Intro Video"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Recent Posts Dark Color Scheme', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent_posts_dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#131416" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="classic_enhanced" color_scheme="dark" category="all" columns="3" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="View All Posts" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Features With Background Color Overlay', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'about services icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/features.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/217569/daily" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#2b4bff" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeIn"]
<h4>See To Believe</h4>
[/vc_column_text][vc_custom_heading text="We Have All The Features" font_container="tag:h2|font_size:48|text_align:center" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="20px" icon_iconsmind="iconsmind-Umbrella-2"][vc_column_text css_animation="fadeInUp"]
<h4>There For You</h4>
[/vc_column_text][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485216414954{margin-top: 15px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="20px" icon_iconsmind="iconsmind-Diamond"][vc_column_text css_animation="fadeInUp"]
<h4>Pristine Quality</h4>
[/vc_column_text][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485216419423{margin-top: 15px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="20px" icon_iconsmind="iconsmind-Favorite-Window"][vc_column_text css_animation="fadeInUp"]
<h4>Heavily Awarded</h4>
[/vc_column_text][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485216423454{margin-top: 15px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Creative Hero With Device', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ipad-bottom-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/422400/daily" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="dark" text_align="left" top_padding="8%" enable_gradient="true" color_overlay="#ffffff" color_overlay_2="rgba(252,252,252,0.93)" gradient_direction="left_b_to_right_t" overlay_strength="0.95"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>The Possibilities</h2>
<h2>Are Endless</h2>
[/split_line_heading][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="450"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="none" url="#" text="Tell Me How" margin_top="10" margin_right="10" margin_left="10"][/vc_column_inner][/vc_row_inner][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/ipad-hor-cut.png" alignment="center" animation="Fade In" box_shadow="none" max_width="100%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Hot Hero Tablet Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ipad-bottom.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ff1456" scene_position="center" text_color="light" text_align="left" top_padding="8%" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>Create The Website</h2>
<h2>Of Your Dreams</h2>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:h5|font_size:20|text_align:center|color:rgba(255%2C255%2C255%2C0.8)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1485877986603{padding-right: 20% !important;padding-left: 20% !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="450"][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#" text="Tell Me How" margin_top="10" margin_right="10" margin_bottom="10" margin_left="10"][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="none" url="#" text="Purchase Now" margin_top="10" margin_right="10" margin_bottom="10" margin_left="10"][/vc_column_inner][/vc_row_inner][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/ipad-hor-cut.png" alignment="center" animation="Fade In" box_shadow="none" max_width="100%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Direct Minimal Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'].', '. $cat_display_names['general'];
$data['custom_class'] = 'hero_section general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/light-video-minimal-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="3/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1487092529487{margin-bottom: 20px !important;}"]
<h3>A wonderful serenity has <em>taken possession</em> of my entire soul, like these sweet mornings of spring which I enjoy with my<em> whole heart</em>.</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" font_style="p" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="<strong>Introduction Video </strong> — 30 seconds"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fancy Hero Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hero-video.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/daily/" bg_position="center center" bg_repeat="no-repeat" bg_color="#0a0303" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" enable_gradient="true" color_overlay="#0a0000" color_overlay_2="#4f4f4f" gradient_direction="left_b_to_right_t" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1485381645515{margin-bottom: -10px !important;}"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Welcome To Salient" font_container="tag:h1|text_align:center|color:%23ffffff" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/12" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in." font_container="tag:h4|font_size:20|text_align:center|color:rgba(255%2C255%2C255%2C0.7)|line_height:35px" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1487090569024{margin-top: 10px !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/12" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="30" bottom_padding="20" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12" delay="100"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://source.unsplash.com/sdcbrnR4JMo/650x375" hover_effect="defaut" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="150"][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="iconsmind" url="#" text="Learn More" icon_iconsmind="iconsmind-Triangle-ArrowRight" margin_top="30"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Wireframe Structure Of A Fixed Page Submenu', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/page-submenu.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][page_submenu alignment="left" sticky="true" bg_color="#004cff" link_color="#ffffff"][page_link link_url="#section-one" title="Section One" id="1485377879-1-86" tab_id="1485378066812-2"] [/page_link][page_link link_url="#section-two" title="Section Two" id="1485377879-2-40" tab_id="1485378066819-3"] [/page_link][page_link link_url="#section-three" title="Section Three" id="1485378132323-0-4" tab_id="1481372066319-3"] [/page_link][/page_submenu][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#232323" scene_position="center" text_color="light" text_align="left" top_padding="20%" bottom_padding="20%" id="section-one" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="extra-color-gradient-1" icon_padding="0px" icon_iconsmind="iconsmind-Aquarius" margin_bottom="5"][/vc_column_inner][/vc_row_inner][vc_custom_heading text="Section One" font_container="tag:h2|font_size:80|text_align:left|line_height:94px" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="fadeIn"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeIn"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#303030" scene_position="center" text_color="light" text_align="left" top_padding="20%" bottom_padding="20%" id="section-two" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="extra-color-gradient-1" icon_padding="0px" icon_iconsmind="iconsmind-Aquarius" margin_bottom="5"][vc_custom_heading text="Section Two" font_container="tag:h2|font_size:80|text_align:left|line_height:94px" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="fadeIn"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeIn"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#232323" scene_position="center" text_color="light" text_align="left" top_padding="20%" bottom_padding="20%" id="section-three" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="extra-color-gradient-1" icon_padding="0px" icon_iconsmind="iconsmind-Aquarius" margin_bottom="5"][vc_custom_heading text="Section Three" font_container="tag:h2|font_size:80|text_align:left|line_height:94px" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="fadeIn"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeIn"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Simple Hero With Gradient CTA Button', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'hero_section cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/simple-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/467163/daily" bg_position="center top" bg_repeat="no-repeat" bg_color="#454156" scene_position="center" text_color="light" text_align="left" top_padding="9%" bottom_padding="9%" id="intro" row_name="Intro" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text max_width="700"]
<h1>Receive &amp; Send Payments No Matter Where You Aimmenre</h1>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1469551223317{margin-top: -10px !important;}"]We're changing the way money is processed on-the-go.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_btn size="jumbo" button_style="see-through" button_color_2="extra-color-gradient-1" icon_family="none" url="#" text="Show Me How"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Project With Video Player', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-video-project.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f9f9f9" scene_position="center" text_color="dark" text_align="left" top_padding="5%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]
<h2><span style="color: #3f59ff;">Overview</span></h2>
[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f9f9f9" scene_position="center" text_color="dark" text_align="left" bottom_padding="4%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<span style="color: #999999;">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</span>[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]<span style="color: #999999;">She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then she continued her way. On her way she met a copy.</span>[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text]
<h6><span style="color: #3f59ff;">Project</span></h6>
<span style="color: #999999;">Mountains </span>[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text]
<h6><span style="color: #3f59ff;">Client</span></h6>
<span style="color: #999999;">Good People</span>[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text]
<h6><span style="color: #3f59ff;">What We Did</span></h6>
<span style="color: #999999;">UI/UX Design, Video Production</span>[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="3%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="2/3" tablet_text_alignment="default" phone_text_alignment="default"][split_line_heading]
<h2 style="color: #3f59ff;"><span style="color: #3f59ff;">We Delivered An Advert</span></h2>
<h2 style="color: #3f59ff;"><span style="color: #3f59ff;">Of Individuality, Eccentricity,</span></h2>
<h2 style="color: #3f59ff;"><span style="color: #3f59ff;">Abnormality, and Humors.</span></h2>
[/split_line_heading][vc_row_inner text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][vc_column_text]<span style="color: #999999;">She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove</span>,[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="light" text_align="left" bottom_padding="8%" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/1600/800/?blur" box_shadow="none" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Overlapping Testimonial Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'testimonials about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-testimonial.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/217569/daily" bg_color="#3a3a3a" scene_position="center" text_color="light" text_align="left" top_padding="17%" bottom_padding="17%" overlay_strength="0.3"][vc_column enable_animation="true" animation="none" centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row][vc_row type="in_container" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-7-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" top_margin="-6%" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5 style="text-align: center;">How The Project Was Received</h5>
[/vc_column_text][divider line_type="Small Line" line_thickness="2" divider_color="accent-color" animate="yes" custom_height="50" custom_line_width="80"][testimonial_slider style="minimal" disable_height_animation="true"][testimonial title="Testimonial" id="1475857961-1-94" tab_id="1475858133769-1" name="Eve Crawford" subtitle="Product Designer" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel at ease. The design ended up being better than I could have envisioned!"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Split Large Icon Column & Animated Titles', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/animated-titles.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-10-percent" column_padding_position="all" background_color="#3f59ff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Extra-Color-3" icon_padding="20px" icon_iconsmind="iconsmind-Plant" icon_size="200"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column centered_text="true" column_padding="padding-8-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_animated_title heading_tag="h2" style="color-strip-reveal" color="Accent-Color" text="Our life is"][nectar_animated_title heading_tag="h2" style="color-strip-reveal" color="Accent-Color" text="Frittered away"][nectar_animated_title heading_tag="h2" style="color-strip-reveal" color="Accent-Color" text="By detail"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Jumbo Button With 3D Hover Effect', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'about cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/jumbo-3d-button.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/422400/daily" bg_position="center center" bg_repeat="no-repeat" bg_color="#383838" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0101" overlay_strength="0.5"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_btn size="extra_jumbo" button_style="see-through-3d" url="#" text="View Website"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Icon Sections, Dual With Gradient Coloring', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['icons'] .', '. $cat_display_names['services'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'icons services cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/fullwidth-icons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-10-percent" column_padding_position="all" background_color="#f7f7f7" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Microscope" margin_bottom="15" icon_size="40" url="#"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Extensive Documentation</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350" css=".vc_custom_1485463707253{margin-bottom: 40px !important;}"]<span style="color: #aaa;"> Never feel lost again. Documentation is available in addition to a series of video tutorials exclusively for Salient.</span>[/vc_column_text][nectar_cta heading_tag="h5" text_color="#a5a5a5" link_type="regular" alignment="center" link_text="Learn More"][/vc_column][vc_column centered_text="true" column_padding="padding-10-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Wolf" margin_bottom="15" icon_size="40" url="#"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Beautiful Design</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350" css=".vc_custom_1485463711391{margin-bottom: 40px !important;}"]<span style="color: #aaa;">Quality over quantity. Enjoy a vast array of carefully designed &amp; unique elements with tons of control over fine tuning them.</span>[/vc_column_text][nectar_cta heading_tag="h5" text_color="#a5a5a5" link_type="regular" alignment="center" link_text="Learn More"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Split Line Heading & Video Background', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'about general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/animated-split-line-heading.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#2b2b2b" scene_position="center" video_bg="use_video" enable_video_color_overlay="true" video_overlay_color="#0a0a0a" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" id="culture" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h1>We Make Amazing</h1>
<h1>Things Every Day.</h1>
[/split_line_heading][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Section With Cascading Images', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'about general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cascading-imgs.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_url="https://source.unsplash.com/daily" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="-" image_1_offset_y="55%" image_1_rotate_sign="+" image_1_rotate="none" image_1_animation="Grow In" image_1_box_shadow="none" image_2_url="https://source.unsplash.com/weekly" image_2_offset_x_sign="+" image_2_offset_x="50%" image_2_offset_y_sign="+" image_2_offset_y="35%" image_2_rotate_sign="+" image_2_rotate="none" image_2_animation="Grow In" image_2_box_shadow="none" image_3_url="https://source.unsplash.com/300x350" image_3_offset_x_sign="-" image_3_offset_x="35%" image_3_offset_y_sign="+" image_3_offset_y="30%" image_3_rotate_sign="+" image_3_rotate="none" image_3_animation="Grow In" image_3_box_shadow="x_large_depth" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_animation="Fade In" image_4_box_shadow="none"][/vc_column][vc_column column_padding="padding-6-percent" column_padding_position="left" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1476219400968{margin-top: 50px !important;margin-bottom: 20px !important;}"]
<h5><span style="color: #999999;">Connecting brands and ideas</span></h5>
<h2>Our True Passion</h2>
[/vc_column_text][vc_column_text]Every great dream begins with a dreamer. Always remember, you have within you the strength, the patience, and the passion to reach for the stars to change the world.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fullscreen Biography On Click Team Members', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['team'];
$data['custom_class'] = 'about team';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-fullscreen.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" id="team" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/BZ2PNGD5Emw/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Igor Kozlov" job_position="Graphic Designer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/tBt9JxuQBYs/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Mark Jones" job_position="Back-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/R5tHd-aYmPs/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Andre Smith" job_position="Fine Artist" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/featured/500x500/?face" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Ethan Young" job_position="Team Leader" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/5lexwsAzUT4/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Ava Morgan" job_position="The SEO Expert" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/HZGkX1vKJvo/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="James Anderson" job_position="Front-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Fulfilling Recent Blog Posts', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-alt.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#eaeaea" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][recent_posts style="classic_enhanced_alt" category="all" columns="3" posts_per_page="3"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="View All Posts" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Overflowing Sections', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'services general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-overflowing.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="5%" overlay_strength="0.3"][vc_column column_padding="padding-2-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/ipad-hor.png" alignment="right" animation="Fade In From Left" box_shadow="none" max_width="175%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Section No. 1" font_container="tag:h5|font_size:16|text_align:left|color:%23000000|line_height:32px" use_theme_fonts="yes"][vc_custom_heading text="Solid Design For Business" font_container="tag:h2|text_align:left|color:%23058efb" use_theme_fonts="yes"][divider line_type="Small Line" line_thickness="8" divider_color="default" animate="yes" custom_height="100" custom_line_width="120"][vc_column_text css_animation="bottom-to-top" css=".vc_custom_1485640195002{padding-right: 10% !important;}"]<span style="color: #999;">Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.</span>[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Section No. 2" font_container="tag:h5|font_size:16|text_align:left|color:%23000000|line_height:32px" use_theme_fonts="yes"][vc_custom_heading text="With looks to kill competition " font_container="tag:h2|text_align:left|color:%23058efb" use_theme_fonts="yes"][divider line_type="Small Line" line_thickness="8" divider_color="default" animate="yes" custom_height="100" custom_line_width="120"][vc_column_text css_animation="bottom-to-top" css=".vc_custom_1485640190159{padding-right: 10% !important;}"]<span style="color: #999;">Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.</span>[/vc_column_text][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/ipad-hor.png" alignment="" animation="Fade In From Right" box_shadow="none" max_width="175%"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Gallery Project', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio gallery';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-gallery-project.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="1%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="40" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="You've never seen architecture like this." font_container="tag:h2|text_align:left|color:%2322d2d8" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="DELIVERABLES" font_container="tag:h5|font_size:14|text_align:left|color:%23b2b2b2" google_fonts="font_family:Hind%3A300%2Cregular%2C500%2C600%2C700|font_style:500%20bold%20regular%3A500%3Anormal"][fancy-ul icon_type="none" alignment="left"]
<ul>
 	<li>Photography</li>
 	<li>Strategy</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="AWARDS &amp; MENTIONS" font_container="tag:h5|font_size:14|text_align:left|color:%23b2b2b2" google_fonts="font_family:Hind%3A300%2Cregular%2C500%2C600%2C700|font_style:500%20bold%20regular%3A500%3Anormal"][fancy-ul icon_type="none" alignment="left"]
<ul>
 	<li>Building Inspire</li>
 	<li>Best Promo</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="CLIENT" font_container="tag:h5|font_size:14|text_align:left|color:%23b2b2b2" google_fonts="font_family:Hind%3A300%2Cregular%2C500%2C600%2C700|font_style:500%20bold%20regular%3A500%3Anormal"][fancy-ul icon_type="none" alignment="left"]Salient Construction[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_custom_heading text="YEAR" font_container="tag:h5|font_size:14|text_align:left|color:%23b2b2b2" google_fonts="font_family:Hind%3A300%2Cregular%2C500%2C600%2C700|font_style:500%20bold%20regular%3A500%3Anormal"][vc_column_text]2017[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_gallery type="flickity_style" flickity_controls="material_pagination" flickity_desktop_columns="1" flickity_small_desktop_columns="1" flickity_tablet_columns="1" flickity_box_shadow="large_depth" onclick="link_no" img_size="full"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal CTA Section With Flip In Animation', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['cta'];
$data['custom_class'] = 'about cta hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/3d-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" bg_image="https://source.unsplash.com/collection/190727/daily" full_screen_row_position="middle" bg_color="#5e5e5e" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column enable_animation="true" animation="flip-in-vertical" centered_text="true" column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text max_width="575"]
<h5>High Quality. Stunning Design.</h5>
<h2>Take Your Website To New Heights With Salient</h2>
[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="see-through" button_color_2="extra-color-gradient-2" color_override="#ffffff" icon_family="none" text="Purchase Now" margin_top="50"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Well-made Intro Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'about general hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>If you wish to make an apple</h2>
<h2>pie from scratch, you must first</h2>
<h2>invent the universe.</h2>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_cta heading_tag="h5" text_color="#0a0000" link_type="regular" alignment="left" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Red(ish) Background Milestones', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['counters'];
$data['custom_class'] = 'counters';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/milestone-red.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ff3a6f" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Default" effect="count" number="4860" subject="User downloads" number_font_size="76"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Default" effect="count" number="3470" subject="Hours watched" number_font_size="76"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Default" effect="count" number="239" subject="Raving reviews" number_font_size="76"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Flip Box Services', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/flipbox-services.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#f9f7f5" scene_position="center" text_color="dark" text_align="left" bottom_padding="5%" id="services" overlay_strength="0.3"][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" bottom_margin="20" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-4 vc_col-md-12"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/310797/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="iconsmind" icon_color="Accent-Color" bg_color_2="#1239ff" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Content
<i>Creation</i></h3>
" icon_iconsmind="iconsmind-Telescope" min_height="400"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live on.[/nectar_flip_box][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-4 vc_col-md-12"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/190727/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="iconsmind" icon_color="Accent-Color" bg_color_2="#1239ff" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Market
<i>Growth</i></h3>
" icon_iconsmind="iconsmind-Spring" min_height="400"]The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/nectar_flip_box][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-4 vc_col-md-12"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/467163/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="iconsmind" icon_color="Accent-Color" bg_color_2="#1239ff" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Ending
<i>Competition</i></h3>
" icon_iconsmind="iconsmind-Grave" min_height="400"]Pityful a rethoric question ran over her cheek, then she continued her way. On her way she met a copy. The copy warned the Little Blind Text.[/nectar_flip_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-4 vc_col-md-12"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/422400/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="iconsmind" icon_color="Accent-Color" bg_color_2="#1239ff" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Private
<i>Tutoring</i></h3>
" icon_iconsmind="iconsmind-Face-Style2" min_height="400"]ar from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast.[/nectar_flip_box][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-4 vc_col-md-12"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/317099/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="iconsmind" icon_color="Accent-Color" bg_color_2="#1239ff" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Event
<i>Hosting</i></h3>
" icon_iconsmind="iconsmind-The-WhiteHouse" min_height="400"]Even the all-powerful Pointing has no control about the blind texts it is an almost life One day however a small line of blind text.[/nectar_flip_box][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-4 vc_col-md-12"][nectar_flip_box image_url_1="https://source.unsplash.com/collection/179646/daily" bg_color="#0a0a0a" bg_color_overlay="true" text_color="light" icon_family="iconsmind" icon_color="Accent-Color" bg_color_2="#1239ff" text_color_2="light" h_text_align="center" v_text_align="center" flip_direction="horizontal-to-left" front_content="
<h3>Browser<i>Addons</i></h3>
" icon_iconsmind="iconsmind-Love-Window" min_height="400"]But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her, made her drunk.[/nectar_flip_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Minimal Testimonial Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal-testimonial-slider.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5 style="text-align: center;">What They're Saying</h5>
[/vc_column_text][divider line_type="Small Line" line_thickness="2" divider_color="accent-color" animate="yes" custom_height="50" custom_line_width="80"][testimonial_slider style="minimal" disable_height_animation="true"][testimonial title="Testimonial" id="1475857961-1-94" tab_id="1475858133769-1" name="Eve Crawford" subtitle="Product Designer" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel at ease. The design ended up being better than I could have envisioned!"] Click the edit button to add your testimonial. [/testimonial][testimonial title="Testimonial" id="1475857961-2-87" tab_id="1475858133938-7" name="Aura Brooks" subtitle="Graphic Designer" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team!"] Click the edit button to add your testimonial. [/testimonial][testimonial title="Testimonial" id="1475858204372-0-6" tab_id="1475858133938-7" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site!"] Click the edit button to add your testimonial. [/testimonial][testimonial title="Testimonial" id="1475858232487-0-1" tab_id="1475858133938-7" name="Jack Graham" subtitle="Co Founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Three Columns With Icons & Text Block', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'services icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/3-col-icons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-basic" icon_border_thickness="2px" icon_color="Accent-Color" icon_padding="25px" icon_iconsmind="iconsmind-Ship-2" margin_bottom="15" icon_size="40"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text max_width="315"]
<h4>Thousands Of Icons</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text max_width="315" css=".vc_custom_1476572530813{margin-top: -20px !important;}"]<span style="color: #aaa;">Salient comes packed with amazing icon families for you to choose from. Practically anything you could imagine exists.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="border-basic" icon_border_thickness="2px" icon_color="Accent-Color" icon_padding="25px" icon_iconsmind="iconsmind-Wolf" margin_bottom="15" icon_size="40"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][vc_column_text max_width="315"]
<h4>Beautiful Design</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][vc_column_text max_width="315" css=".vc_custom_1476572575460{margin-top: -20px !important;}"]<span style="color: #aaa;">Quality over quantity. Enjoy a vast array of carefully designed &amp; unique elements with tons of control over fine tuning them.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][nectar_icon icon_family="iconsmind" icon_style="border-basic" icon_border_thickness="2px" icon_color="Accent-Color" icon_padding="25px" icon_iconsmind="iconsmind-Microscope" margin_bottom="15" icon_size="40"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][vc_column_text max_width="315"]
<h4>Extensive Documentation</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][vc_column_text max_width="315" css=".vc_custom_1476572677993{margin-top: -20px !important;}"]<span style="color: #aaa;"> Never feel lost again. Documentation is available in addition to a series of video tutorials exclusively for Salient.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Single Project Simple', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['portfolio'];
$data['custom_class'] = 'about portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/green-proj.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" bg_color="#f9f9f9" scene_position="center" text_color="dark" text_align="left" top_padding="5%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1"][vc_column_text]
<h6><span style="color: #50d18d;">Overview</span></h6>
[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" bg_color="#f9f9f9" scene_position="center" text_color="dark" text_align="left" bottom_padding="4%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3"][vc_column_text]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3"][vc_column_text]She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then she continued her way. On her way she met a copy.[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3"][vc_column_text css=".vc_custom_1451934363103{border-top-width: 2px !important;border-right-width: 2px !important;border-bottom-width: 2px !important;border-left-width: 2px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: #0a0a0a !important;border-left-style: solid !important;border-right-color: #0a0a0a !important;border-right-style: solid !important;border-top-color: #0a0a0a !important;border-top-style: solid !important;border-bottom-color: #0a0a0a !important;border-bottom-style: solid !important;}"]
<h6><span style="color: #50d18d;">Project</span></h6>
Waveform Concept Design[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text css=".vc_custom_1451934370844{border-top-width: 2px !important;border-right-width: 2px !important;border-bottom-width: 2px !important;border-left-width: 2px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: #0a0a0a !important;border-left-style: solid !important;border-right-color: #0a0a0a !important;border-right-style: solid !important;border-top-color: #0a0a0a !important;border-top-style: solid !important;border-bottom-color: #0a0a0a !important;border-bottom-style: solid !important;}"]
<h6><span style="color: #50d18d;">Client</span></h6>
The People Inc.[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text css=".vc_custom_1451934352663{border-top-width: 2px !important;border-right-width: 2px !important;border-bottom-width: 2px !important;border-left-width: 2px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: #0a0a0a !important;border-left-style: solid !important;border-right-color: #0a0a0a !important;border-right-style: solid !important;border-top-color: #0a0a0a !important;border-top-style: solid !important;border-bottom-color: #0a0a0a !important;border-bottom-style: solid !important;}"]
<h6><span style="color: #50d18d;">What We Did</span></h6>
Company Branding, Responsive Web Design[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_content" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2"][split_line_heading]
<h3><span style="color: #50d18d;">The Big Oxmox advised</span></h3>
<h3><span style="color: #50d18d;">her not to do so, because there</span></h3>
<h3><span style="color: #50d18d;">were thousands of devious Semikoli</span></h3>
[/split_line_heading][vc_row_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="reveal-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color="#212121" background_color_opacity="1" background_hover_color_opacity="1" width="1/2"][/vc_column][/vc_row][vc_row type="full_width_content" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column enable_animation="true" animation="reveal-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color="#282828" background_color_opacity="1" background_hover_color_opacity="1" width="1/2"][/vc_column][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2"][split_line_heading]
<h3><span style="color: #50d18d;">The Big Oxmox advised</span></h3>
<h3><span style="color: #50d18d;">her not to do so, because there</span></h3>
<h3><span style="color: #50d18d;">were thousands of devious Semikoli</span></h3>
[/split_line_heading][vc_row_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Single Project With Gallery Slider', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-with-slider.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" image_bg="https://source.unsplash.com/collection/310797/daily" bg_color="#f9f9f9" scene_position="center" text_color="dark" text_align="left" top_padding="5%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h2><span style="color: #50d18e;">Overview</span></h2>
[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f9f9f9" scene_position="center" text_color="dark" text_align="left" bottom_padding="4%" overlay_strength="0.3"][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]<span style="color: #999999;">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.</span>[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]<span style="color: #999999;">She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove, the headline of Alphabet Village and the subline of her own road, the Line Lane. Pityful a rethoric question ran over her cheek, then she continued her way. On her way she met a copy.</span>[/vc_column_text][/vc_column][vc_column column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h6><span style="color: #50d18e;">Project</span></h6>
<span style="color: #999999;">Salient Blog Design</span>[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text]
<h6><span style="color: #50d18e;">Client</span></h6>
<span style="color: #999999;">ThemeNectar</span>[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text]
<h6><span style="color: #50d18e;">What We Did</span></h6>
<span style="color: #999999;">UI/UX Design, Responsive Web Design</span>[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_image="6225" bg_position="center center" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="center" top_padding="22%" bottom_padding="22%" enable_gradient="true" color_overlay="#585b64" color_overlay_2="#2c2f38" gradient_direction="left_t_to_right_b" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2 style="color: #50d18e;">Design How it's meant to be.</h2>
<h2 style="color: #50d18e;">Salient Will Enhance Your Content</h2>
<h2 style="color: #50d18e;">And Allow It To Fully Shine.</h2>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]<span style="color: #999999;">She packed her seven versalia, put her initial into the belt and made herself on the way. When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrove</span>,[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" bottom_padding="5%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_gallery type="flickity_style" flickity_controls="pagination" flickity_desktop_columns="1" flickity_small_desktop_columns="1" flickity_tablet_columns="1" flickity_box_shadow="none" onclick="link_no" img_size="full"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Info Boxes Bordered & Heading', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'about services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/three-info-boxes.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="padding-4-percent" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_column_text max_width="600"]
<h2>We Are Salient</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid" delay="50" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="100" offset="vc_col-xs-12"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the little blind texts. The Big Oxmox advised her not to do so, because there were thousands of bad Commas." font_container="tag:p|text_align:center|color:rgba(0%2C0%2C0%2C0.65)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="2px" column_border_color="#e2e2e2" column_border_style="solid" enable_border_animation="true"][vc_custom_heading text="It's time to make moves" font_container="tag:p|font_size:14|text_align:left|color:%230a0a0a|line_height:20px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="none" css=".vc_custom_1485617597027{margin-bottom: -15px !important;}"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country." font_container="tag:p|text_align:left|color:%23878787" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485617691025{margin-bottom: -15px !important;}"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#ff1654" icon_family="iconsmind" text="See More" icon_iconsmind="iconsmind-Triangle-ArrowRight" margin_top="50"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="2px" column_border_color="#e2e2e2" column_border_style="solid" enable_border_animation="true" border_animation_delay="300" delay="300"][vc_custom_heading text="Now or never" font_container="tag:p|font_size:14|text_align:left|color:%230a0a0a|line_height:20px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="none" css=".vc_custom_1485617617425{margin-bottom: -15px !important;}"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country." font_container="tag:p|text_align:left|color:%23878787" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485617691025{margin-bottom: -15px !important;}"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#ff1654" icon_family="iconsmind" text="See More" icon_iconsmind="iconsmind-Triangle-ArrowRight" margin_top="50"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="2px" column_border_color="#e2e2e2" column_border_style="solid" enable_border_animation="true" border_animation_delay="600" delay="600"][vc_custom_heading text="Stop waiting around" font_container="tag:p|font_size:14|text_align:left|color:%230a0a0a|line_height:20px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="none" css=".vc_custom_1485617623831{margin-bottom: -15px !important;}"][vc_custom_heading text="A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country." font_container="tag:p|text_align:left|color:%23878787" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485617691025{margin-bottom: -15px !important;}"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#ff1654" icon_family="iconsmind" text="See More" icon_iconsmind="iconsmind-Triangle-ArrowRight" margin_top="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Info Box Right Animated & Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'about hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/info-box-right-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#161616" scene_position="center" text_color="light" text_align="left" top_padding="12%" bottom_padding="12%" overlay_strength="0.3"][vc_column column_padding="padding-4-percent" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-lg-8 vc_col-md-8 vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid"][vc_column_text max_width="600" css=".vc_custom_1485444155911{margin-bottom: 30px !important;}"]
<h2>We Are Salient, A Digital First Design Agency</h2>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. The Big Oxmox advised her not to do so, because there were thousands of bad Commas." font_container="tag:p|text_align:left|color:%23828282" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485444104883{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="4px" column_border_color="#2d2d2d" column_border_style="solid" enable_border_animation="true" offset="vc_col-lg-offset-0 vc_col-lg-4 vc_col-md-offset-0 vc_col-md-4 vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1485444358185{margin-bottom: 10px !important;}"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="It's time to make moves" font_container="tag:p|font_size:14|text_align:left|color:%23828282|line_height:20px" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="75"][vc_column_text css_animation="none"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="150"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#ff2861" icon_family="iconsmind" text="See More" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Touch Enabled Gallery With Arrows', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio gallery';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gallery-arrows.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_gallery type="flickity_style" flickity_controls="next_prev_arrows" flickity_desktop_columns="1" flickity_small_desktop_columns="1" flickity_tablet_columns="1" flickity_box_shadow="large_depth" onclick="link_no"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Services & Company Gradient Intro Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'about services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-services-gradient.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/190727/daily" bg_position="center top" bg_repeat="no-repeat" bg_color="#cbcbc3" scene_position="center" text_color="light" text_align="left" top_padding="4%" bottom_padding="4%" id="intro" enable_gradient="true" color_overlay_2="#151519" gradient_direction="top_to_bottom" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner top_padding="65%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][/vc_column_inner][/vc_row_inner][split_line_heading]
<h2>Whether you need a new</h2>
<h2>web application or company</h2>
<h2>branding - we can help.</h2>
[/split_line_heading][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][vc_column_text]Our team has many skills so we're able to offer a wide array of services. Far away, behind the word mountains, far from the countries Vokalia and Contia, there live the blind texts. Separated they live in Booksgrove right at the coast of the Semantics, a large language ocean.

It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#151519" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" id="services" enable_gradient="true" color_overlay="#232323" color_overlay_2="#191919" gradient_direction="left_t_to_right_b" overlay_strength="1"][vc_column enable_animation="true" animation="reveal-from-bottom" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default"][fancy_box image_url="6083" color="Accent-Color" link_url="http://themenectar.com/demo/salient-corporate/portfolio/blog-ui/" link_text="View Case Study" min_height="400"]
<h3>UI Design</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit. In et arcu vel risus ullamcorper aliquet.[/fancy_box][/vc_column][vc_column enable_animation="true" animation="reveal-from-bottom" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" delay="200"][fancy_box image_url="6082" color="Extra-Color-1" link_url="http://themenectar.com/demo/salient-corporate/portfolio/night-sky-app/" link_text="View Case Study" min_height="400"]
<h3>Web Design</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit. In et arcu vel risus ullamcorper aliquet.[/fancy_box][/vc_column][vc_column enable_animation="true" animation="reveal-from-bottom" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" delay="400"][fancy_box image_url="6052" color="Extra-Color-2" link_url="http://themenectar.com/demo/salient-corporate/portfolio/waveform/" link_text="View Case Study" min_height="400"]
<h3>Mountain Design</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit. In et arcu vel risus ullamcorper aliquet.[/fancy_box][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Icons With SVG Draw Animation 4 Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons']  .', '. $cat_display_names['general'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/svg_icon_draw_2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="4%" overlay_strength="0.3" shape_divider_position="bottom"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h2>Stunning Looks &amp; Functionality</h2>
<h5><span style="color: #bbbbbb;">Eliminate your website building stress by using Salient</span></h5>
[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" bottom_padding="8%" overlay_strength="1" shape_divider_position="bottom"][vc_column enable_animation="true" animation="none" centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_linea="icon-ecommerce-diamond" icon_size="60"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Hot Looks</h5>
<span style="color: #a3a3a3;">Ut elit tellus, luctus nec magna mattis et, pulvinar dapibus lorem leo ultricies et vitae enim.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_linea="icon-basic-compass" animation_delay="400" icon_size="60"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="400"][vc_column_text]
<h5>Easy Interface</h5>
<span style="color: #a3a3a3;">Ut elit tellus, luctus nec magna mattis et, pulvinar dapibus lorem leo ultricies et vitae enim.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_linea="icon-software-layers2" animation_delay="800" icon_size="60"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="800"][vc_column_text]
<h5>True Power</h5>
<span style="color: #a3a3a3;">Ut elit tellus, luctus nec magna mattis et, pulvinar dapibus lorem leo ultricies et vitae enim.</span>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column centered_text="true" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_linea="icon-basic-anchor" animation_delay="1200" icon_size="60"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="1200"][vc_column_text]
<h5>Solid Code</h5>
<span style="color: #a3a3a3;">Ut elit tellus, luctus nec magna mattis et, pulvinar dapibus lorem leo ultricies et vitae enim.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Services With BG Hover', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal_services.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" bg_position="left top" bg_repeat="no-repeat" parallax_bg_speed="slow" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left"][vc_column width="1/3" animation="none" column_padding="padding-7-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_color_hover="#f9f9f9"][vc_row_inner][vc_column_inner width="1/1" enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all"][vc_column_text]<span style="color: #000000;"><i>Item No.</i></span>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3><span style="color: #e4e4e4;">01.</span> Research</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem accumsan et. Suspendisse egestas, turpis eu pellentesque aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" animation="none" column_padding="padding-7-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_color_hover="#f9f9f9"][vc_row_inner][vc_column_inner width="1/1" enable_animation="true" animation="fade-in-from-bottom" delay="200" column_padding="no-extra-padding" column_padding_position="all"][vc_column_text]<span style="color: #000000;"><i>Item No.</i></span>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3><span style="color: #e4e4e4;">02.</span> Design</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem accumsan et. Suspendisse egestas, turpis eu pellentesque aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" animation="fade-in-from-bottom" column_padding="padding-7-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_color_hover="#f9f9f9"][vc_row_inner][vc_column_inner width="1/1" enable_animation="true" animation="fade-in-from-bottom" delay="400" column_padding="no-extra-padding" column_padding_position="all"][vc_column_text]<span style="color: #000000;"><i>Item No.</i></span>[/vc_column_text][divider line_type="No Line" custom_height="10"][vc_column_text]
<h3><span style="color: #e4e4e4;">03.</span> Develop</h3>
Quisque molestie elementum quam molestie malesuada. In sagittis urna vitae blandit molestie. Nam aliquet dui neque, eget tincidunt sem accumsan et. Suspendisse egestas, turpis eu pellentesque aliquam.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Before & After', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/before_after.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" top_padding="8%" bottom_padding="8%" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-right" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/4" offset="vc_col-lg-3 vc_col-md-4"][vc_column_text]
<h5 style="text-align: right;">Before Salient</h5>
<p style="text-align: right;"><span style="color: #a3a3a3;">Hand rolling code is fun sometimes, but not ideal for getting projects done quickly or allowing clients to maintain pages.</span></p>

[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom" background_color_opacity="1" width="1/2" offset="vc_col-lg-6 vc_col-md-8"][nectar_image_comparison][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/4" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-4 vc_col-md-8"][vc_column_text]
<h5>With Salient</h5>
<span style="color: #a3a3a3;">Salient provides you a highly customized version of Visual Composer bundled with unique elements all available for use via the drag &amp; drop interface.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Hero Gradient Overlay With Video Lightbox', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hero_video_lightbox.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/217569/daily" bg_position="left top" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" top_padding="14%" bottom_padding="12%" enable_gradient="true" color_overlay="#585b64" color_overlay_2="#2c2f38" gradient_direction="left_t_to_right_b" overlay_strength="0.95"][vc_column centered_text="true" column_padding="padding-3-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="bottom" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text]
<h1>Salient Is Digital Brilliance</h1>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][vc_column_text]
<h2>Get Noticed and Stay Remembered</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Bold Touch Enabled Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/flickity_testimonials.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="6%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][testimonial_slider style="multiple_visible" color="accent-color-dark"][testimonial image="" title="Testimonial" tab_id="1451491481781-2" name="Aura Brooks" subtitle="Graphic Designer, Owl Eyes" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team!" id="1484342188374-1"] Click the edit button to add your testimonial. [/testimonial][testimonial image="" title="Testimonial" tab_id="1451491481781-2" name="Eve Crawford" subtitle="Product Designer, That Biz" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel completely at ease. The design ended up being twice as good as I could have ever envisioned!" id="1484342188403-2"] Click the edit button to add your testimonial. [/testimonial][testimonial image="" title="Testimonial" tab_id="1451491482058-4" name="Jack Graham" subtitle="Co founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" id="1484342188418-3"] Click the edit button to add your testimonial. [/testimonial][testimonial image="" title="Testimonial" tab_id="1451491482058-4" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site! " id="1484342188452-2"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Light Cascading Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cascading-imgs-light.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>The Snow Fox Will</h2>
<h2>Change Life</h2>
[/split_line_heading][vc_column_text css_animation="bottom-to-top" css=".vc_custom_1484775533999{margin-top: 15px !important;}" max_width="500"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][vc_column_text css_animation="bottom-to-top" css=".vc_custom_1484775539312{margin-top: 15px !important;}" max_width="500"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#3452ff" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="0%" image_1_rotate_sign="+" image_1_rotate="none" image_1_animation="Grow In" image_1_box_shadow="none" image_2_url="https://source.unsplash.com/weekly" image_2_offset_x_sign="+" image_2_offset_x="25%" image_2_offset_y_sign="+" image_2_offset_y="30%" image_2_rotate_sign="+" image_2_rotate="none" image_2_animation="Grow In" image_2_box_shadow="none" image_3_url="https://source.unsplash.com/daily" image_3_offset_x_sign="-" image_3_offset_x="15%" image_3_offset_y_sign="-" image_3_offset_y="30%" image_3_rotate_sign="+" image_3_rotate="none" image_3_animation="Grow In" image_3_box_shadow="x_large_depth" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_animation="Fade In" image_4_box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Cascading Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'general hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-cascading-images.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#18191c" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>Nectar Automotive's</h2>
<h2>Is the Future</h2>
[/split_line_heading][vc_column_text css_animation="bottom-to-top" css=".vc_custom_1484775533999{margin-top: 15px !important;}" max_width="500"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][vc_column_text css_animation="bottom-to-top" css=".vc_custom_1484775539312{margin-top: 15px !important;}" max_width="500"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#ff3a6f" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="0%" image_1_rotate_sign="+" image_1_rotate="none" image_1_animation="Grow In" image_1_box_shadow="none" image_2_url="https://source.unsplash.com/weekly" image_2_offset_x_sign="+" image_2_offset_x="25%" image_2_offset_y_sign="+" image_2_offset_y="30%" image_2_rotate_sign="+" image_2_rotate="none" image_2_animation="Grow In" image_2_box_shadow="none" image_3_url="https://source.unsplash.com/daily" image_3_offset_x_sign="-" image_3_offset_x="15%" image_3_offset_y_sign="-" image_3_offset_y="30%" image_3_rotate_sign="+" image_3_rotate="none" image_3_animation="Grow In" image_3_box_shadow="x_large_depth" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_animation="Fade In" image_4_box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Colorful Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['general'] .', '. $cat_display_names['portfolio'];
$data['custom_class'] = 'about general portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colorful-blocks.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#18191c" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="flip-in-vertical" background_image="https://source.unsplash.com/collection/483346/daily" enable_bg_scale="true" column_padding="padding-7-percent" column_padding_position="all" background_color="#568283" background_color_opacity="0.7" width="1/2" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="150"][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-7-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" font_color="#e2e2e2" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="black" icon_padding="0px" icon_size="40" icon_iconsmind="iconsmind-Finger-Print"][vc_custom_heading text="Assembled Custom Just For You" font_container="tag:h4|font_size:38|text_align:left|color:%233f3f3f|line_height:46px" use_theme_fonts="yes" css=".vc_custom_1484779752863{margin-top: -10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-7-percent" column_padding_position="all" background_color="#ff3a6f" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Car-3" icon_size="40"][vc_custom_heading text="Speed &amp; Beauty Combined" font_container="tag:h4|font_size:38|text_align:left|color:%23ffffff|line_height:46px" use_theme_fonts="yes" css=".vc_custom_1484778589853{margin-top: -15px !important;}"][divider line_type="No Line" custom_height="100"][nectar_cta heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Learn More" url="#"][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" background_image="https://source.unsplash.com/collection/317099/daily" enable_bg_scale="true" column_padding="padding-7-percent" column_padding_position="all" background_color="#121212" background_color_opacity="0.7" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][divider line_type="No Line" custom_height="150"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="flip-in-vertical" column_padding="padding-9-percent" column_padding_position="all" background_color="#333333" background_color_opacity="0.5" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/422400/daily" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Testimonials With Color Background', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonial-blue.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0054ff" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3 style="text-align: center;">What They're Saying</h3>
[/vc_column_text][divider line_type="Small Line" line_thickness="4" divider_color="default" animate="yes" custom_height="80" custom_line_width="80"][testimonial_slider style="minimal" disable_height_animation="true"][testimonial title="Testimonial" id="1475858133769-1e903-6491" name="Eve Crawford" subtitle="Product Designer" quote="It was really fun getting to know the team during the project. They were all helpful in answering my questions and made me feel at ease. The design ended up being better than I could have envisioned!" tab_id="1484853492958-1"] Click the edit button to add your testimonial. [/testimonial][testimonial title="Testimonial" id="1475858133938-7e903-6491" name="Aura Brooks" subtitle="Graphic Designer" quote="By far the best team I've ever worked with. They truly understood the look I was going for and completely nailed it! I would highly recommend them as a company, you simply just won't find any better team!" tab_id="1484853492998-1"] Click the edit button to add your testimonial. [/testimonial][testimonial title="Testimonial" id="1475858133938-7e903-6491" name="Zak Reid" subtitle="Instructor, Skate Nao" quote="Salient is by far the most astonishing WP theme out there! I literally could not be happier that I chose to buy your theme! Your regular updates and superb attention to detail blows me away every time I visit my new site!" tab_id="1484853493034-5"] Click the edit button to add your testimonial. [/testimonial][testimonial title="Testimonial" id="1475858133938-7e903-6491" name="Jack Graham" subtitle="Co Founder, Coffee Inc" quote="I'm wondering why I never contacted these guys sooner! Seriously, they all have commendable talent in their respective fields and knocked my concept out of the ballpark. Thanks for an amazing experience!" tab_id="1484853493065-4"] Click the edit button to add your testimonial. [/testimonial][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Video Lightbox With Preview Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-video.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f4f4f4" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484854759420{margin-bottom: 30px !important;}"]
<h2>Project Breakdown</h2>
[/vc_column_text][divider line_type="Small Line" line_thickness="4" divider_color="extra-color-gradient-2" animate="yes" custom_height="80" custom_line_width="100"][vc_column_text css=".vc_custom_1484854550359{margin-bottom: 50px !important;}" max_width="550"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/900/500/?blur" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Trusty Milestones With Dark Background', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['counters'];
$data['custom_class'] = 'counters';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-milestones.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#18191c" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" number="186" symbol="mph" subject="Top Speed" number_font_size="92" symbol_font_size="24"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Default" effect="count" number="547" subject="Horse Power" number_font_size="92"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Default" effect="count" number="413 " subject="pound-feet of torque" number_font_size="92"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Colors Used In Case Study', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colors-used.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f4f4f4" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_column_text max_width="450"]
<div data-mh="-1">
<h2 class="_HTf">Color &amp; material</h2>
</div>
[/vc_column_text][vc_column_text css=".vc_custom_1484678468218{margin-top: 25px !important;padding-right: 15% !important;}" max_width="500"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="none" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-7-percent" column_padding_position="top" background_color="#417e94" background_color_opacity="1" font_color="#ffffff" width="1/3" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="85"][vc_column_text css=".vc_custom_1484677912962{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Washed Blue</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484677918997{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#417e94[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-7-percent" column_padding_position="top" background_color="#ff3e57" background_color_opacity="1" font_color="#ffffff" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][divider line_type="No Line" custom_height="85"][vc_column_text css=".vc_custom_1484677927395{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Magenta Magma</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484677934273{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#c62a41[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-7-percent" column_padding_position="top" background_color="#634f4b" background_color_opacity="1" font_color="#ffffff" width="1/3" column_border_width="none" column_border_style="solid" delay="400"][divider line_type="No Line" custom_height="85"][vc_column_text css=".vc_custom_1484694811278{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Jaded Earth</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484677949891{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#2f3530[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fonts & Colors Used In Case Study', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colors-used4.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color="#4800ff" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][vc_column_text]#4800ff[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color="#006aff" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text]#003fff[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color="#00a9ff" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text]#0099ff[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color="#00cbff" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" delay="150"][vc_column_text]#00cbff[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color="#5cce5e" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text]#5cce5e[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="flip-in-vertical" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color="#4faf57" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid" delay="250"][vc_column_text]#4faf57[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="7%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Exo Bold" font_container="tag:h4|font_size:20|text_align:left|color:%230a0a0a" google_fonts="font_family:Exo%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_custom_heading text="Aa" font_container="tag:h2|font_size:80|text_align:left|color:%230a0a0a|line_height:110px" google_fonts="font_family:Exo%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:p|font_size:12|text_align:left|color:%230a0a0a|line_height:22px" google_fonts="font_family:Exo%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Exo Regular" font_container="tag:h4|font_size:20|text_align:left|color:%230a0a0a" google_fonts="font_family:Exo%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="Aa" font_container="tag:h2|font_size:80|text_align:left|color:%230a0a0a|line_height:110px" google_fonts="font_family:Exo%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:p|font_size:12|text_align:left|color:%230a0a0a|line_height:22px" google_fonts="font_family:Exo%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Philosopher Regular" font_container="tag:h4|font_size:20|text_align:left|color:%230a0a0a" google_fonts="font_family:Philosopher%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="Aa" font_container="tag:h2|font_size:80|text_align:left|color:%230a0a0a|line_height:110px" google_fonts="font_family:Philosopher%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:p|font_size:12|text_align:left|color:%230a0a0a|line_height:22px" google_fonts="font_family:Philosopher%3Aregular%2Citalic%2C700%2C700italic|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Project Header With Gradient', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-header-3.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="40" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_gradient_text heading_tag="h2" color="extra-color-gradient-1" gradient_direction="diagonal" text="Imagination will often carry us to worlds that never were. But without it we go nowhere."][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484758894175{margin-bottom: 5px !important;}"]
<h5>Deliverables</h5>
[/vc_column_text][fancy-ul icon_type="none"]
<ul>
 	<li>App Design</li>
 	<li>Photography</li>
 	<li>Strategy</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484674851189{margin-bottom: 5px !important;}"]
<h5>Awards &amp; Mentions</h5>
[/vc_column_text][fancy-ul icon_type="none"]
<ul>
 	<li>App Inspire</li>
 	<li>Best Promo</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484674945481{margin-bottom: 5px !important;}"]
<h5>Client</h5>
[/vc_column_text][fancy-ul icon_type="none"]Salient App[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484758899086{margin-bottom: 5px !important;}"]
<h5>Year</h5>
[/vc_column_text][vc_column_text]2017[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Project Colors & Fonts Used Alternative', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colors-used3.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f4f4f4" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_column_text]
<h3>Colors &amp; Material</h3>
[/vc_column_text][divider line_type="Small Line" line_thickness="2" divider_color="extra-color-gradient-1" animate="yes" custom_height="50" custom_line_width="50"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="none" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-7-percent" column_padding_position="top" background_color="#007eff" background_color_opacity="1" font_color="#ffffff" width="1/3" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="85"][vc_column_text css=".vc_custom_1484761535257{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Extra Blue</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484761580916{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#007eff[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-7-percent" column_padding_position="top" background_color="#ff3e57" background_color_opacity="1" font_color="#ffffff" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][divider line_type="No Line" custom_height="85"][vc_column_text css=".vc_custom_1484677927395{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Magenta Magma</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484677934273{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#c62a41[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-7-percent" column_padding_position="top" background_color="#333437" background_color_opacity="1" font_color="#ffffff" width="1/3" column_border_width="none" column_border_style="solid" delay="400"][divider line_type="No Line" custom_height="85"][vc_column_text css=".vc_custom_1484761552756{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Night Sky</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484761569924{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#333437[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="10/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>Typography</h3>
[/vc_column_text][divider line_type="Small Line" line_thickness="2" divider_color="extra-color-gradient-1" animate="yes" custom_height="50" custom_line_width="50"][vc_column_text css=".vc_custom_1484761292387{margin-bottom: 10px !important;}"]Lato Bold[/vc_column_text][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z" font_container="tag:h3|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal"][vc_custom_heading text="a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:h4|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Lato%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:900%20bold%20regular%3A900%3Anormal"][vc_column_text css=".vc_custom_1484761407248{margin-top: 60px !important;margin-bottom: 10px !important;}"]Raleway[/vc_column_text][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z" font_container="tag:h3|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Raleway%3A100%2C200%2C300%2Cregular%2C500%2C600%2C700%2C800%2C900|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:h4|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Raleway%3A100%2C200%2C300%2Cregular%2C500%2C600%2C700%2C800%2C900|font_style:400%20regular%3A400%3Anormal"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Project Colors & Fonts Used', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colors-used2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f2f2f2" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Colors</h5>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="reveal-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color="#603dff" background_color_opacity="1" font_color="#ffffff" width="5/12" column_border_width="none" column_border_style="solid" delay="100"][divider line_type="No Line" custom_height="150"][vc_column_text css=".vc_custom_1484860156218{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Revered Purple</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484677934273{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#c62a41[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="reveal-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color="#ff0000" background_color_opacity="1" font_color="#ffffff" width="5/12" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="150"][vc_column_text css=".vc_custom_1484860096921{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Extra Red</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484761580916{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#007eff[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="reveal-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color="#232323" background_color_opacity="1" font_color="#ffffff" width="5/12" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="150"][vc_column_text css=".vc_custom_1484761552756{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Night Sky</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484761569924{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#333437[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="reveal-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" font_color="#000000" width="5/12" column_border_width="none" column_border_style="solid" delay="100"][divider line_type="No Line" custom_height="150"][vc_column_text css=".vc_custom_1484859490216{padding-top: 25px !important;padding-right: 25px !important;padding-left: 25px !important;}"]
<h5>Pure White</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484859473293{padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;}"]#ffffff[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="100" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][vc_column_text]
<h5>Fonts</h5>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484859891164{margin-bottom: 10px !important;}"]Ubuntu Bold[/vc_column_text][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z" font_container="tag:h3|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Ubuntu%3A300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_custom_heading text="a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:h4|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Ubuntu%3A300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_column_text css=".vc_custom_1484859970902{margin-top: 60px !important;margin-bottom: 10px !important;}"]Raleway[/vc_column_text][vc_custom_heading text="A B C D E F G H I J K L M N O P Q R S T U V W X Y Z" font_container="tag:h3|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Raleway%3A100%2C200%2C300%2Cregular%2C500%2C600%2C700%2C800%2C900|font_style:400%20regular%3A400%3Anormal"][vc_custom_heading text="a b c d e f g h i j k l m n o p q r s t u v w x y z" font_container="tag:h4|font_size:30|text_align:left|color:%230a0a0a" google_fonts="font_family:Raleway%3A100%2C200%2C300%2Cregular%2C500%2C600%2C700%2C800%2C900|font_style:400%20regular%3A400%3Anormal"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'portfolio general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-header.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1484674945481{margin-bottom: 5px !important;}"]
<h5>Client</h5>
[/vc_column_text][fancy-ul icon_type="none" alignment="left"]Salient VR[/fancy-ul][vc_column_text css=".vc_custom_1484674769843{margin-top: 30px !important;margin-bottom: 5px !important;}"]
<h5>Year</h5>
[/vc_column_text][vc_column_text]2017[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1484674851189{margin-bottom: 5px !important;}"]
<h5>Awards &amp; Mentions</h5>
[/vc_column_text][fancy-ul icon_type="none" alignment="left"]
<ul>
 	<li>VR Inspire</li>
 	<li>Reality Awards</li>
 	<li>Best Promo</li>
</ul>
[/fancy-ul][vc_column_text css=".vc_custom_1484674634267{margin-top: 30px !important;margin-bottom: 5px !important;}"]
<h5>Deliverables</h5>
[/vc_column_text][fancy-ul icon_type="none" alignment="left"]
<ul>
 	<li>Advertisement</li>
 	<li>Photography</li>
 	<li>Strategy</li>
</ul>
[/fancy-ul][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_column_text]
<h2>Somewhere, something incredible is waiting to be known.</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1484675963264{margin-top: 50px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Project Header Dark Background', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-header-4.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#212121" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1484674945481{margin-bottom: 5px !important;}"]
<h5>Client</h5>
[/vc_column_text][fancy-ul icon_type="none"]Salient VR[/fancy-ul][vc_column_text css=".vc_custom_1484674769843{margin-top: 30px !important;margin-bottom: 5px !important;}"]
<h5>Year</h5>
[/vc_column_text][vc_column_text]2017[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1484674851189{margin-bottom: 5px !important;}"]
<h5>Awards &amp; Mentions</h5>
[/vc_column_text][fancy-ul icon_type="none"]
<ul>
 	<li>VR Inspire</li>
 	<li>Reality Awards</li>
 	<li>Best Promo</li>
</ul>
[/fancy-ul][vc_column_text css=".vc_custom_1484674634267{margin-top: 30px !important;margin-bottom: 5px !important;}"]
<h5>Deliverables</h5>
[/vc_column_text][fancy-ul icon_type="none"]
<ul>
 	<li>Advertisement</li>
 	<li>Photography</li>
 	<li>Strategy</li>
</ul>
[/fancy-ul][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_column_text]
<h2>Somewhere, something incredible is waiting to be known.</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1484675963264{margin-top: 50px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Milestone With Icons Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons'] .', '. $cat_display_names['hero_section'] .', '. $cat_display_names['counters'];
$data['custom_class'] = 'icons hero_section counters';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/milestone-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/JgOeRuGD_Y4" bg_position="left top" bg_repeat="no-repeat" bg_color="#1e1e1e" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_animated_title heading_tag="h5" style="hinge-drop" color="Accent-Color" text="Section No. 4"][split_line_heading]
<h2>Far far away, behind</h2>
<h2>the word mountains</h2>
[/split_line_heading][vc_column_text]far from the countries Vokalia and Consonantia, there live the blind texts Separated they live in Bookmarksgrove right at the coast of the Semantics.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="10%" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Duplicate-Window"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Superscript" number="125" subject="Salient Templates" number_font_size="92" symbol="+" symbol_font_size="44"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Add-User"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Default" effect="count" symbol_alignment="Default" number="55" subject="Theme Users" number_font_size="92" symbol="k" symbol_font_size="92"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Trophy"][milestone heading_inherit="h2" subject_padding="2%" color="Default" effect="count" number="4000" subject="Five star ratings" number_font_size="92"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal Header With CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'general cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal-header.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="120" bottom_padding="80" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text max_width="700" css=".vc_custom_1482355453219{margin-bottom: 30px !important;}"]
<h2><span style="color: #000000;">Hello, I'm Phil. I am a digital designer from Philly focusing on UI design.</span></h2>
[/vc_column_text][nectar_cta heading_tag="h4" link_type="new_tab" alignment="left" text="Wanna get in touch?" link_text="Let's talk" url="#"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Parallax Video Lightbox Row Dark', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'general hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/parallax-video-lightbox.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/422400/daily" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484862427754{margin-bottom: 5px !important;}"]
<h5>Look Inside</h5>
[/vc_column_text][vc_column_text css=".vc_custom_1484862386675{margin-bottom: 35px !important;}"]
<h2>Discover Salient VR</h2>
[/vc_column_text][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Project Header Alternative', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-header-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="1"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Intro" font_container="tag:h5|text_align:left|color:%23603dff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1484856757740{margin-bottom: 30px !important;}"]
<h3>Imagination will often carry us to worlds that never were. But without it we go nowhere.</h3>
[/vc_column_text][vc_column_text]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="40" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Services" font_container="tag:h5|text_align:left|color:%23603dff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid"][vc_column_text]Web design, Graphic design, Photography[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Clients" font_container="tag:h5|text_align:left|color:%23603dff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid"][vc_column_text]ThemeNectar[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Google Map Flat', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['google_map'];
$data['custom_class'] = 'map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ultra-flat-map-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="14" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" ultra_flat="1" size="700" map_center_lat="40.793" map_center_lng="-73.954" map_markers="39.949|-75.171|Our Location 
40.793|-73.954|Our Location #2"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Four Visible, Touch Enabled Gallery', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'portfolio gallery general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-gallery-phones.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gradient_text heading_tag="h2" color="extra-color-gradient-1" gradient_direction="horizontal" text="What We Delivered"][vc_column_text max_width="600"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" bottom_padding="6%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_gallery type="flickity_style" images="" flickity_controls="material_pagination" flickity_desktop_columns="4" flickity_small_desktop_columns="3" flickity_tablet_columns="2" flickity_box_shadow="none" onclick="link_no" img_size="full"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Three Visible, Touch Enabled Gallery Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio gallery';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/touch-enabled-3.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#181a1c" scene_position="center" text_color="light" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_gallery type="flickity_style" images="" flickity_controls="material_pagination" flickity_desktop_columns="3" flickity_small_desktop_columns="3" flickity_tablet_columns="1" flickity_box_shadow="x_large_depth" onclick="link_no" img_size="full"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Nifty Hero With Bottom Columns & Gradient Overlay', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'hero_section about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hero-bottom-cols.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/422400/daily" bg_position="center center" bg_repeat="no-repeat" bg_color="#383838" scene_position="center" text_color="light" text_align="left" top_padding="4%" bottom_padding="4%" enable_gradient="true" color_overlay="#191919" color_overlay_2="#6b6b6b" gradient_direction="left_b_to_right_t" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="15%" bottom_padding="14%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>We Are Salient, A <em>Creative</em></h2>
<h2>Agency Based in Philly</h2>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Umbrella-2" icon_size="36" margin_bottom="5"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485465877383{margin-bottom: 15px !important;}"]
<h4>There For You</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia texts." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485466909711{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Diamond" icon_size="36" margin_bottom="5px"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363986301{margin-bottom: 15px !important;}"]
<h4>Pristine Quality</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia texts." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485466916092{padding-right: 20% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="0px" icon_iconsmind="iconsmind-Favorite-Window" icon_size="36" margin_bottom="5px"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363991162{margin-bottom: 15px !important;}"]
<h4>Heavily Awarded</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia texts." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485466921027{padding-right: 20% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fresh Background Hero Full Height Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/purple_hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/tBt9JxuQBYs" bg_position="center center" bg_repeat="no-repeat" full_height="yes" scene_position="center" text_color="light" text_align="left" enable_gradient="true" color_overlay="#1d89f9" color_overlay_2="#0a56d1" gradient_direction="top_to_bottom" overlay_strength="0.8"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Are you ready?" font_container="tag:h4|font_size:20|text_align:center|color:%23ffffff|line_height:26px" google_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css_animation="none" css=".vc_custom_1485614491282{margin-bottom: -10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_custom_heading text="This is Salient" font_container="tag:h4|font_size:94|text_align:center|color:%23ffffff|line_height:114px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal" css_animation="none" css=".vc_custom_1485614497918{margin-bottom: -10px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast." font_container="tag:p|font_size:18|text_align:center|color:rgba(255%2C255%2C255%2C0.74)|line_height:28px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css_animation="none" css=".vc_custom_1485614418364{padding-right: 5% !important;padding-left: 5% !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][nectar_btn size="large" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="iconsmind" url="#" text="Learn More" icon_iconsmind="iconsmind-Triangle-ArrowRight" margin_top="30"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Simple Google Map', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['google_map'];
$data['custom_class'] = 'map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/google-map.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="15" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" size="700" map_center_lat="40.793" map_center_lng="-73.954" map_markers="39.949|-75.171|Our Location 
40.793|-73.954|Our Location #2"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Milestones', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['counters'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'counters general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/project-stats.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h2>Project Stats</h2>
[/vc_column_text][divider line_type="Small Line" line_thickness="4" divider_color="accent-color" animate="yes" custom_height="100" custom_line_width="100"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" symbol_position="after" subject_padding="2%" color="Accent-Color" effect="count" symbol_alignment="Superscript" number="186" symbol="%" subject="Percent increase in overall concert head count" number_font_size="92" symbol_font_size="40"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Accent-Color" effect="count" number="347" subject="Merchandise items sold during the main concert" number_font_size="92"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][milestone heading_inherit="h2" subject_padding="2%" color="Accent-Color" effect="count" number="239" subject="Raving reviews written after the show ended" number_font_size="92"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Flat Dark Scheme Map', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['google_map'];
$data['custom_class'] = 'map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ultra-flat-map.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="6" enable_zoom="1" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" ultra_flat="1" dark_color_scheme="1" size="700" map_center_lat="39.949" map_center_lng="-75.176" map_markers="39.949|-75.171|
"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Map Section Dark Scheme', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['google_map'];
$data['custom_class'] = 'map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-map.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap zoom="16" marker_style="nectar" nectar_marker_color="accent-color" map_greyscale="1" dark_color_scheme="1" size="700" map_center_lat="39.949" map_center_lng="-75.176" map_markers="39.949|-75.171|
"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Gradient Icons Dark Background', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['icons'] .', '. $cat_display_names['services'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'icons services about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-icons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#161616" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Beauty Like You've Never Seen" font_container="tag:h2|font_size:48px|text_align:center|line_height:57px" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Umbrella-2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363965531{margin-bottom: 15px !important;}"]
<h4>There For You</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Diamond" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363986301{margin-bottom: 15px !important;}"]
<h4>Pristine Quality</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Trophy-2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363991162{margin-bottom: 15px !important;}"]
<h4>Heavily Awarded</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-T-Shirt" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485368415399{margin-bottom: 15px !important;}"]
<h4>eCommerce Ready</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Wolf" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485368428679{margin-bottom: 15px !important;}"]
<h4>Ready For All</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Grave" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485368441656{margin-bottom: 15px !important;}"]
<h4>Eliminate Competition</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Team Member Carousel (Classic Style)', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['team'];
$data['custom_class'] = 'team';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/team-member-carousel.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][carousel script="owl_carousel" desktop_cols="3" desktop_small_cols="3" tablet_cols="2" mobile_cols="1" column_padding="20px" autorotate="true" enable_animation="true" autorotation_speed="6000"][item id="1485280429528-2f311-50d3" title="Item" tab_id="1485798432237-4"][team_member team_memeber_style="meta_below" link_element="none" color="Accent-Color" name="Aura Brooks" image_url="https://source.unsplash.com/BZ2PNGD5Emw/600x400" job_position="Graphic Designer" description="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows." social="Facebook,http://facebook.com, Twitter,http://twitter.com, Youtube,http://youtube.com"][/item][item id="1485280429578-0f311-50d3" title="Item" tab_id="1485798432247-5"][team_member image_url="https://source.unsplash.com/tBt9JxuQBYs/600x400" team_memeber_style="meta_below" link_element="none" color="Accent-Color" name="Eve Crawford" job_position="Product Designer" description="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows." social="Facebook,http://facebook.com, Twitter,http://twitter.com, Youtube,http://youtube.com"][/item][item id="1485280429578-0f311-50d3" title="Item" tab_id="1485798432271-6"][team_member image_url="https://source.unsplash.com/R5tHd-aYmPs/600x400" team_memeber_style="meta_below" link_element="none" color="Accent-Color" name="Alex Parker" job_position="Founder" description="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows." social="Facebook,http://facebook.com, Twitter,http://twitter.com, Youtube,http://youtube.com"][/item][item id="1485280429578-0f311-50d3" title="Item" tab_id="1485798432293-8"][team_member image_url="https://source.unsplash.com/HZGkX1vKJvo/600x400" team_memeber_style="meta_below" link_element="none" color="Accent-Color" name="Jessica Collins" job_position="Graphic Designer" description="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows." social="Facebook,http://facebook.com, Twitter,http://twitter.com, Youtube,http://youtube.com"][/item][item id="1485280429578-0f311-50d3" title="Item" tab_id="1485798432305-6"][team_member team_memeber_style="meta_below" image_url="https://source.unsplash.com/featured/600x400/?face" link_element="none" color="Accent-Color" name="Luke Smith" job_position="Web Developer" description="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows." social="Facebook,http://facebook.com, Twitter,http://twitter.com, Youtube,http://youtube.com"][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Two Info Boxes', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'about services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/two-color-boxes.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#d0d7dd" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column enable_animation="true" animation="flip-in-vertical" column_padding="padding-6-percent" column_padding_position="all" background_color="#ff3a6f" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485280135262{margin-bottom: 10px !important;}"]
<h5>Reason One</h5>
[/vc_column_text][vc_custom_heading text="Salient can elevate your business to new heights" font_container="tag:h2|font_size:44|text_align:left|color:%23ffffff|line_height:50px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485279924521{margin-top: 30px !important;margin-bottom: 30px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][nectar_cta heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Learn More"][/vc_column][vc_column enable_animation="true" animation="flip-in-vertical" column_padding="padding-6-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="x_large_depth" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text css=".vc_custom_1485280173184{margin-bottom: 10px !important;}"]
<h5><span style="color: #ff3a6f;">Reason Two</span></h5>
[/vc_column_text][vc_custom_heading text="The ultimate WordPress theme" font_container="tag:h2|font_size:44|text_align:left|color:%23ff3a6f|line_height:50px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485279928611{margin-top: 30px !important;margin-bottom: 30px !important;}"]<span style="color: #ff3a6f;">I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.</span>[/vc_column_text][nectar_cta heading_tag="h5" text_color="#ff3a6f" link_type="regular" alignment="left" link_text="Learn More"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Misty Background Info Boxes', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/two-color-boxes-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/collection/179646/daily" bg_position="left top" bg_repeat="no-repeat" bg_color="#0a0909" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#262e38" overlay_strength="0.95"][vc_column enable_animation="true" animation="flip-in-vertical" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="200"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://source.unsplash.com/800x600" hover_effect="defaut" box_shadow="none" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][vc_column enable_animation="true" animation="flip-in-vertical" column_padding="padding-6-percent" column_padding_position="all" background_color="#3454ff" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Salient can elevate your business to new heights. Separated they live in Bookmarksgrove right at the coast of the Semantic." font_container="tag:h2|font_size:26|text_align:left|color:%23ffffff|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal"][divider line_type="No Line" custom_height="20"][nectar_cta heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Learn More"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Side Area With Toggle Panels', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'general services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/toggles.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][toggles style="minimal" accordion="true"][toggle color="Default" title="What exactly is Salient App? "][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus. Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="How do I create my own Salient App account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Do I need to link my bank account in order to use it?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Will Salient Service work on my mobile device?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Is it available in my country?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Quality Design" font_container="tag:h5|font_size:16|text_align:left|color:%230a0a0a" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_column_text css=".vc_custom_1485277620875{margin-bottom: 40px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_custom_heading text="High Performance " font_container="tag:h5|font_size:16|text_align:left|color:%230a0a0a" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_column_text css=".vc_custom_1485277635320{margin-bottom: 40px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][nectar_btn size="large" button_style="see-through-3d" color_override="#006afe" url="#" text="Learn More"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Full Height Split Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/full-height.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" full_height="yes" columns_placement="stretch" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/467163/daily" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="500"][/vc_column][vc_column column_padding="padding-8-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_animated_title heading_tag="h5" style="color-strip-reveal" color="Accent-Color" text="Not even lying"][vc_custom_heading text="The best WordPress theme that ever existed" font_container="tag:h2|font_size:42|text_align:left|line_height:52px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485279202957{margin-top: 30px !important;margin-bottom: 30px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][vc_column_text css=".vc_custom_1485279159583{margin-bottom: 30px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. I am text block.[/vc_column_text][nectar_cta heading_tag="h5" text_color="#2f4eff" link_type="regular" alignment="left" link_text="Learn More" url="#"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Brilliant Animated Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'hero_section about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hero-video-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/422400/daily" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][/vc_row_inner][split_line_heading]
<h2>The Ultimate</h2>
<h2>WordPress Theme</h2>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts The Big Oxmox advised her." font_container="tag:h5|font_size:20|text_align:center|color:rgba(255%2C255%2C255%2C0.7)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:300%20light%20regular%3A300%3Anormal" css=".vc_custom_1485461515255{padding-right: 10% !important;padding-left: 10% !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="450"][nectar_btn size="large" button_style="see-through" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="Learn About Us" margin_top="10" margin_right="10" margin_bottom="10" margin_left="10" icon_iconsmind="iconsmind-Triangle-ArrowRight"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" color_override="#ff3269" icon_family="iconsmind" url="#" text="View Our Work" margin_top="10" margin_right="10" margin_bottom="10" margin_left="10" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Icon List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'icons services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/icon-list.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" id="steps" row_name="Sign Up Steps" overlay_strength="0.3"][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/phone-normal.jpg" alignment="" animation="Fade In From Left" box_shadow="none" max_width="100%"][/vc_column][vc_column column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][nectar_icon_list animate="true" color="default" icon_size="small" icon_style="border"][nectar_icon_list_item icon_type="numerical" title="List Item" id="1485276126956-360e1-d94e" header="Sign Up For Free" text="Create your free account in a matter of minutes with our patented awesome sign up process." tab_id="1485457205085-0"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1485276126966-560e1-d94e" header="Sell Goods Online" text="Next start integrating it with your e-commerce platform of choice and start accepting payments." tab_id="1485457205092-10"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1485276126979-860e1-d94e" header="Love Your Life" text="Sit back, relax and pop a cold one because your life just got a whole lot easier by using Salient." tab_id="1485457205111-2"][/nectar_icon_list_item][/nectar_icon_list][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Professional Info & Icon List ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons'] .', '. $cat_display_names['services'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'icons services general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/icons-right.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#1a1d21" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-10-percent" column_padding_position="all" background_color="#0054ff" background_color_opacity="0.9" background_hover_color_opacity="1" background_image="" enable_bg_scale="true" font_color="#ffffff" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="How's This Look?" font_container="tag:h5|text_align:center|color:%23ffffff" use_theme_fonts="yes"][vc_custom_heading text="Beauty And Power Meet In Salient" font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes"][divider line_type="No Line" custom_height="20"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.69)" use_theme_fonts="yes" css=".vc_custom_1485459419272{padding-right: 15% !important;padding-left: 15% !important;}"][/vc_column][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color="#1a1d21" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="Accent-Color" icon_padding="15px" icon_iconsmind="iconsmind-Thunder" url="#" margin_bottom="10"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Thousands Of Icons</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350"]<span style="color: #aaa;">Salient comes packed with amazing icon families for you to choose from. Practically anything you could imagine exists.</span>[/vc_column_text][divider line_type="No Line" custom_height="50"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="Accent-Color" icon_padding="25px" icon_iconsmind="iconsmind-Wolf" margin_bottom="15" icon_size="40" url="#"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Beautiful Design</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350"]<span style="color: #aaa;">Quality over quantity. Enjoy a vast array of carefully designed &amp; unique elements with tons of control over fine tuning them.</span>[/vc_column_text][divider line_type="No Line" custom_height="50"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="Accent-Color" icon_padding="25px" icon_iconsmind="iconsmind-Microscope" margin_bottom="15" icon_size="40" url="#"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Extensive Documentation</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350"]<span style="color: #aaa;"> Never feel lost again. Documentation is available in addition to a series of video tutorials exclusively for Salient.</span>[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Mighty Split - Gradient Icons & Info ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons'] .', '. $cat_display_names['services'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'icons services general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/icons-left.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="15px" icon_iconsmind="iconsmind-Thunder" url="#" margin_bottom="10"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Thousands Of Icons</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350"]<span style="color: #aaa;">Salient comes packed with amazing icon families for you to choose from. Practically anything you could imagine exists.</span>[/vc_column_text][divider line_type="No Line" custom_height="50"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Wolf" margin_bottom="15" icon_size="40" url="#"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Beautiful Design</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350"]<span style="color: #aaa;">Quality over quantity. Enjoy a vast array of carefully designed &amp; unique elements with tons of control over fine tuning them.</span>[/vc_column_text][divider line_type="No Line" custom_height="50"][nectar_icon icon_family="iconsmind" icon_style="border-animation" icon_border_thickness="2px" icon_color="extra-color-gradient-1" icon_padding="25px" icon_iconsmind="iconsmind-Microscope" margin_bottom="15" icon_size="40" url="#"][divider line_type="No Line" custom_height="10"][vc_column_text max_width="315"]
<h4>Extensive Documentation</h4>
[/vc_column_text][divider line_type="No Line" custom_height="5"][vc_column_text max_width="350"]<span style="color: #aaa;"> Never feel lost again. Documentation is available in addition to a series of video tutorials exclusively for Salient.</span>[/vc_column_text][/vc_column][vc_column centered_text="true" column_padding="padding-10-percent" column_padding_position="all" background_color="#0a0a0a" background_color_opacity="0.5" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/190727/daily" font_color="#ffffff" column_shadow="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="How's This Look?" font_container="tag:h5|text_align:center|color:%23ffffff" use_theme_fonts="yes"][vc_custom_heading text="Ultra Fast, Modern And Very Sexy" font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes"][divider line_type="No Line" custom_height="20"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo." font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.69)" use_theme_fonts="yes" css=".vc_custom_1485459419272{padding-right: 15% !important;padding-left: 15% !important;}"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Info Boxes & Testimonial', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['icons'] .', '. $cat_display_names['testimonials'];
$data['custom_class'] = 'icons testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonial-text-columns.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/317099/daily" bg_position="left top" bg_repeat="no-repeat" bg_color="#383838" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="“Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic”" font_container="tag:h4|font_size:18px|text_align:center|line_height:37px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css_animation="none"][divider line_type="No Line" custom_height="15"][vc_custom_heading text="Jennifer Smith" font_container="tag:h5|font_size:16px|text_align:center|line_height:22px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css_animation="none"][vc_custom_heading text="Graphic Designer" font_container="tag:h5|font_size:13px|text_align:center|color:rgba(255%2C255%2C255%2C0.45)|line_height:13px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="20px" icon_iconsmind="iconsmind-Umbrella-2"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363965531{margin-bottom: 15px !important;}"]
<h4>There For You</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="20px" icon_iconsmind="iconsmind-Diamond"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363986301{margin-bottom: 15px !important;}"]
<h4>Pristine Quality</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" icon_padding="20px" icon_iconsmind="iconsmind-Favorite-Window"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485363991162{margin-bottom: 15px !important;}"]
<h4>Heavily Awarded</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts" font_container="tag:p|text_align:center|color:rgba(255%2C255%2C255%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Hero With Video, Testimonial & Info Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['hero_section'] .', '. $cat_display_names['testimonials'];
$data['custom_class'] = 'about hero_section testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-testimonial-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="top" bg_image="https://source.unsplash.com/collection/317099/daily" bg_position="left top" bg_repeat="no-repeat" bg_color="#1e1e1e" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#0a0a0a" overlay_strength="0.8"][vc_column column_padding="padding-5-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/800/510/" hover_effect="defaut" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="15"][vc_custom_heading text="“Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantic”" font_container="tag:h4|font_size:18px|text_align:left|line_height:37px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css_animation="fadeInLeft"][divider line_type="No Line" custom_height="15"][vc_custom_heading text="Jennifer Smith" font_container="tag:h5|font_size:16px|text_align:left|line_height:22px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css_animation="fadeInLeft"][vc_custom_heading text="Graphic Designer" font_container="tag:h5|font_size:13px|text_align:left|color:rgba(255%2C255%2C255%2C0.45)|line_height:13px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css_animation="fadeInLeft"][divider line_type="No Line" custom_height="50"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="This Is Salient" font_container="tag:h2|font_size:62|text_align:left|line_height:62px" use_theme_fonts="yes" css_animation="fadeInUp"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo elit tellus amet." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359757045{margin-bottom: 15px !important;}"]
<h5>Design</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637066714{padding-right: 8% !important;}"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359780281{margin-top: 40px !important;margin-bottom: 15px !important;}"]
<h5>Deploy</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637073423{padding-right: 8% !important;}"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359774542{margin-bottom: 15px !important;}"]
<h5>Develop</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637078780{padding-right: 8% !important;}"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359784260{margin-top: 40px !important;margin-bottom: 15px !important;}"]
<h5>Support</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485637085146{padding-right: 8% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Image Overflowing Left Dark Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'about hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-overflow.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#151515" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/macbook.png" alignment="right" animation="Fade In From Left" box_shadow="none" max_width="225%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="This Is Salient" font_container="tag:h2|font_size:62|text_align:left|line_height:62px" use_theme_fonts="yes" css_animation="fadeInUp"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo elit tellus amet." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="40" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359757045{margin-bottom: 15px !important;}"]
<h5>Design</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485638352644{padding-right: 10% !important;}"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359780281{margin-top: 40px !important;margin-bottom: 15px !important;}"]
<h5>Deploy</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485638357220{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359774542{margin-bottom: 15px !important;}"]
<h5>Develop</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485638366488{padding-right: 10% !important;}"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485359784260{margin-top: 40px !important;margin-bottom: 15px !important;}"]
<h5>Support</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485638371087{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Overflowing Right Dark Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['hero_section'];
$data['custom_class'] = 'about hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ipad-right-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#151515" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" id="save-time" row_name="Save Time" overlay_strength="0.3"][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Save Yourself Time By Using Salient" font_container="tag:h2|font_size:62|text_align:left|line_height:62px" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" font_color="#777777" width="1/1" column_border_width="none" column_border_style="solid" delay="150"][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo elit tellus amet." font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" font_color="#777777" width="1/1" column_border_width="none" column_border_style="solid" delay="300"][fancy-ul icon_type="font_icon" icon="icon-caret-right" color="Accent-Color" alignment="left" enable_animation="true" delay="100"]
<ul>
 	<li>Top Customer Support</li>
 	<li>Most Liked Company</li>
 	<li>Best In Class 2016</li>
 	<li>Friendliest Group</li>
 	<li>Innovative Brand</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/ipad-hor-dark.png" alignment="" animation="Fade In From Right" box_shadow="none" max_width="165%"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Parallax Image Background', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/parallax-bg-img.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/collection/483346/daily" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Minimal CTA Strip', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'general cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/call-to-action.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#f4f4f4" scene_position="center" text_color="dark" text_align="left" top_padding="80" bottom_padding="80" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Sign Up Today &amp; Start Sending Money." font_container="tag:h2|font_size:52|text_align:left|line_height:56px" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_column_text css=".vc_custom_1485272593024{margin-top: 15px !important;}"]Get 30 days free when you sign up now.[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="see-through-3d" color_override="#006afe" url="#" text="Sign Up Now"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Device Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/device_video.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/daily?mountain" bg_position="left top" bg_repeat="no-repeat" bg_color="#1e1e1e" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="15%" color_overlay="#242838" overlay_strength="0.95"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="30" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="left-right" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Like Nothing You've Seen" font_container="tag:h2|font_size:52|text_align:center|line_height:52px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="left-right" centered_text="true" background_color_opacity="1" width="2/3" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="http://54cb3baa74d4d851e8b7-2e7f88565dceb0a8192c6645d1f8b1b4.r12.cf2.rackcdn.com/iphone-hor.png" hover_effect="zoom_button" box_shadow="none" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="60" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485620340174{margin-bottom: 15px !important;}"]
<h5>Design</h5>
[/vc_column_text][vc_custom_heading text="But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485639261992{padding-right: 13% !important;}"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485620353894{margin-bottom: 15px !important;}"]
<h5>Develop</h5>
[/vc_column_text][vc_custom_heading text="But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485639271098{padding-right: 13% !important;}"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485620358602{margin-bottom: 15px !important;}"]
<h5>Deploy</h5>
[/vc_column_text][vc_custom_heading text="But nothing the copy said could convince her and so it didn’t take long until a few insidious Copy Writers ambushed her." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1485639277257{padding-right: 13% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Pristine Team', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['team'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'team about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/non-fullwidth-team.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="60" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Meet Our Team" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][divider line_type="Small Line" line_thickness="2" divider_color="accent-color" animate="yes" custom_height="40" custom_line_width="40"][vc_column_text max_width="650"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/BZ2PNGD5Emw/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Igor Kozlov" job_position="Graphic Designer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/tBt9JxuQBYs/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Mark Jones" job_position="Back-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/R5tHd-aYmPs/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Andre Smith" job_position="Fine Artist" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/500x500/?person" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Ethan Young" job_position="Team Leader" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/5lexwsAzUT4/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="Ava Morgan" job_position="The SEO Expert" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" column_border_width="none" column_border_style="solid"][team_member image_url="https://source.unsplash.com/HZGkX1vKJvo/500x500" bio_image_url="http://themenectar.com/demo/dummy-data-imgs/business/about-team-member-big.jpg" team_memeber_style="bio_fullscreen" name="James Anderson" job_position="Front-end Developer" team_member_bio="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Pie Chart Three Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['counters'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'counters about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/piechart.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3"][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_pie value="80" color="#0090ff" title="UI Design" units="%"][/vc_column_inner][/vc_row_inner][vc_column_text css=".vc_custom_1485285889042{margin-top: -15px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_pie value="64" color="#ff3a3a" title="Web Design" units="%"][/vc_column_inner][/vc_row_inner][vc_column_text css=".vc_custom_1485285893250{margin-top: -15px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][/vc_column][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_pie value="75" color="#2AC4EA" title="Photography" units="%"][/vc_column_inner][/vc_row_inner][vc_column_text css=".vc_custom_1485285897481{margin-top: -15px !important;}"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Minimal CTA Strip Alt', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'].', '. $cat_display_names['cta'];
$data['custom_class'] = 'general cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/call-to-action-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="80" bottom_padding="80" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Sign Up Today &amp; Start Sending Money." font_container="tag:h2|font_size:52|text_align:left|line_height:56px" google_fonts="font_family:Roboto%20Condensed%3A300%2C300italic%2Cregular%2Citalic%2C700%2C700italic|font_style:700%20bold%20regular%3A700%3Anormal"][vc_column_text css=".vc_custom_1485272593024{margin-top: 15px !important;}"]Get 30 days free when you sign up now.[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="see-through-3d" color_override="#ff0044" url="#" text="Sign Up Now"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'vCard Minimal Colorful', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-minimal-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/OeMKiYxFzmU" alignment="" animation="Fade In" box_shadow="x_large_depth" max_width="100%"][/vc_column][vc_column column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Philip Martinez" font_container="tag:h5|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css=".vc_custom_1485271332280{margin-bottom: 10px !important;}"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485195197203{margin-top: 30px !important;margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia[/vc_column_text][divider line_type="No Line" custom_height="50"][vc_custom_heading text="What I Do" font_container="tag:h5|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css=".vc_custom_1485271340468{margin-bottom: 10px !important;}"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="none" alignment="left"]
<ul>
	<li>Graphic Design</li>
	<li>Web Development</li>
	<li>Video Editing</li>
	<li>Audio Engineering</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="none" alignment="left"]
<ul>
	<li>Social Marketing</li>
	<li>NEC Strategy</li>
	<li>SEO Audits</li>
	<li>Branding</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Facebook-2" icon_size="29" margin_left="-20px" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Reddit" icon_size="29" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="white" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Dribble" icon_size="29" url="#"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'vCard Minimal', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-minimal.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="4%" bottom_padding="7%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/OeMKiYxFzmU" alignment="" animation="Fade In" box_shadow="x_large_depth" max_width="100%"][/vc_column][vc_column column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Philip Martinez" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1485193607322{margin-bottom: 10px !important;}"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1485195197203{margin-top: 30px !important;margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia[/vc_column_text][divider line_type="No Line" custom_height="50"][vc_custom_heading text="What I Do" font_container="tag:h5|text_align:left|color:%23bfbfbf" use_theme_fonts="yes" css=".vc_custom_1485193623501{margin-bottom: 10px !important;}"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="none" alignment="left"]
<ul>
	<li>Graphic Design</li>
	<li>Web Development</li>
	<li>Video Editing</li>
	<li>Audio Engineering</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="none" alignment="left"]
<ul>
	<li>Social Marketing</li>
	<li>NEC Strategy</li>
	<li>SEO Audits</li>
	<li>Branding</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Facebook-2" icon_size="29" margin_left="-20px" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Reddit" icon_size="29" url="#"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" open_new_tab="true" icon_padding="20px" icon_iconsmind="iconsmind-Dribble" icon_size="29" url="#"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Personal Story', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/personal_story.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" vertically_center_columns="true" bg_color="#a65bf4" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/600x1000/daily/?smile" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h1>Eric Jördis</h1>
[/vc_column_text][divider line_type="No Line" custom_height="20"][vc_column_text]
<h2>"Aliquam" erat volutpat. Phasellus tortor velit, ornare at ullamcorper at, ultrices et diam at nunc.</h2>
[/vc_column_text][divider line_type="No Line" custom_height="30"][vc_column_text]Morbi nec ultrices tellus. Fusce id est quis orci faucibus congue. Aliquam erat volutpat. Phasellus tortor velit, ornare at ullamcorper at, ultrices et justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Quisque cursus, sem eget convallis viverra, nunc ante vulputate nunc, at sagittis nisi diam at nunc. Morbi posuere fringilla viverra. Vivamus vestibulum nisl non elementum. Nulla lorem tellus, pulvinar in neque luctus, scelerisque facilisis lectus. In leo justo, scelerisque et auctor nec, suscipit accumsan neque. Nullam feugiat diam at mauris fermentum

Maximus justo vulputate vitae. Nulla ipsum leo, commodo sit amet congue sed, porta nec elit. Mauris mollis tempus ipsum, id bibendum metus lobortis ac. Donec vitae felis imperdiet, lobortis lorem vitae, efficitur ligula. Pellentesque in condimentum libero. Duis iaculis magna diam, vitae fringilla sapien commodo eget. Pellentesque vehicula varius placerat. Sed aliquam commodo dolor. Quisque cursus, sem eget convallis viverra, nunc ante vulputate nunc, at sagittis nisi diam at nunc.[/vc_column_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" vertically_center_columns="true" bg_color="#ffffff" scene_position="center" text_color="light" text_align="right" id="reasons" overlay_strength="0.3"][vc_column column_padding="padding-3-percent" column_padding_position="all" background_color="#f2f2f2" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][milestone heading_inherit="default" symbol_position="after" subject_padding="0" color="Accent-Color" effect="motion_blur" symbol_alignment="Superscript" number="78" symbol="+" number_font_size="158" symbol_font_size="57"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="left" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="25"][vc_column_text]
<h5 style="text-align: left;"><span style="color: #933ded;">Projects</span></h5>
<h4 style="text-align: left;"><span style="color: #933ded;">Completed</span></h4>
<p style="text-align: left;"><span style="color: #000000;">Duis iaculis magna diam neque </span>
<span style="color: #000000;">Sed aliqua commodo aliquet. </span>

[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color="#a65bf4" background_color_opacity="0.8" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/217569/daily" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="padding-10-percent" column_padding_position="all" background_color="#a65bf4" background_color_opacity="0.7" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/179646/daily" column_shadow="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fancy Horizontal Tabbed Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'].', '. $cat_display_names['services'];
$data['custom_class'] = 'general services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/fancy_tabs.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" scene_position="center" text_color="dark" text_align="left" top_padding="100" bottom_padding="5%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1"][tabbed_section style="minimal" alignment="left" cta_button_style="extra-color-2" cta_button_text="Buy Now" cta_button_link="http://themeforest.net/item/salient-responsive-multipurpose-theme/4363266"][tab title="Page Builder" tab_id="1446568150305-7"][vc_row_inner][vc_column_inner enable_animation="true" animation="fade-in-from-right" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/4" offset="vc_col-lg-3 vc_col-md-4"][vc_column_text]
<h5 style="text-align: right;">Before Salient</h5>
<p style="text-align: right;"><span style="color: #a3a3a3;">Hand rolling code is fun sometimes, but not ideal for getting projects done quickly or allowing clients to maintain pages.</span></p>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom" background_color_opacity="1" width="1/2" offset="vc_col-lg-6 vc_col-md-8"][nectar_image_comparison][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" width="1/4" offset="vc_col-lg-offset-0 vc_col-lg-3 vc_col-md-offset-4 vc_col-md-8"][vc_column_text]
<h5>With Salient</h5>
<span style="color: #a3a3a3;">Salient provides you a highly customized version of Visual Composer bundled with unique elements all available for use via the drag &amp; drop interface.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab title="Imagine" tab_id="1446565195463-2"][vc_row_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" width="1/2"][vc_column_text]
<h6><span style="color: #1e83ec;">No Matter What</span></h6>
[/vc_column_text][vc_column_text]
<h2>All we do is win</h2>
[/vc_column_text][vc_column_text]Vivamus eu neque ut sem malesuada consectetur sed sed felis. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae. ullam et eros ornare, porttitor urna sed, auctor lacus. Morbi viverra lorem at neque tincidunt consequat.

<span style="color: #a3a3a3;">Praesent eget ullamcorper enim. Curabitur scelerisque mi dolor, eget egestas sem interdum eget. Etiam eros tortor, malesuada sed velit a, rhoncus congue elit.</span>

[button color="see-through-2" hover_text_color_override="#fff" image="default-arrow" size="medium" url="http://themenectar.com/demo/salient-corporate/2013/03/magna-fringilla-quis-condimentum/" text="Seriously, we do" color_override="#1e83ec" hover_color_override="#1e83ec"][/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4"][vc_column_text css=".vc_custom_1452016245742{margin-bottom: 18px !important;}"]
<h5>Target Auidence</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">Medium Businesses</span></li>
	<li><span style="color: #999999;">Freelance Designers</span></li>
	<li><span style="color: #999999;">College Students</span></li>
	<li><span style="color: #999999;">Sorta Athletes</span></li>
	<li><span style="color: #999999;">Dairy Farmers</span></li>
</ul>
[/fancy-ul][divider line_type="No Line" custom_height="20"][vc_column_text css=".vc_custom_1452016227170{margin-bottom: 18px !important;}"]
<h5>Our Specialties</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">Program Management</span></li>
	<li><span style="color: #999999;">Graphic &amp; UI Design</span></li>
	<li><span style="color: #999999;">Customer Support</span></li>
	<li><span style="color: #999999;">Video Editing</span></li>
	<li><span style="color: #999999;">Sound Design</span></li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4"][vc_column_text css=".vc_custom_1452016219737{margin-bottom: 18px !important;}"]
<h5>Notable Awards</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">Top Customer Support</span></li>
	<li><span style="color: #999999;">Most Liked Company</span></li>
	<li><span style="color: #999999;">Best In Class 2016</span></li>
	<li><span style="color: #999999;">Friendliest Group</span></li>
	<li><span style="color: #999999;">Innovative Brand</span></li>
</ul>
[/fancy-ul][divider line_type="No Line" custom_height="20"][vc_column_text css=".vc_custom_1452016235987{margin-bottom: 18px !important;}"]
<h5>Featured On</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">ThemeNectar Show</span></li>
	<li><span style="color: #999999;">Mr. Nectar's Blog</span></li>
	<li><span style="color: #999999;">Top WP Themes</span></li>
	<li><span style="color: #999999;">ThemeForest</span></li>
	<li><span style="color: #999999;">Salient</span></li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/tab][tab title="Statistics" tab_id="1446568150305-7" id="1451522261332-5"][vc_row_inner][vc_column_inner column_padding="padding-2-percent" column_padding_position="right" background_color_opacity="1" width="1/2"][bar color="Accent-Color" percent="75" title="Marketing"][bar color="Accent-Color" percent="90" title="UI/UX Design"][bar color="Accent-Color" percent="80" title="Strategy"][bar color="Accent-Color" percent="65" title="3d Modeling"][bar color="Accent-Color" percent="95" title="Video Production"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2"][vc_column_text]
<h2>It's time you regained
control over your website</h2>
[/vc_column_text][vc_column_text]Vivamus eu neque ut sem malesuada consectetur sed sed felis. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae. ullam et eros ornare, porttitor urna sed.

<span style="color: #a3a3a3;">Praesent eget ullamcorper enim. Curabitur scelerisque mi dolor, eget egestas sem interdum eget. Etiam eros tortor, malesuada sed velit.</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Video Player Lightbox', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-player-lightbox.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="" bg_position="center bottom" bg_repeat="no-repeat" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="5%" bottom_padding="5%" id="discover" row_name="Discover" disable_ken_burns="yes" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text]
<h2>Your Productivity
Boosted With Salient</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text css=".vc_custom_1469377177047{margin-top: 20px !important;}"]Salient app will change the way we stay connected and interact. Meet Kara, a young aspiring writer who's been using Salient to improve her skills every day.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_animation="true" animation="grow-in" column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/600/400/?blur" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Recent Posts Grid Minimal ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent_post_grid.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" bg_position="left top" bg_repeat="no-repeat" parallax_bg_speed="slow" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="13%" bottom_padding="13%"][vc_column width="1/3" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" enable_animation="true"][recent_posts style="title_only" category="all" columns="1" posts_per_page="1"][/vc_column][vc_column width="2/3" enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1"][recent_posts category="all" columns="2" posts_per_page="4" style="minimal" post_offset="1"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Video Lightboxes', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-lightboxes.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f2f2f2" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" id="footage" row_name="Action Footage" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/1" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" centered_text="true" width="1/1"][vc_column_text css=".vc_custom_1468952632915{margin-top: 50px !important;margin-bottom: 15px !important;}"]
<h2>Enter Into A World Of Fun</h2>
<h4><span style="color: #999999;">First Person Clips Of Mountain Rides With The X1</span></h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/600/400/?blur" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][vc_column_text css=".vc_custom_1469672460721{padding-top: 20px !important;}"]
<h3>Aerial Footage <span style="color: #bbb;">5:29</span></h3>
Watch some drone footage of our team's best riders going downhill on Salient mountain.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" delay="150"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/650/433/?blur" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][vc_column_text css=".vc_custom_1469672453177{margin-top: 5px !important;padding-top: 20px !important;}"]
<h3>The Quick Route <span style="color: #bbb;">3:20</span></h3>
There's staying on the trail and then there's taking the "alternative" route.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" width="1/3" delay="300"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Default-Accent-Color" image_url="https://unsplash.it/625/417/?blur" box_shadow="x_large_depth" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][vc_column_text css=".vc_custom_1469672468298{padding-top: 20px !important;}"]
<h3>Kevin Robertson <span style="color: #bbb;">6:45</span></h3>
Check out Kevin treck some of the most intense courses in all of the Salient area.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Product Specifications Dark', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/specifications.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#282828" scene_position="center" text_color="light" text_align="left" top_padding="4%" bottom_padding="4%" id="specs" row_name="Specifications" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][nectar_animated_title heading_tag="h6" style="color-strip-reveal" color="Accent-Color" text="Specifications "][/vc_column_inner][/vc_row_inner][vc_row_inner bottom_padding="40" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3"][vc_column_text]
<h4>Base Frameset</h4>
<h5>Salient Package</h5>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-10-percent" column_padding_position="left-right" background_color_opacity="1" width="2/3" delay="100"][vc_column_text]<span style="color: #c5c5c5;">Salient main frame, G4 Link Tube, 220mm Travel, EVOX Link, Micro Truss, Enhanced Armor</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner bottom_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" delay="200"][vc_column_text]
<h4>Wheels &amp; Tires</h4>
<h5>Infinity R5</h5>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-10-percent" column_padding_position="left-right" background_color_opacity="1" width="2/3" delay="300"][vc_column_text]<span style="color: #c5c5c5;">20mm front, 150x10 rear, Ultra durable J3 Group Issue Tires 26.5"x2.4"</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][vc_row_inner text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" offset="vc_hidden-sm vc_hidden-xs"][divider line_type="No Line" custom_height="50"][/vc_column_inner][/vc_row_inner][vc_row_inner bottom_padding="40" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" delay="400"][vc_column_text]
<h4>Drivetrain</h4>
<h5>Nectar Triggers 26X</h5>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-10-percent" column_padding_position="left-right" background_color_opacity="1" width="2/3" delay="500"][vc_column_text]<span style="color: #c5c5c5;">HyperX Crank 48, Salient K7M Chain, Ultra6 Bottom Bracket, 10 Speed up/down Gearbox</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner bottom_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/3" delay="600"][vc_column_text]
<h4>Components</h4>
<h5>Nectar Set</h5>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-10-percent" column_padding_position="left-right" background_color_opacity="1" width="2/3" delay="700"][vc_column_text]<span style="color: #c5c5c5;">Elite Ultra Comfort Seat, Salient xGrip Handlebars 32mm, Orbit Bearing</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Hotspot Tooltips', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hotspots.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" id="features" row_name="Features" overlay_strength="0.3"][vc_column column_padding="padding-11-percent" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1468952242655{margin-top: 50px !important;margin-bottom: 15px !important;}"]
<h2>Prepare For The Adrenaline</h2>
<h4><span style="color: #999999;">The Best Materials. Handcrafted. Zero Compromises.</span></h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_image_with_hotspots image="https://source.unsplash.com/P3pI6xzovu0" preview="https://source.unsplash.com/P3pI6xzovu0" color_1="Extra-Color-1" hotspot_icon="plus_sign" tooltip="hover" tooltip_shadow="large_depth" animation="true"][nectar_hotspot left="15.4752%" top="36.8464%" position="bottom"]
<h5 style="color: #227bf7;">Cool Design</h5>
Lorem ipsum dolor sit sodales, augue velit cursus nunc.[/nectar_hotspot][nectar_hotspot left="64.4137%" top="56.923%" position="bottom"]
<h5 style="color: #227bf7;">Amazing Style</h5>
Lorem ipsum dolor sit sodales, augue velit cursus nunc.[/nectar_hotspot][nectar_hotspot left="84.5971%" top="35.4192%" position="bottom"]
<h5 style="color: #227bf7;">Sharp Edges</h5>
Lorem ipsum dolor sit sodales, augue velit cursus nunc.[/nectar_hotspot][nectar_hotspot left="38.6493%" top="24.5514%" position="bottom"]
<h5 style="color: #227bf7;">Ultra Durable</h5>
Lorem ipsum dolor sit sodales, augue velit cursus nunc.[/nectar_hotspot][/nectar_image_with_hotspots][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Toggles - FAQ Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal-toggles.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#f7f7f7" scene_position="center" text_color="dark" text_align="left" top_padding="100" bottom_padding="100" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h2>About Salient App</h2>
[/vc_column_text][toggles style="minimal"][toggle color="Default" title="What exactly is Salient App? "][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="How do I create my own Salient App account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Do I need to link my bank account in order to use it?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Will Salient Service work on my mobile device?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Is it available in my country?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][/toggles][vc_column_text css=".vc_custom_1469747464544{margin-top: 80px !important;}"]
<h2>Managing Your Account</h2>
[/vc_column_text][toggles style="minimal"][toggle color="Default" title="How do I manage my account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="How secure is the admin area?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="How do I cancel my account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Can I send more than one at a time?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][/toggles][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Cascading Images With Animated Icons', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/app-features.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="133" bg_position="right top" bg_repeat="no-repeat" bg_color="#fd1742" scene_position="center" text_color="light" text_align="left" top_padding="2%" bottom_padding="2%" id="features" row_name="Features" disable_ken_burns="yes" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="left-right" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="white" icon_padding="10px" icon_linea="icon-music-microphone-old" icon_size="64" animation_delay="200"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="35" text_align="right"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][vc_column_text css=".vc_custom_1469466155666{margin-bottom: 10px !important;}"]
<h5>Voice Calling</h5>
[/vc_column_text][vc_column_text max_width="225"]Simplify your social life by communicating via voice.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="right"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="left-right" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="700"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="white" icon_padding="10px" icon_linea="icon-software-layers2" animation_delay="700" icon_size="64"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="right"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="900"][vc_column_text css=".vc_custom_1469466205775{margin-bottom: 10px !important;}"]
<h5>Ultimate Interface</h5>
[/vc_column_text][vc_column_text max_width="225"]No matter how hard you look, you'll never find better.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_url="http://themenectar.com/demo/salient-app/wp-content/uploads/2017/01/app2.jpg" image_1_offset_x_sign="-" image_1_offset_x="10%" image_1_offset_y_sign="-" image_1_offset_y="5%" image_1_rotate_sign="+" image_1_rotate="none" image_1_animation="Grow In" image_1_box_shadow="none" image_2_url="http://themenectar.com/demo/salient-app/wp-content/uploads/2017/01/app.jpg" image_2_offset_x_sign="+" image_2_offset_x="10%" image_2_offset_y_sign="+" image_2_offset_y="5%" image_2_rotate_sign="+" image_2_rotate="none" image_2_animation="Grow In" image_2_box_shadow="x_large_depth" image_3_offset_x_sign="+" image_3_offset_x="0%" image_3_offset_y_sign="+" image_3_offset_y="0%" image_3_rotate_sign="+" image_3_rotate="none" image_3_animation="Fade In" image_3_box_shadow="none" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_animation="Fade In" image_4_box_shadow="none"][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/4" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="left-right" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="white" icon_padding="10px" icon_linea="icon-basic-globe" animation_delay="200" icon_size="64"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="35" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="400"][vc_column_text css=".vc_custom_1469466163499{margin-bottom: 10px !important;}"]
<h5>Available Globally</h5>
[/vc_column_text][vc_column_text max_width="225"]Salient App is now out for download everywhere.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-3-percent" column_padding_position="left-right" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="700"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="fast" icon_style="default" icon_color="white" icon_padding="10px" icon_linea="icon-basic-picture-multiple" animation_delay="700" icon_size="64"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="900"][vc_column_text css=".vc_custom_1469303109495{margin-bottom: 10px !important;}"]
<h5>Media Storage</h5>
[/vc_column_text][vc_column_text max_width="225"]Get 10gb storage on our servers with a free account.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Clean Company Intro', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['about'] .', '. $cat_display_names['services'];
$data['custom_class'] = 'about services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/interesting-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" overlay_strength="0.3"][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/2" tablet_text_alignment="default" phone_text_alignment="default"][split_line_heading]
<h2 style="color: #1e83ec;"><span style="color: #1e83ec;">Design is the paradise</span></h2>
<h2 style="color: #1e83ec;"><span style="color: #1e83ec;">of individuality, eccentricity,</span></h2>
<h2 style="color: #1e83ec;"><span style="color: #1e83ec;">abnormality, and humors.</span></h2>
[/split_line_heading][vc_row_inner top_padding="15" bottom_padding="25" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][vc_column_text]We're Salient, a creative agency located in the heart of New York city. We pride ourselves on developing unique and professional solutions with a wide variety of mediums. Take a look around and don't be shy.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1"][vc_column_text]
<h6 style="color: #1e83ec;">What we can help you achieve</h6>
<span style="color: rgba(0,0,0,0.45);">Personal or corporate branding | SEO optimization | Web &amp; UI Design | Standing out in the crowd</span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/4" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text css=".vc_custom_1452014618584{margin-bottom: 18px !important;}"]
<h5>Target Audience</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">Medium Businesses</span></li>
	<li><span style="color: #999999;">Freelance Designers</span></li>
	<li><span style="color: #999999;">College Students</span></li>
	<li><span style="color: #999999;">Sorta Athletes</span></li>
	<li><span style="color: #999999;">Dairy Farmers</span></li>
</ul>
[/fancy-ul][divider line_type="No Line" custom_height="20"][vc_column_text css=".vc_custom_1452014599720{margin-bottom: 18px !important;}"]
<h5>Our Specialties</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">Program Management</span></li>
	<li><span style="color: #999999;">Graphic &amp; UI Design</span></li>
	<li><span style="color: #999999;">Customer Support</span></li>
	<li><span style="color: #999999;">Video Editing</span></li>
	<li><span style="color: #999999;">Sound Design</span></li>
</ul>
[/fancy-ul][/vc_column][vc_column column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" width="1/4" tablet_text_alignment="default" phone_text_alignment="default"][vc_column_text css=".vc_custom_1452014465975{margin-bottom: 18px !important;}"]
<h5>Notable Awards</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">Top Customer Support</span></li>
	<li><span style="color: #999999;">Most Liked Company</span></li>
	<li><span style="color: #999999;">Best In Class 2016</span></li>
	<li><span style="color: #999999;">Friendliest Group</span></li>
	<li><span style="color: #999999;">Innovative Brand</span></li>
</ul>
[/fancy-ul][divider line_type="No Line" custom_height="20"][vc_column_text css=".vc_custom_1452014481555{margin-bottom: 18px !important;}"]
<h5>Featured On</h5>
[/vc_column_text][fancy-ul icon_type="standard_dash" color="Extra-Color-3" enable_animation="true"]
<ul>
	<li><span style="color: #999999;">ThemeNectar Show</span></li>
	<li><span style="color: #999999;">Mr. Nectar's Blog</span></li>
	<li><span style="color: #999999;">Top WP Themes</span></li>
	<li><span style="color: #999999;">ThemeForest</span></li>
	<li><span style="color: #999999;">Salient</span></li>
</ul>
[/fancy-ul][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feelgood Image & Text Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/image-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.3"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][image_with_animation image_url="https://source.unsplash.com/kElEigko7PU/700x500" alignment="" animation="Grow In" box_shadow="large_depth" max_width="100%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text=" it's easy to feel the charm of existence in this spot." font_container="tag:h3|text_align:left|color:rgba(0%2C0%2C0%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="50"][vc_column_text css_animation="none" css=".vc_custom_1487084437567{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h5>Salient Powered</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, they live." font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css_animation="none" css=".vc_custom_1487084385405{margin-top: 20px !important;margin-bottom: 5px !important;}"]
<h5>Exceptional Quality</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, they live." font_container="tag:p|text_align:left|color:rgba(10%2C10%2C10%2C0.75)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Image Background Dual CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['cta'];
$data['custom_class'] = 'general cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cta-imgs.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3"][vc_column enable_animation="true" animation="grow-in" centered_text="true" column_padding="padding-8-percent" column_padding_position="all" background_color="#2d2d2d" background_color_opacity="0.4" background_hover_color_opacity="0.4" background_image="https://source.unsplash.com/daily/?smartphone" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="100"][vc_custom_heading text="Heavily Awarded" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][vc_custom_heading text="We do great work" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="See our portfolio" margin_top="25"][divider line_type="No Line" custom_height="100"][/vc_column][vc_column enable_animation="true" animation="grow-in" centered_text="true" column_padding="padding-8-percent" column_padding_position="all" background_color="#2d2d2d" background_color_opacity="0.5" background_hover_color_opacity="0.5" background_image="https://source.unsplash.com/daily/?modernoffice" enable_bg_scale="true" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" delay="150"][divider line_type="No Line" custom_height="100"][vc_custom_heading text="We care about skill" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][vc_custom_heading text="Great minds work here" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Meet The Team" margin_top="25"][divider line_type="No Line" custom_height="100"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fervent Intro Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-header.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/_q5H19c-VwU" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" video_bg="use_video" video_mute="true" text_color="light" text_align="left" top_padding="13%" bottom_padding="13%" color_overlay="#0a0a0a" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Our Story" font_container="tag:h5|text_align:left|color:rgba(255%2C255%2C255%2C0.74)" use_theme_fonts="yes" css_animation="fadeInUp"][split_line_heading]
<h2>Let's Change How We</h2>
<h2>Manage Business</h2>
[/split_line_heading][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="5/6" column_border_width="none" column_border_style="solid" delay="300"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics. " font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid" delay="500"][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Extra-Color-1" font_style="p" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="View Explainer Video"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Career Table', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'about general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/career-table.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.95"][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1486569314523{margin-top: -8px !important;margin-bottom: -8px !important;}"]
<h2>Career Opportunities</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="80" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid" delay="50"][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia." font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/4" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/1" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" font_family="h4" hover_color="accent-color" col_1_content="Content Director " col_2_content="On Location" cta_1_text="Apply Now"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" font_family="h4" hover_color="accent-color" col_1_content="Producer" col_2_content="On Location" cta_1_text="Apply Now"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" font_family="h4" hover_color="accent-color" col_1_content="We Developer" col_2_content="On Location" cta_1_text="Apply Now"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" font_family="h4" hover_color="accent-color" col_1_content="SEO Specialist " col_2_content="Remote" cta_1_text="Apply Now"][nectar_horizontal_list_item columns="3" column_layout_using_3_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" font_family="h4" hover_color="accent-color" col_1_content="Social Media Manager" col_2_content="Remote" cta_1_text="Apply Now"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Parallax Cascading Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] .', '. $cat_display_names['general'];
$data['custom_class'] = 'about general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cascading-img-modern.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/nvzvOPQW0gc" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="rgba(10,10,10,0.67)" overlay_strength="0.5"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#3452ff" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="0%" image_1_rotate_sign="+" image_1_rotate="none" image_1_animation="Grow In" image_1_box_shadow="none" image_2_url="https://source.unsplash.com/iCtJF-A5hvs/600x400" image_2_offset_x_sign="-" image_2_offset_x="25%" image_2_offset_y_sign="+" image_2_offset_y="30%" image_2_rotate_sign="+" image_2_rotate="none" image_2_animation="Grow In" image_2_box_shadow="none" image_3_url="https://source.unsplash.com/nvzvOPQW0gc/600x400" image_3_offset_x_sign="+" image_3_offset_x="15%" image_3_offset_y_sign="-" image_3_offset_y="30%" image_3_rotate_sign="+" image_3_rotate="none" image_3_animation="Grow In" image_3_box_shadow="x_large_depth" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_animation="Fade In" image_4_box_shadow="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Way back when" font_container="tag:h5|text_align:left|color:rgba(255%2C255%2C255%2C0.74)" use_theme_fonts="yes" css_animation="fadeInUp"][split_line_heading]
<h2>We decided to move</h2>
<h2>forward with building</h2>
[/split_line_heading][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1486564699536{padding-right: 10% !important;}"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Show Me How" margin_top="25" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Daring CTA Morphing Outline Buttons', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'] .', '. $cat_display_names['cta'];
$data['custom_class'] = 'services cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/morphing-outline.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" bg_position="left top" bg_repeat="no-repeat" parallax_bg_speed="slow" scene_position="center" text_color="light" text_align="left"][vc_column width="1/2" animation="none" column_padding="padding-10-percent" column_padding_position="all" background_color="#f7f7f7" background_color_opacity="1" column_link="#" background_hover_color_opacity="0.9" background_image="5364" background_color_hover="#f7f7f7"][morphing_outline starting_color="#fd0025" border_thickness="11" hover_color="#fd0025"]
<h5><i>Continue Exploring</i></h5>
<h2>View More</h2>
[/morphing_outline][/vc_column][vc_column width="1/2" animation="none" column_padding="padding-10-percent" column_padding_position="all" background_color="#fd0025" background_color_opacity="1" column_link="#" background_color_hover="#fd0025" background_hover_color_opacity="0.9" background_image="5275"][morphing_outline border_thickness="11" starting_color="#ffffff" hover_color="#ffffff"]
<h5><i>Already In Love</i></h5>
<h2>Purchase</h2>
[/morphing_outline][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

$data = array();
$data['name'] = esc_html__( 'Icons With Text & Column BG Hover', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/icon_with_text_1.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_image="https://source.unsplash.com/HrUwIKrmPm0" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#4e475c" scene_position="center" text_color="light" text_align="center" color_overlay="#4e475c" overlay_strength="0.95" shape_divider_position="bottom"][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_color_hover="#0a0a0a" background_hover_color_opacity="0.2" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="75"][nectar_icon icon_family="linea" icon_style="default" icon_color="Accent-Color" icon_padding="10px" icon_linea="icon-basic-heart" icon_size="60"][divider line_type="No Line" custom_height="15"][vc_column_text] Take full control of the power Salient has to offer with our new exciting page builder. You’ll be grinning in delight when you see just how easy it is to create stunning layouts with little effort.[/vc_column_text][divider line_type="No Line" custom_height="75"][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_color_hover="#0a0a0a" background_hover_color_opacity="0.2" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="75"][nectar_icon icon_family="linea" icon_style="default" icon_color="Accent-Color" icon_padding="10px" icon_linea="icon-basic-mouse" icon_size="60"][divider line_type="No Line" custom_height="15"][vc_column_text] Take full control of the power Salient has to offer with our new exciting page builder. You’ll be grinning in delight when you see just how easy it is to create stunning layouts with little effort.[/vc_column_text][divider line_type="No Line" custom_height="75"][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_color_hover="#0a0a0a" background_hover_color_opacity="0.2" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="75"][nectar_icon icon_family="linea" icon_style="default" icon_color="Accent-Color" icon_padding="10px" icon_linea="icon-arrows-rotate" icon_size="60"][divider line_type="No Line" custom_height="15"][vc_column_text] Take full control of the power Salient has to offer with our new exciting page builder. You’ll be grinning in delight when you see just how easy it is to create stunning layouts with little effort.[/vc_column_text][divider line_type="No Line" custom_height="75"][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_color_hover="#0a0a0a" background_hover_color_opacity="0.2" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="75"][nectar_icon icon_family="linea" icon_style="default" icon_color="Accent-Color" icon_padding="10px" icon_linea="icon-basic-video" icon_size="60"][divider line_type="No Line" custom_height="15"][vc_column_text] Take full control of the power Salient has to offer with our new exciting page builder. You’ll be grinning in delight when you see just how easy it is to create stunning layouts with little effort.[/vc_column_text][divider line_type="No Line" custom_height="75"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Soft Color Icons And Text Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/soft-color-icon-boxes.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="top" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="2/5" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" max_width="375"]
<h2>Take the risk or you will lose the chance.</h2>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1531849673065{margin-top: 30px !important;margin-bottom: 30px !important;}" max_width="400"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows by their place and supplies it with the necessary regelialia[/vc_column_text][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="3/5" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="30" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Extra-Color-2" icon_padding="15px" icon_iconsmind="iconsmind-Helicopter" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1531417490305{margin-bottom: 15px !important;}"]
<h4>Deploy</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417497722{padding-right: 13% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Extra-Color-3" icon_padding="15px" icon_iconsmind="iconsmind-Life-Jacket" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1531417485581{margin-bottom: 15px !important;}"]
<h4>Support</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417502263{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="15px" icon_iconsmind="iconsmind-Diamond" margin_top="20" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1531417507799{margin-bottom: 15px !important;}"]
<h4>Design</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417513482{padding-right: 13% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Extra-Color-1" icon_padding="15px" icon_iconsmind="iconsmind-Gear-2" margin_top="20" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1531417518183{margin-bottom: 15px !important;}"]
<h4>Develop</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417525057{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



if(version_compare(WPB_VC_VERSION,'5.5','>=')) {
	
$data = array();
$data['name'] = esc_html__( 'Easy Wide Broken Image Grid', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/broken-image-grid-3.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" top_padding="2%" bottom_padding="2%" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5"][image_with_animation image_url="https://source.unsplash.com/430x600/daily/?beach" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="100"][image_with_animation image_url="https://source.unsplash.com/420x520/daily/?fashion" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="200"][image_with_animation image_url="https://source.unsplash.com/800x600/daily/?view" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="300"][image_with_animation image_url="https://source.unsplash.com/800x450/daily/?business" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][image_with_animation image_url="https://source.unsplash.com/800x400/daily/?happy" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%" margin_top="5%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="400"][image_with_animation image_url="https://source.unsplash.com/450x650/daily/?nature" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5"][image_with_animation image_url="https://source.unsplash.com/450x600/daily/?nature" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="100"][image_with_animation image_url="https://source.unsplash.com/700x400/daily/?people" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][image_with_animation image_url="https://source.unsplash.com/700x300/daily/?people" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%" margin_top="5%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="200"][image_with_animation image_url="https://source.unsplash.com/800x650/daily/?shoes" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-1-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="300"][image_with_animation image_url="https://source.unsplash.com/600x600/daily/?smile" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1/5" delay="400"][image_with_animation image_url="https://source.unsplash.com/500x650/daily/?adventure" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );

}




$data = array();
$data['name'] = esc_html__( 'Clear Hero Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/landing-video-right.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/1600x850/daily" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" color_overlay="#3452ff" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" top_padding="15%" bottom_padding="14%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="5/12" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h1>We're Salient, A <em>Creative</em> Startup Based in Philly</h1>
[/nectar_highlighted_text][vc_column_text max_width="550"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec.[/vc_column_text][divider line_type="No Line"][nectar_btn size="large" button_style="regular" button_color_2="Extra-Color-1" icon_family="default_arrow" url="#" text="Learn More" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/12" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button_2" nectar_play_button_color="Extra-Color-1" image_url="https://source.unsplash.com/700x450/daily" hover_effect="zoom_button" box_shadow="x_large_depth" border_radius="10px" play_button_size="default" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="bottom-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][image_with_animation image_url="http://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Great Image Overflow Hero', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'hero_section icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/left-overflow-img-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/1300x800/daily/?mountains" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#151515" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="rgba(10,10,10,0.87)" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_highlighted_text highlight_color="#3452ff" style="half_text"]
<h1>This is <em>Salient</em></h1>
[/nectar_highlighted_text][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo elit tellus amet." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="40" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Helicopter" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110637877{margin-bottom: 15px !important;}"]
<h5>Design</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1532110649107{padding-right: 10% !important;}"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Diamond" margin_top="40" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110654226{margin-bottom: 15px !important;}"]
<h5>Deploy</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1532110661455{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Life-Jacket" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110643322{margin-bottom: 15px !important;}"]
<h5>Develop</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485638366488{padding-right: 10% !important;}"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Gear-2" margin_top="40" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110665831{margin-bottom: 15px !important;}"]
<h5>Support</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1532110673654{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/1200x900/daily/?flower" alignment="" animation="Fade In From Left" img_link_large="yes" border_radius="10px" box_shadow="x_large_depth" max_width="225%"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Great Image Overflow Hero #2', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['hero_section'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'hero_section icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/right-overflow-img-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/1500x800/daily/?nature" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#151515" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" color_overlay="rgba(10,10,10,0.87)" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/1200x900/daily/?nature" alignment="right" animation="Fade In From Left" img_link_large="yes" border_radius="10px" box_shadow="x_large_depth" max_width="225%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_highlighted_text highlight_color="#3452ff" style="half_text"]
<h1>This is <em>Salient</em></h1>
[/nectar_highlighted_text][vc_custom_heading text="I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo elit tellus amet." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="40" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Helicopter" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110637877{margin-bottom: 15px !important;}"]
<h5>Design</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1532110649107{padding-right: 10% !important;}"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Diamond" margin_top="40" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110654226{margin-bottom: 15px !important;}"]
<h5>Deploy</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1532110661455{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Life-Jacket" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110643322{margin-bottom: 15px !important;}"]
<h5>Develop</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1485638366488{padding-right: 10% !important;}"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="Accent-Color" icon_padding="0px" icon_iconsmind="iconsmind-Gear-2" margin_top="40" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532110665831{margin-bottom: 15px !important;}"]
<h5>Support</h5>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.6)" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1532110673654{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Four Columns With Soft Color Icons', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/4-col-soft-icon-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="top" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="30" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h2>Failure will never overtake me if my determination to succeed is strong enough.</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="40" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="15px" icon_iconsmind="iconsmind-Helicopter" icon_size="36" margin_top="20"][vc_column_text css_animation="none" css=".vc_custom_1532036834843{margin-bottom: 15px !important;padding-right: 20px !important;}"]
<h4>We Deploy Our Strategies Unbelievably Fast</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417497722{padding-right: 13% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="150"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="15px" icon_iconsmind="iconsmind-Life-Jacket" icon_size="36" margin_top="20"][vc_column_text css_animation="none" css=".vc_custom_1532036686189{margin-bottom: 15px !important;padding-right: 20px !important;}"]
<h4>Great Customer Support Is  What We're About</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417502263{padding-right: 10% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="300"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="15px" icon_iconsmind="iconsmind-Diamond" margin_top="20" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532036822769{margin-bottom: 15px !important;padding-right: 20px !important;}"]
<h4>We Make Killer Designs For Amazing Clients</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417513482{padding-right: 13% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="450"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="15px" icon_iconsmind="iconsmind-Gear-2" margin_top="20" icon_size="36"][vc_column_text css_animation="none" css=".vc_custom_1532036746257{margin-bottom: 15px !important;padding-right: 20px !important;}"]
<h4>Developing Business Models For 10 Years</h4>
[/vc_column_text][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus amet" font_container="tag:p|text_align:left" use_theme_fonts="yes" css_animation="none" css=".vc_custom_1531417525057{padding-right: 10% !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="underline" heading_tag="h5" text_color="#3452ff" link_type="regular" alignment="left" link_text="Check Out More"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Light Color Gradient Overlay Information Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'] .', '. $cat_display_names['hero_section']  .', '. $cat_display_names['about'];
$data['custom_class'] = 'testimonials hero_section about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-gradient.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/1500x800/daily/?city" bg_position="left center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" enable_gradient="true" color_overlay="#fff3ef" gradient_direction="left_to_right" overlay_strength="1" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][vc_column_text css=".vc_custom_1531925847334{margin-top: 40px !important;margin-bottom: 5px !important;}"]
<h5>Look Inside</h5>
[/vc_column_text][nectar_highlighted_text highlight_color="rgba(52,82,255,0.33)" style="half_text"]
<h2>Why We're The Most <em>Awesome</em> eCommerce Business</h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][divider line_type="Full Width Line" line_thickness="1" divider_color="default" custom_height="100"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="1" desktop_small_cols_flickity="1" tablet_cols_flickity="1" pagination_alignment_flickity="left" column_padding="5px" autorotate="true" border_radius="none" autorotation_speed="9000"][item id="1531926429-2-75" tab_id="1531926651954-9" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/150x150/daily/?man" style="bold" quote="I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][item id="1531926429-1-21" tab_id="1531926651819-3" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/150x150/daily/?smile" style="bold" quote="A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring. I am alone, and feel the charm of existence in this spot." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][item id="1531926429-3-51" tab_id="1531926652117-10" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/150x150/daily/?woman" style="bold" quote="When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, I throw myself down among the tall grass by the trickling stream." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][/carousel][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Cool Gradient Overlay Information Section Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'] .', '. $cat_display_names['hero_section']  .', '. $cat_display_names['about'];
$data['custom_class'] = 'testimonials hero_section about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/about-gradient-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/1500x1000/daily/?city" bg_position="left center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" enable_gradient="true" color_overlay="#263336" gradient_direction="left_to_right" overlay_strength="1" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="5/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][vc_column_text css=".vc_custom_1531925847334{margin-top: 40px !important;margin-bottom: 5px !important;}"]
<h5>Look Inside</h5>
[/vc_column_text][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h2>Why We're The Most <em>Awesome</em> eCommerce Business</h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][divider line_type="Full Width Line" line_thickness="1" divider_color="default" custom_height="100"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="1" desktop_small_cols_flickity="1" tablet_cols_flickity="1" pagination_alignment_flickity="left" column_padding="5px" autorotate="true" border_radius="none" autorotation_speed="9000"][item id="1531926651954-97774-9140" title="Item" tab_id="1532114245109-7"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/150x150/daily/?man" style="bold" quote="I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][item id="1531926651819-37774-9140" title="Item" tab_id="1532114245130-8"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/150x150/daily/?smile" style="bold" quote="A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring. I am alone, and feel the charm of existence in this spot." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][item id="1531926652117-107774-9140" title="Item" tab_id="1532114245167-0"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/150x150/daily/?woman" style="bold" quote="When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, I throw myself down among the tall grass by the trickling stream." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][/carousel][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="7/12" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Gradient Tabbed Section', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-tabs.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][tabbed_section style="material" alignment="center" spacing="side-45px" tab_color="extra-color-gradient-1" full_width_line="true" icon_size="32"][tab icon_family="iconsmind" title="Enforcement" id="1617863276-2-39" tab_id="1517863323662-4" icon_iconsmind="iconsmind-Police-Man"][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Upload-toCloud" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869613252{margin-bottom: 15px !important;}"]
<h5>Upload your ideas to Salient</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-D-Eyeglasses2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869633028{margin-bottom: 15px !important;}"]
<h5>Watch the magic happen</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Happy" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869652646{margin-bottom: 15px !important;}"]
<h5>Enjoy your increased revenue</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="iconsmind" title="Lightning" id="1517893276-1-15" tab_id="1517863323418-9" icon_iconsmind="iconsmind-Thunder"][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1487092529487{margin-bottom: 20px !important;}"]
<h3>A wonderful serenity has <em>taken possession</em> of my entire soul, like these sweet mornings of spring which I enjoy with my<em> whole heart</em>.</h3>
[/vc_column_text][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" font_style="p" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="<strong>Introduction Video </strong> — 30 seconds"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="iconsmind" title="Scorching Design" id="1517823751641-3-0" tab_id="1517863323642-9" icon_iconsmind="iconsmind-Fire-Flame"][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Upload-toCloud" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869613252{margin-bottom: 15px !important;}"]
<h5>Upload your ideas to Salient</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Tripod-andVideo" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1517863865199{margin-bottom: 15px !important;}"]
<h5>Watch video tutorials</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-D-Eyeglasses2" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869633028{margin-bottom: 15px !important;}"]
<h5>Watch the magic happen</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color="grey" icon_padding="0px" icon_iconsmind="iconsmind-Happy" url="#"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1485869652646{margin-bottom: 15px !important;}"]
<h5>Enjoy your increased revenue</h5>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and texts" font_container="tag:p|text_align:center|color:rgba(10%2C10%2C10%2C0.65)" use_theme_fonts="yes" css_animation="fadeInUp"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="iconsmind" title="Clothing" id="1517663483844-2-1" tab_id="1517863323687-5" icon_iconsmind="iconsmind-Blouse"][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1487092529487{margin-bottom: 20px !important;}"]
<h3>A wonderful serenity has <em>taken possession</em> of my entire soul, like these sweet mornings of spring which I enjoy with my<em> whole heart</em>.</h3>
[/vc_column_text][nectar_video_lightbox link_style="play_button_with_text" nectar_play_button_color="Default-Accent-Color" font_style="p" video_url="https://www.youtube.com/watch?v=6oTurM7gESE" link_text="<strong>Introduction Video </strong> — 30 seconds"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Fun Image Arrangement With Color Strip BG', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/broken-image-grid-1.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" enable_shape_divider="true" shape_divider_color="#3452ff" shape_divider_position="bottom" shape_divider_height="40%" shape_type="straight_section"][vc_column enable_animation="true" animation="fade-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="none" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][image_with_animation image_url="https://source.unsplash.com/700x500/daily/?girl" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][image_with_animation image_url="https://source.unsplash.com/700x500/daily/?face" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="none" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/12" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_col-xs-3"][image_with_animation image_url="https://source.unsplash.com/500x625/daily/?nature" alignment="" animation="None" border_radius="none" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][image_with_animation image_url="https://source.unsplash.com/500x650/daily/?city" alignment="" animation="None" border_radius="none" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][image_with_animation image_url="https://source.unsplash.com/700x500/daily/?adventure" alignment="" animation="None" border_radius="none" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Image Arrangement', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/broken-image-grid-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="0.3" shape_divider_position="bottom" shape_type="straight_section"][vc_column enable_animation="true" animation="fade-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="none" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][image_with_animation image_url="https://source.unsplash.com/700x500/daily/?girl" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][image_with_animation image_url="https://source.unsplash.com/700x500/daily/?face" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="none" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/12" column_border_width="none" column_border_style="solid" offset="vc_col-xs-1"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" offset="vc_col-xs-3"][image_with_animation image_url="https://source.unsplash.com/500x625/daily/?nature" alignment="" animation="None" border_radius="none" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][image_with_animation image_url="https://source.unsplash.com/500x650/daily/?city" alignment="" animation="None" border_radius="none" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-4"][image_with_animation image_url="https://source.unsplash.com/600x850/daily/?adventure" alignment="" animation="None" border_radius="none" box_shadow="x_large_depth" max_width="100%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Blog Category Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/blog-categories.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_category_grid post_type="posts" blog_category="all" text_content_alignment="bottom_left" subtext="cat_item_count" columns="4" grid_item_spacing="10px" enable_masonry="yes" color_overlay="#000000" color_overlay_opacity="0.2" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" shadow_on_hover="yes" subtext_visibility="on_hover" orderby="" order="" text_style="" color_strip_bg="" color_strip_bg_hover="" color_strip_text="" color_strip_text_hover="" block_sizing="square"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Single Word Text Highlight', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/highlight-text-half.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_highlighted_text style="half_text"]
<h2 style="text-align: center;"><em>#NECTARSHOP</em></h2>
[/nectar_highlighted_text][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Interesting Dark Instagram Link', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/insta-link.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#242828" scene_position="center" text_color="light" text_align="left" top_padding="5%" bottom_padding="5%" overlay_strength="0.3" shape_divider_position="bottom" shape_divider_height="50%" shape_type="straight_section"][vc_column enable_animation="true" animation="fade-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_highlighted_text highlight_color="#3452ff" style="half_text"]
<h1 style="text-align: center;"><em>@NECTARSHOP</em></h1>
[/nectar_highlighted_text][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="center" text="Follow Us On" link_text="Instagram" url="#"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Key Points With Soft Color Icons', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/key-points.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="7%" bottom_padding="7%" overlay_strength="1" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>If you wish to make an apple</h2>
<h2>pie from scratch, you must first</h2>
<h2>invent the universe.</h2>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="10px" icon_iconsmind="iconsmind-Plant" icon_size="40" margin_bottom="30"][vc_column_text css=".vc_custom_1531919831641{padding-right: 10% !important;}"]
<h4>Sustainable Materials</h4>
Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="10px" icon_iconsmind="iconsmind-Shirt" icon_size="40" margin_bottom="30"][vc_column_text css=".vc_custom_1531919836584{padding-right: 10% !important;}"]
<h4>Tailored Fit</h4>
Even the all-powerful Pointing has no control about the blind texts. One day a line of blind text by the name of Lorem Ipsum decided to leave.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="iconsmind" icon_style="soft-bg" icon_color="Accent-Color" icon_padding="10px" icon_iconsmind="iconsmind-Plane" icon_size="40" margin_bottom="30"][vc_column_text css=".vc_custom_1531919841519{padding-right: 10% !important;}"]
<h4>Fast Shipping</h4>
A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="underline" heading_tag="h5" text_color="#0a0000" link_type="regular" alignment="left" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Minimal Underlined Heading', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/light-underlined-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="5%" bottom_padding="5%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_highlighted_text highlight_color="rgba(52,82,255,0.43)" style="half_text"]
<h2 style="text-align: center;">Style is a way to say <em>who you are</em> without saying anything at all.</h2>
[/nectar_highlighted_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Heading With Underlined Link Dark', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['general'] .', '. $cat_display_names['cta'];
$data['custom_class'] = 'general cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/underlined-cta-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" bg_image="https://source.unsplash.com/1700x800/daily/?mountains" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#0c0c0c" overlay_strength="0.5" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-5-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h2 style="text-align: center;">Style is a way to say <a href="http://themenectar.com" target="_blank" rel="noopener"><em>who you are</em></a> without saying anything at all.</h2>
[/nectar_highlighted_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Image BG Simple CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/bg-img-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/1700x800/daily/?mountains" bg_position="center center" bg_repeat="no-repeat" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" top_padding="80" bottom_padding="80" color_overlay="#3452ff" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="5/12" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h2>Sign Up <em>Today</em> &amp; Start Sending Money.</h2>
[/nectar_highlighted_text][vc_column_text css=".vc_custom_1485272593024{margin-top: 15px !important;}"]Get 30 days free when you sign up now.[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/12" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="right"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="see-through-2" color_override="#ffffff" hover_color_override="#ffffff" hover_text_color_override="#000000" icon_family="default_arrow" url="#" text="Sign Up Now"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Even Columns With Buttons', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']  .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/text-content-and-buttons.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="top" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" bottom_padding="60" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="3/5" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h2>Imagination is everything. It is the preview of life's coming attractions.</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/5" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="40" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="fontawesome" icon_style="soft-bg" icon_color="black" icon_padding="10px" icon_size="24" margin_top="20" icon_fontawesome="fa fa-handshake-o"][vc_column_text css_animation="none" css=".vc_custom_1532176384930{margin-bottom: 15px !important;}"]
<h4>We Deploy Our Strategies Unbelievably Fast</h4>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="100"][nectar_icon icon_family="fontawesome" icon_style="soft-bg" icon_color="black" icon_padding="10px" icon_size="24" margin_top="20" icon_fontawesome="fa fa-motorcycle"][vc_column_text css_animation="none" css=".vc_custom_1532176380836{margin-bottom: 15px !important;}"]
<h4>Great Customer Support Is  What We're About</h4>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="200"][nectar_icon icon_family="fontawesome" icon_style="soft-bg" icon_color="black" icon_padding="10px" icon_size="24" margin_top="20" icon_fontawesome="fa fa-leaf"][vc_column_text css_animation="none" css=".vc_custom_1532176376162{margin-bottom: 15px !important;}"]
<h4>We Make Killer Designs For Amazing Clients</h4>
[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-1-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" column_border_width="none" column_border_style="solid" delay="300"][nectar_icon icon_family="fontawesome" icon_style="soft-bg" icon_color="black" icon_padding="10px" icon_size="24" margin_top="20" icon_fontawesome="fa fa-graduation-cap"][vc_column_text css_animation="none" css=".vc_custom_1532176389381{margin-bottom: 15px !important;}"]
<h4>Developing Business Models For 10 Year</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="regular" button_color_2="Accent-Color" icon_family="none" url="#" text="Discover" margin_right="10" margin_left="10"][nectar_btn size="jumbo" button_style="regular" button_color_2="Extra-Color-1" icon_family="none" url="#" text="Contact Us" margin_right="10" margin_left="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Creative Testimonials With Shape Divider', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/sweet-testimonials.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#e1e4f7" scene_position="center" text_color="dark" text_align="left" top_padding="9%" bottom_padding="12%" overlay_strength="1" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="40%" shape_type="curve_opacity"][vc_column column_padding="no-extra-padding" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1507069609150{margin-bottom: 5px !important;}"]
<h5>Check This Out</h5>
[/vc_column_text][vc_column_text]
<h2 class="center">Our Clients Absolutely Adore Us</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="3%" text_align="left"][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://source.unsplash.com/featured/200x200/daily/?dude" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Kara Lucas" subtitle="Interior Decorator"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" delay="100"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://source.unsplash.com/featured/200x200/daily/?girl" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Alley Cohen" subtitle="Designer"][/vc_column_inner][vc_column_inner enable_animation="true" animation="grow-in" column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" delay="200"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://source.unsplash.com/featured/200x200/daily/?guy" quote="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus tempus consectetur mi nec hendrerit. Integer id est massa." name="Jason Smith" subtitle="Developer"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][nectar_btn size="jumbo" button_style="regular" button_color_2="Extra-Color-1" icon_family="default_arrow" text="See All Testimonials" margin_top="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Light Gradient Call To Action', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/light-cta.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in" column_padding="padding-2-percent" column_padding_position="left-right" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][nectar_gradient_text heading_tag="h5" color="extra-color-gradient-2" gradient_direction="horizontal" text="Together We Build Dreams" margin_bottom="10"][vc_custom_heading text="Ready To See What's Next?" font_container="tag:h2|font_size:52|text_align:center|line_height:52px" use_theme_fonts="yes" css_animation="fadeInUp"][divider line_type="No Line" custom_height="10"][vc_custom_heading text="Like Nothing You've Seen. Sign Up Today &amp; Experience Salient" font_container="tag:p|text_align:center|color:rgba(0%2C0%2C0%2C0.7)" use_theme_fonts="yes" css_animation="fadeInUp" css=".vc_custom_1532179760585{margin-top: 10px !important;margin-bottom: 10px !important;}"][nectar_btn size="jumbo" button_style="regular" button_color_2="extra-color-gradient-2" icon_family="default_arrow" url="#" text="Sign Up Today" css_animation="zoomIn" margin_top="30"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Modern Vertical Tabbed Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/vertical-tabs-material.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][tabbed_section style="vertical_modern" tab_color="Accent-Color"][tab icon_family="iconsmind" title="Enforcement" id="1532183515355-2a409-746f" icon_iconsmind="iconsmind-Police-Man" tab_id="1532189429947-7"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Creator of quality designs and thinker of fresh ideas." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="iconsmind" title="Lightning" id="1532183515615-0a409-746f" icon_iconsmind="iconsmind-Thunder" tab_id="1532189430070-5"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Look deep into nature, and then you will understand everything better." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="iconsmind" title="Scorching Design" id="1542183515734-7a409-746f" icon_iconsmind="iconsmind-Fire-Flame" tab_id="1532189430246-6"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Try not to become a man of success, but rather try to become a man of value." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="iconsmind" title="Clothing" id="1532183516284-3a409-746f" icon_iconsmind="iconsmind-Bee" tab_id="1532189430412-6"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][vc_custom_heading text="The true sign of intelligence is not knowledge but imagination." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Leaflet Interactive Map', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['google_map'];
$data['custom_class'] = 'map';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/leaflet-map.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_gmap map_type="leaflet" zoom="6" marker_style="default" color="accent-color" leaflet_map_greyscale="1" infowindow_start_open="1" size="700" map_center_lat="39.949" map_center_lng="-75.171" map_markers="39.949|-75.171|Our Location"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Wonderful Product Collection Parallax', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section']  .', '. $cat_display_names['shop'];
$data['custom_class'] = 'hero_section shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/featured-collections.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/daily/?beach" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="18%" bottom_padding="18%" color_overlay="rgba(10,10,10,0.78)" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532368660277{margin-bottom: 5px !important;}"]
<h4>Summer Collection</h4>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1532366822753{margin-bottom: 15px !important;}"]
<h2>Bathing Suits</h2>
[/vc_column_text][vc_column_text css_animation="none" max_width="500" css=".vc_custom_1532366818395{margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Browse Collection" url="#"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/GNp7ng0lR-8" bg_position="right center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="dark" text_align="left" top_padding="18%" bottom_padding="18%" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532368666674{margin-bottom: 5px !important;}"]
<h4>Summer Collection</h4>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1532368205362{margin-bottom: 15px !important;}"]
<h2>Breathable Pants</h2>
[/vc_column_text][vc_column_text css_animation="none" max_width="500" css=".vc_custom_1532366818395{margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h5" text_color="#000000" link_type="regular" alignment="left" link_text="Browse Collection" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/8j9JKbDZz9g" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="18%" bottom_padding="18%" color_overlay="#0a0a0a" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532368672431{margin-bottom: 5px !important;}"]
<h4>Summer Collection</h4>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1532368218567{margin-bottom: 15px !important;}"]
<h2>Adventure Clothes</h2>
[/vc_column_text][vc_column_text css_animation="none" max_width="500" css=".vc_custom_1532366818395{margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="center" link_text="Browse Collection" url="#"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Shop Sale Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']  .', '. $cat_display_names['shop'];
$data['custom_class'] = 'general shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/shop-sale-col.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" top_padding="30" bottom_padding="30" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in" background_image="https://source.unsplash.com/featured/1000x600/daily/?sky" enable_bg_scale="true" column_padding="padding-7-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="5px" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h4>A summer exclusive deal</h4>
[/vc_column_text][vc_custom_heading text="50% off" font_container="tag:h1|font_size:100px|text_align:center|color:%23ffffff" use_theme_fonts="yes"][vc_column_text max_width="400" css=".vc_custom_1534967899684{margin-top: 15px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="center" link_text="Shop Now" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overflowing Title Gradient CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/cta-overlap-box.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" bg_image="https://source.unsplash.com/1700x800/daily/?mountains" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" bottom_padding="8%" enable_gradient="true" color_overlay="#3452ff" color_overlay_2="#ff1053" gradient_direction="left_t_to_right_b" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-lg-offset-0 vc_col-md-offset-0"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_col-xs-3"][/vc_column_inner][vc_column_inner column_padding="padding-6-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" top_margin="-45" column_link_target="_self" width="1/3" column_border_width="8px" column_border_color="#f4f4f4" column_border_style="solid" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-sm-offset-0 vc_col-xs-6"][divider line_type="No Line" custom_height="25"][vc_column_text css=".vc_custom_1532371457622{margin-bottom: 0px !important;padding-bottom: 0px !important;}"]
<h4>Reach Out</h4>
[/vc_column_text][divider line_type="No Line" custom_height="25"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="10%" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid" offset="vc_col-xs-2"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" column_border_width="none" column_border_style="solid" offset="vc_col-lg-offset-0 vc_col-md-offset-0 vc_col-xs-8"][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h2 style="text-align: center;">Ready to take the next move? Get in touch <em>today</em></h2>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Blog Post Carousel Split Color BG', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/blog-split-bg.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="light" text_align="left" top_padding="6%" bottom_padding="5%" overlay_strength="0.3" enable_shape_divider="true" shape_divider_color="#3452ff" shape_divider_position="bottom" shape_divider_height="50%" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="We Write Sometimes" font_container="tag:h5|text_align:center|color:%23000000" use_theme_fonts="yes" css=".vc_custom_1532373327184{margin-bottom: 10px !important;}"][vc_custom_heading text="Fresh From The Blog" font_container="tag:h2|text_align:center|color:%233452ff" use_theme_fonts="yes" css=".vc_custom_1532373516395{margin-bottom: 5% !important;}"][divider line_type="No Line" custom_height="20"][recent_posts style="slider_multiple_visible" category="all" columns="4" button_color="Accent-Color" hover_shadow_type="dark" order="DESC" orderby="date" posts_per_page="6"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Recent Posts Split Parallax BG', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/recent-posts-overlap.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/1700x800/daily/?space" bg_position="left top" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="10%" color_overlay="#3452ff" overlay_strength="0.8" shape_divider_position="bottom" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][split_line_heading]
<h2>The best Wordpress</h2>
<h2>articles, written daily.</h2>
[/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="7%" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532380343090{padding-right: 10% !important;}"]
<h4>Expert Authors</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.73)" use_theme_fonts="yes" css=".vc_custom_1532379238082{padding-right: 7% !important;}"][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1532380349040{padding-right: 10% !important;}"]
<h4>Useful Content</h4>
[/vc_column_text][vc_custom_heading text="Even the all-powerful Pointing has no control about the blind texts. One day a line of blind text by the name of Lorem Ipsum decided to leave." font_container="tag:p|text_align:left|color:rgba(255%2C255%2C255%2C0.73)" use_theme_fonts="yes" css=".vc_custom_1532379243556{padding-right: 7% !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" bottom_padding="8%" overlay_strength="0.8" shape_divider_position="bottom" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" top_margin="-12%" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][recent_posts style="list_featured_first_row" category="all" columns="3" order="DESC" orderby="date" posts_per_page="3" post_offset="1"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Image And Text Overlapping', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlap-img-alt.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="10%" bottom_padding="10%" id="discover" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/2QIVMNPWGaM" alignment="" animation="Grow In" border_radius="none" box_shadow="none" max_width="110%"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1504128844236{margin-right: -1px !important;}"][vc_column_inner enable_animation="true" animation="fade-in-from-left" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Quality is what matters most" font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1532382151945{margin-top: 30px !important;margin-bottom: 30px !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. A small river named Duden flows.[/vc_column_text][nectar_btn size="large" button_style="regular" button_color_2="extra-color-gradient-2" icon_family="default_arrow" url="https://themeforest.net/item/salient-responsive-multipurpose-theme/4363266" text="Learn More" css_animation="none" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Horizontal List Items', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']  .', '. $cat_display_names['icons']  .', '. $cat_display_names['services'];
$data['custom_class'] = 'general icons services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/hor-list-items-light.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="3%" id="steps" row_name="Sign Up Steps" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" bottom_padding="6%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Quality Over Quantity" font_container="tag:h5|text_align:left|color:rgba(0%2C0%2C0%2C0.78)" use_theme_fonts="yes" css=".vc_custom_1532457389216{margin-bottom: 10px !important;}"][nectar_highlighted_text style="half_text"]
<h2>Salient makes building websites <em>easier</em> than ever before.</h2>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][nectar_icon_list animate="true" color="default" direction="horizontal" columns="3" icon_size="small" icon_style="border"][nectar_icon_list_item icon_type="numerical" title="List Item" id="1532455438526-8b6e3-03cc" header="Sign Up For Free" text="Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor." tab_id="1532458311229-4"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1732455438531-10b6e3-03dc" header="Sell Goods Online" text="In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede." tab_id="1532458311239-1"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1532455438526-8b6e3-03fc" header="Write Beautiful Posts" text="Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. velit cursus nunc," tab_id="1532458311259-10"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1532455438526-2b6e3-03kc" header="Monitor Your Gains" text="orem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor." tab_id="1532458311282-3"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1532455438526-8b6e3-033c" header="Enjoy Your New Site" text="Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum." tab_id="1532458311305-5"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="numerical" title="List Item" id="1532455538526-1b6e3-031c" header="Love Your Life" text="Sit back, relax and pop a cold one because your life just got a whole lot easier by using Salient." tab_id="1532458311326-0"] [/nectar_icon_list_item][/nectar_icon_list][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Pink Color Overlay With Video & Testimonials', 'js_composer' );
$data['cat_display_name'] =  $cat_display_names['testimonials'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'testimonials about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-bg-testimonials-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" video_bg="use_video" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" color_overlay="#ffe8f8" overlay_strength="0.95" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1531925847334{margin-top: 40px !important;margin-bottom: 5px !important;}"]
<h5>Look Inside</h5>
[/vc_column_text][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h2>Why We're The Most <em>Awesome</em> eCommerce Business</h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="1" desktop_small_cols_flickity="1" tablet_cols_flickity="1" pagination_alignment_flickity="left" column_padding="5px" autorotate="true" border_radius="none" autorotation_speed="9000"][item id="1531926429-2-75" tab_id="1531926651954-9" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?smile" style="bold" quote="I am so happy, my dear friend, so absorbed in the exquisite sense of mere tranquil existence, that I neglect my talents. I should be incapable of drawing a single stroke at the present moment; and yet I feel that I never was a greater artist than now." name="Mr. ThemeNectar" subtitle="Pro Acrobat"][/item][item id="1531926429-1-21" tab_id="1531926651819-3" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?dude" style="bold" quote="A wonderful serenity has taken possession of my entire soul, like these sweet mornings of spring. I am alone, and feel the charm of existence in this spot." name="Adam Martin" subtitle="Pro Acrobat"][/item][item id="1531926429-3-51" tab_id="1531926652117-10" title="Item"][nectar_single_testimonial testimonial_style="basic" image="https://source.unsplash.com/featured/200x200/daily/?girl" style="bold" quote="When, while the lovely valley teems with vapour around me, and the meridian sun strikes the upper surface of the impenetrable foliage of my trees, I throw myself down among the tall grass by the trickling stream." name="Kara James" subtitle="Pro Acrobat"][/item][/carousel][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/4" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_video_lightbox link_style="play_button" video_url="https://www.youtube.com/watch?v=6oTurM7gESE"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Distinct Company Image And Bottom Contact Box', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/contact-row.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/1800x700/daily/?working" bg_position="center bottom" bg_repeat="no-repeat" bg_color="#333333" scene_position="center" text_color="light" text_align="left" top_padding="15%" bottom_padding="5%" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="300"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_position="all" background_color="#ff1053" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="large_depth" column_border_radius="10px" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" offset="vc_col-lg-3 vc_col-md-4 vc_col-xs-8"][vc_column_text]
<h4>The Salient</h4>
<p>58 Nectar Rd. Apt 2C
Malibu, California</p>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="new_tab" alignment="left" link_text="Get Directions" url="https://www.google.com/maps"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="3/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Other Office Locations Row', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/other-locations.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="8%" overlay_strength="0.5" shape_divider_position="bottom"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1533663492429{margin-bottom: 0px !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h2>Other Offices</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="20" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h5>San Francisco</h5>
123 Nectar St. Suite 4
hello@themenectar.com[/vc_column_text][nectar_cta btn_style="material" heading_tag="h5" text_color="#ff1053" link_type="regular" alignment="left" link_text="View Map" url="#"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h5>Manhatten</h5>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/vc_column_text][nectar_cta btn_style="material" heading_tag="h5" text_color="#ff1053" link_type="regular" alignment="left" link_text="View Map" url="#"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h5>Seattle</h5>
123 Nectar St. Suite 17
hello@themenectar.com[/vc_column_text][nectar_cta btn_style="material" heading_tag="h5" text_color="#ff1053" link_type="regular" alignment="left" link_text="View Map" url="#"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none"]
<h5>Philadelphia</h5>
58 Nectar Rd. Apt 2C
hello@themenectar.com[/vc_column_text][nectar_cta btn_style="material" heading_tag="h5" text_color="#ff1053" link_type="regular" alignment="left" link_text="View Map" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Paragraphs With Large Headings', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['about'];
$data['custom_class'] = 'general about';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-about-text.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="8%" bottom_padding="7%" id="about-text" overlay_strength="1" shape_divider_position="bottom" shape_type=""][vc_column enable_animation="true" animation="fade-in-from-bottom" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1533312705391{padding-bottom: 1.5% !important;}"]
<h2>Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.</h2>
[/vc_column_text][vc_column_text]
<h2>A small river named Duden flows by their place and supplies it with the necessary regelialia. Pityful a rethoric question ran over her.</h2>
[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1485638236800{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean. A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth.[/vc_column_text][/vc_column_inner][vc_column_inner enable_animation="true" animation="fade-in-from-bottom" column_padding="padding-3-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text css=".vc_custom_1485638241294{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar. The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Product Features With Colorful Background', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colorful-features.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="3%" id="steps" row_name="Sign Up Steps" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][nectar_icon_list color="default" direction="horizontal" columns="4" icon_size="small" icon_style="border"][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991183-5f44c-aa90" header="Eco Friendly" text="Lorem ipsum dolor sit amet, consectetuer adipiscing elit." icon_fontawesome="fa fa-leaf" tab_id="1533665101767-1"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991269-10f44c-bb90" header="Trendy Look" text="Cum sociis natoque penatibus et magnis dis parturient montes." icon_fontawesome="fa fa-arrow-circle-o-up" tab_id="1533665101811-7"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991269-10f44c-cc90" header="Keeps Body Cool" text="Cum sociis natoque penatibus et magnis dis parturient montes." icon_fontawesome="fa fa-thermometer-three-quarters" tab_id="1533665101854-7"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991311-8f44c-dd90" header="Attention To Detail" text="Lorem ipsum dolor sit amet, consectetuer adipiscing elit." icon_fontawesome="fa fa-eye" tab_id="1533665101900-8"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991311-8f44c-ee90" header="Stain Resistant" text="Lorem ipsum dolor sit amet, consectetuer adipiscing elit." icon_fontawesome="fa fa-paw" tab_id="1533665101959-2"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991352-8f44c-gg90" header="Many Colors" text="Sed fringilla mauris sit amet nibh. Donec sodales sagitti." icon_fontawesome="fa fa-tint" tab_id="1533665102013-3"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991406-0f44c-hh90" header="Designer Materials" text="Lorem ipsum dolor sit amet, consectetuer adipiscing elit." icon_fontawesome="fa fa-paint-brush" tab_id="1533665102056-5"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" title="List Item" id="1533573991225-4f44c-jj90" header="Free Shipping" text="In enim justo, rhoncus ut, imperdiet a, venenatis vitae." icon_fontawesome="fa fa-truck" tab_id="1533665102129-3"] [/nectar_icon_list_item][/nectar_icon_list][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Split Contact FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/split-contact.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#f7f7f7" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-8-percent" column_padding_position="all" background_color="#0a0a0a" background_color_opacity="0.8" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/1000x1000/daily/?epic" font_color="#ffffff" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Got a question?
No problem." font_container="tag:h2|text_align:left|color:%23ffffff" use_theme_fonts="yes"][vc_column_text css=".vc_custom_1534891977895{margin-top: 20px !important;margin-bottom: 60px !important;}" max_width="475"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live at enim porttitor facilisis.[/vc_column_text][nectar_cta btn_style="see-through" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Customer Service" url="#"][nectar_cta btn_style="see-through" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="General Inquiry" url="#"][nectar_cta btn_style="see-through" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Business" url="#"][/vc_column][vc_column column_padding="padding-8-percent" column_padding_position="all" background_color="#b8ecce" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text]
<h3>About Salient Store</h3>
[/vc_column_text][toggles style="minimal_small"][toggle color="Default" title="How do I place an order on Salient shop?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis.[/vc_column_text][/toggle][toggle color="Default" title="How do I create my own Salient account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="Do I need to link my bank account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="How do I track my order?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][/toggles][vc_column_text css=".vc_custom_1534890457743{margin-top: 80px !important;}"]
<h3>Managing Your Account</h3>
[/vc_column_text][toggles style="minimal_small"][toggle color="Default" title="How do I manage my account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices.[/vc_column_text][/toggle][toggle color="Default" title="How secure is the admin area?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][toggle color="Default" title="How do I cancel my account?"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. In eget bibendum libero. Etiam id velit at enim porttitor facilisis. Vivamus tincidunt lectus at risus pharetra ultrices. In tincidunt turpis at odio dapibus maximus.[/vc_column_text][/toggle][/toggles][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Three Fancy Boxes with Borders', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/3-col-fancy-box.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1534961409224{margin-bottom: 50px !important;}"]
<h3 style="text-align: center;">Salient has you covered</h3>
<p style="text-align: center;"><em> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus.</em></p>
[/vc_column_text][vc_row_inner column_margin="default" text_align="left" css=".vc_custom_1504187365562{margin-bottom: 2% !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="fontawesome" color="Accent-Color" box_alignment="center" enable_border="true" min_height="120" icon_fontawesome="fa fa-truck" icon_size="20" link_url="#"]
<h5>Fast Turnaround</h5>
<em>Lorem ipsum dolor sit amet.</em>[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="fontawesome" color="Accent-Color" box_alignment="center" enable_border="true" min_height="120" icon_fontawesome="fa fa-user-circle-o" icon_size="20" link_url="#"]
<h5>Elegant Design</h5>
<em>Lorem ipsum dolor sit amet.</em>[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][fancy_box box_style="color_box_hover" icon_family="fontawesome" color="Accent-Color" box_alignment="center" enable_border="true" min_height="120" icon_fontawesome="fa fa-trophy" icon_size="20" link_url="#"]
<h5>Award Winning</h5>
<em>Lorem ipsum dolor sit amet.</em>[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Recent Posts With BG Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/blog-recent-dark.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/featured/1700x800/daily/?epic" bg_position="left top" bg_repeat="no-repeat" bg_color="#eaeaea" scene_position="center" text_color="light" text_align="left" top_padding="7%" bottom_padding="7%" color_overlay="#000000" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_column_text max_width="600" css=".vc_custom_1535063574481{margin-bottom: 50px !important;}"]
<h2 style="text-align: center;">Latest Articles</h2>
<p style="text-align: center;">Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts separated.</p>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][recent_posts style="list_featured_first_row" category="business,company,fashion" columns="4" order="DESC" orderby="date" posts_per_page="4"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][nectar_btn size="large" button_style="regular" button_color_2="Accent-Color" icon_family="iconsmind" url="#" text="View All Posts" icon_iconsmind="iconsmind-Triangle-ArrowRight"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Icon List Horizontal With BG', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] .', '. $cat_display_names['icons'];
$data['custom_class'] = 'general icons';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/icon-list-horizontal-bg.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_image="https://source.unsplash.com/featured/1700x800/daily/?mountains" bg_position="center center" bg_repeat="no-repeat" parallax_bg="true" parallax_bg_speed="fast" scene_position="center" text_color="light" text_align="left" top_padding="8%" bottom_padding="3%" id="steps" row_name="Sign Up Steps" color_overlay="#0a0a0a" overlay_strength="0.8" shape_divider_position="bottom" shape_type=""][vc_column column_padding="padding-2-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" bottom_padding="6%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Quality Over Quantity" font_container="tag:h5|text_align:left|color:rgba(255%2C255%2C255%2C0.78)" use_theme_fonts="yes" css=".vc_custom_1535064392273{margin-bottom: 10px !important;}"][nectar_highlighted_text highlight_color="#ff1053" style="half_text"]
<h2>Salient makes building websites <em>easier</em> than ever before.</h2>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][nectar_icon_list color="default" direction="horizontal" columns="default" icon_size="medium" icon_style="no-border"][nectar_icon_list_item icon_type="icon" icon_family="iconsmind" title="List Item" id="1532458311229-41f11-29d0" header="Sign Up For Free" text="Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor." tab_id="1535064315669-7" icon_iconsmind="iconsmind-Money-Bag"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" icon_family="iconsmind" title="List Item" id="1532458311239-11f11-29d0" header="Sell Goods Online" text="In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede." tab_id="1535064315677-9" icon_iconsmind="iconsmind-Shopping-Cart"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" icon_family="iconsmind" title="List Item" id="1532458311259-101f11-29d0" header="Write Beautiful Posts" text="Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. velit cursus nunc," tab_id="1535064315702-10" icon_iconsmind="iconsmind-Text-Box"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" icon_family="iconsmind" title="List Item" id="1532458311282-31f11-29d0" header="Monitor Your Gains" text="orem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor." tab_id="1535064315745-7" icon_iconsmind="iconsmind-Bar-Chart"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" icon_family="iconsmind" title="List Item" id="1532458311305-51f11-29d0" header="Enjoy Your New Site" text="Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum." tab_id="1535064315768-6" icon_iconsmind="iconsmind-Newsvine"] [/nectar_icon_list_item][nectar_icon_list_item icon_type="icon" icon_family="iconsmind" title="List Item" id="1532458311326-01f11-29d0" header="Love Your Life" text="Sit back, relax and pop a cold one because your life just got a whole lot easier by using Salient." tab_id="1535064315794-9" icon_iconsmind="iconsmind-Sun"] [/nectar_icon_list_item][/nectar_icon_list][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Colorful BG Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colorful-bg-hero.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_image="https://source.unsplash.com/XgeZu2jBaVI" bg_position="center center" bg_repeat="no-repeat" bg_color="#3452ff" scene_position="center" text_color="light" text_align="left" top_padding="16%" bottom_padding="16%" color_overlay="#0c0c0c" overlay_strength="0.3" shape_divider_position="bottom" shape_divider_height="350" bg_image_animation="none" shape_type="mountains"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="zoom-out"][vc_custom_heading text="Salient Front End Editing Is Here" font_container="tag:h4|font_size:20|text_align:center|color:rgba(255%2C255%2C255%2C0.7)|line_height:36px" google_fonts="font_family:Roboto%3A100%2C100italic%2C300%2C300italic%2Cregular%2Citalic%2C500%2C500italic%2C700%2C700italic%2C900%2C900italic|font_style:500%20bold%20regular%3A500%3Anormal" css=".vc_custom_1544016696269{padding-right: 20% !important;padding-left: 20% !important;}"][vc_custom_heading text="WordPress Design As It Should Be" font_container="tag:h1|font_size:93px|text_align:center|line_height:98px" google_fonts="font_family:Playfair%20Display%3Aregular%2Citalic%2C700%2C700italic%2C900%2C900italic|font_style:400%20regular%3A400%3Anormal" css=".vc_custom_1544056620410{padding-right: 6% !important;padding-bottom: 30px !important;padding-left: 6% !important;}"][nectar_btn size="jumbo" button_style="regular" button_color_2="Accent-Color" color_override="#000000" icon_family="default_arrow" url="#discover" text="Explore More Now" margin_top="40" margin_right="20" margin_left="20"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/6" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Huge Triple Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/triple-fullscreen-cols.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" full_height="yes" columns_placement="stretch" scene_position="center" text_color="light" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column centered_text="true" column_padding="padding-8-percent" column_padding_position="all" background_color="#2d2d2d" background_color_opacity="0.6" background_hover_color_opacity="0.6" background_image="https://source.unsplash.com/daily/?smartphone" enable_bg_scale="true" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="grow-in"][vc_custom_heading text="Heavily Awarded" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][vc_custom_heading text="We only do excellent work" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="See our portfolio" margin_top="25"][/vc_column][vc_column centered_text="true" column_padding="padding-8-percent" column_padding_position="all" background_color="#0a0a0a" background_color_opacity="0.3" background_color_hover="#0a0a0a" background_hover_color_opacity="0.3" background_image="https://source.unsplash.com/daily/?underwater" enable_bg_scale="true" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="grow-in" delay="50"][vc_custom_heading text="Here For You" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][vc_custom_heading text="Useful Innovation" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Explore Now" margin_top="25"][/vc_column][vc_column centered_text="true" column_padding="padding-8-percent" column_padding_position="all" background_color="#2d2d2d" background_color_opacity="0.7" background_hover_color_opacity="0.7" background_image="https://source.unsplash.com/daily/?city" enable_bg_scale="true" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="grow-in" delay="100"][vc_custom_heading text="We care about skill" font_container="tag:h5|text_align:center|color:rgba(255%2C255%2C255%2C0.7)" use_theme_fonts="yes"][vc_custom_heading text="Great minds work here" font_container="tag:h3|text_align:center" use_theme_fonts="yes"][nectar_btn size="large" button_style="see-through-2" hover_text_color_override="#ffffff" icon_family="none" url="#" text="Meet The Team" margin_top="25"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Dark Fancy Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/dark-fancy-grid.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#0a0a0a" scene_position="center" text_color="light" text_align="left" top_padding="10%" bottom_padding="10%" id="more-features" overlay_strength="0.3" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="fadeInUp"]
<h5>Beautiful design &amp; robust options</h5>
[/vc_column_text][split_line_heading]
<h3>Salient is loaded with powerful features</h3>
<h3>that makes building a website easy</h3>
[/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" column_margin="default" top_padding="50" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/800x600/daily/?office" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Crown-2" min_height="300"]
<h4>Custom WPBakery Page Builder</h4>
Exclusive UI, elements &amp; studio template library[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?nature" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Duplicate-Layer" min_height="300"]
<h4>Huge Element Collection</h4>
With award winning attention to detail[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="200"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?happy" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Monitor-phone" min_height="300"]
<h4>Responsive and Retina Ready</h4>
Built with mobile in mind[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="300"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?city" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Refresh" min_height="300"]
<h4>Animated Page Transitions</h4>
Set your site even further apart from the crowd[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/800x600/daily/?happy" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Photos" min_height="300"]
<h4>Adaptive Images</h4>
load in the fastest manner with the least bandwidth[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?animal" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Flash" min_height="300"]
<h4>Blazing Performance</h4>
97% PageSpeed score &amp; 89% YSlow Score[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="200"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?smile" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Newsvine" min_height="300"]
<h4>Updated Frequently</h4>
One purchase grants you lifetime updates[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="300"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?office" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Sidebar-Window" min_height="300"]
<h4>Tons of Header Layouts</h4>
Don't get limited by your theme again[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?food" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Optimization" min_height="300"]
<h4>Loaded With Theme Options</h4>
User friendly &amp; loaded with power[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?friends" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Font-Window" min_height="300"]
<h4>800+ Google Fonts</h4>
Easily show off your brand how you want to[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="200"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?epic" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-King-2" min_height="300"]
<h4>Thousands of Beautiful Icons</h4>
3,500+ icons ($59 value) are included[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="300"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://source.unsplash.com/600x600/daily/?business" color="extra-color-gradient-1" box_alignment="left" enable_border="true" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Books" min_height="300"]
<h4>Extensive Documentation</h4>
Never feel lost again[/fancy_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );






/* WooCommerce specific templates */

$data = array();
$data['name'] = esc_html__( 'Tabbed Product Display', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tabbed-products.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][tabbed_section style="material" alignment="center" spacing="side-45px" tab_color="Accent-Color" full_width_line="true" icon_size="24"][tab icon_family="iconsmind" title="Latest" id="1532376475359-1c2bb-31f9" icon_iconsmind="iconsmind-Megaphone" tab_id="1533724809332-3"][nectar_woo_products product_type="all" category="all" columns="4" orderby="date" order="DESC" per_page="8"][/tab][tab icon_family="iconsmind" title="On Sale" id="1532376475534-2c2bb-3133" icon_iconsmind="iconsmind-Tag" tab_id="1533724809384-1"][nectar_woo_products product_type="sale" category="all" columns="4" orderby="date" order="DESC" per_page="8"][/tab][tab icon_family="iconsmind" title="Best Sellers" id="1532376475534-2c2bb-31f9" icon_iconsmind="iconsmind-Trophy" tab_id="1533724809506-9"][nectar_woo_products product_type="best_selling" category="all" columns="4" orderby="date" order="DESC" per_page="8"][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Modern Product Category Grid: Four Column Based', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/category-grid.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_category_grid post_type="products" product_category="all" text_content_alignment="bottom_left" subtext="custom" columns="4" grid_item_spacing="10px" enable_masonry="yes" color_overlay="#000000" color_overlay_opacity="0.2" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" shadow_on_hover="yes" subtext_visibility="always" orderby="" order="" text_style="" color_strip_bg="" color_strip_bg_hover="" color_strip_text="" color_strip_text_hover="" block_sizing="square" custom_subtext="Shop Now"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fullwidth Product Carousel With Split Color BG', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/woo-carousel.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" bg_color="#fff6f1" scene_position="center" text_color="dark" text_align="left" top_padding="3%" bottom_padding="5%" overlay_strength="0.3" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="50%" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_woo_products product_type="all" category="all" columns="dynamic" orderby="date" order="DESC" carousel="1" script="flickity" flickity_controls="arrows-and-text" flickity_heading_tag="h2" carousel_script="flickity" per_page="8" flickity_heading_text="Fresh New Products"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dual Section Products And Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/woo-2-products.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom"][vc_column column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text max_width="325" css=".vc_custom_1532191621300{margin-bottom: 60px !important;}"]
<h2>Stand Out
This Season.</h2>
<em>Stay ahead of the fashion trends with our new selection</em>[/vc_column_text][nectar_woo_products product_type="all" category="all" columns="2" orderby="date" order="DESC" per_page="2"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/collection/474017/daily" enable_bg_scale="true" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Flush Product Category Grid: Three Column Based', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/woo-cat-grid-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="6%" bottom_padding="6%" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_category_grid post_type="products" product_category="all" text_content_alignment="middle" subtext="custom" columns="3" grid_item_spacing="none" enable_masonry="yes" color_overlay="#000000" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.5" text_color="light" text_color_hover="light" subtext_visibility="on_hover" orderby="" order="" text_style="" color_strip_bg="" color_strip_bg_hover="" color_strip_text="" color_strip_text_hover="" block_sizing="square" custom_subtext="Shop Now"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Product Carousel Split', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/woo-2-products-carousel.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/4nulm-JUYFo" font_color="#ffffff" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Leave
A Timeless
Impression." font_container="tag:h2|font_size:60px|text_align:left|color:%23ffffff|line_height:68px" use_theme_fonts="yes"][divider line_type="No Line" custom_height="40"][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="left" link_text="Explore Full Collection" url="#"][/vc_column][vc_column column_padding="padding-4-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_woo_products product_type="all" category="all" columns="2" orderby="date" order="DESC" carousel="1" script="flickity" flickity_controls="bottom-pagination" autorotate="true" item_shadow="1" per_page="6" autorotation_speed="4000"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Normal Product Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/container-product-carousel.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" top_padding="4%" bottom_padding="5%" overlay_strength="0.3" shape_divider_position="bottom" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_woo_products product_type="all" category="all" columns="dynamic" orderby="date" order="DESC" carousel="1" script="flickity" flickity_controls="arrows-and-text" flickity_heading_tag="h2" item_shadow="1" carousel_script="flickity" per_page="8" flickity_heading_text="New Products" flickity_link_text="See All Products" flickity_link_url="#"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Fullwidth Custom Product Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/single-product-block-1.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/daily/?adventure" enable_bg_scale="true" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="400"][/vc_column][vc_column centered_text="true" column_padding="padding-5-percent" column_padding_position="left-right" background_color="#e1e1e1" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/2" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" top_padding="17%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532438962001{margin-bottom: 5px !important;}"]A whole new world of sound.[/vc_column_text][vc_column_text css=".vc_custom_1532438974675{margin-bottom: 35px !important;}"]
<h2>Amazing Earbuds</h2>
[/vc_column_text][add_to_cart id=""][divider line_type="No Line" custom_height="40"][image_with_animation image_url="https://source.unsplash.com/S4KVecxgCDo/700x700" alignment="" animation="None" border_radius="none" box_shadow="none" max_width="100%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Creative Fullwidth Custom Product Display', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/modern-full-width-product-display.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color="#0a0a0a" background_color_opacity="0.6" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/daily/?urban" enable_bg_scale="true" font_color="#ffffff" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Leave
A Timeless
Impression." font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes"][divider line_type="No Line" custom_height="40"][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="center" link_text="Explore Full Collection" url="#"][/vc_column][vc_column centered_text="true" column_padding="padding-3-percent" column_padding_position="all" background_color="#ffedf1" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532441498347{margin-top: 30px !important;margin-bottom: 10px !important;}"]
<h2>The Best Bike</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1532440860879{margin-bottom: 35px !important;}"]Discover true off-road performance.[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/800x500/daily/?bike" alignment="center" animation="None" img_link_large="yes" border_radius="10px" box_shadow="small_depth" max_width="75%" margin_bottom="40"][/vc_column_inner][/vc_row_inner][add_to_cart id=""][/vc_column][vc_column centered_text="true" column_padding="padding-3-percent" column_padding_position="all" background_color="#dde3ff" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532441502354{margin-top: 30px !important;margin-bottom: 10px !important;}"]
<h2>Amazing Earbuds</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1532440864198{margin-bottom: 35px !important;}"]A whole new world of sound.[/vc_column_text][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://source.unsplash.com/800x500/daily/?watch" alignment="center" animation="None" img_link_large="yes" border_radius="10px" box_shadow="small_depth" max_width="75%" margin_bottom="40"][/vc_column_inner][/vc_row_inner][add_to_cart id=""][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Vertical Fullwidth Custom Product Display', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/modern-full-width-product-display-2.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column centered_text="true" column_padding="padding-6-percent" column_padding_position="all" background_color="#0a0a0a" background_color_opacity="0.6" background_hover_color_opacity="1" background_image="https://source.unsplash.com/featured/daily/?mountain" enable_bg_scale="true" font_color="#ffffff" column_link_target="_self" column_shadow="none" column_border_radius="none" width="2/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_custom_heading text="Leave
A Timeless
Impression." font_container="tag:h2|text_align:center|color:%23ffffff" use_theme_fonts="yes"][divider line_type="No Line" custom_height="40"][nectar_cta btn_style="underline" heading_tag="h5" text_color="#ffffff" link_type="regular" alignment="center" link_text="Explore Full Collection" url="#"][/vc_column][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/3" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner column_padding="padding-6-percent" column_padding_position="all" background_color="#ffedf1" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532441498347{margin-top: 30px !important;margin-bottom: 10px !important;}"]
<h2>The Best Jacket</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1532440860879{margin-bottom: 35px !important;}"]Discover true off-road performance.[/vc_column_text][image_with_animation image_url="https://source.unsplash.com/featured/800x500/daily/?adventure" alignment="center" animation="None" img_link_large="yes" border_radius="10px" box_shadow="small_depth" max_width="75%" margin_bottom="40"][add_to_cart id=""][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" text_align="left"][vc_column_inner column_padding="padding-6-percent" column_padding_position="all" background_color="#dde3ff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" width="1/1" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1532441502354{margin-top: 30px !important;margin-bottom: 10px !important;}"]
<h2>Amazing Backpack</h2>
[/vc_column_text][vc_column_text css=".vc_custom_1532440864198{margin-bottom: 35px !important;}"]A whole new world of sound.[/vc_column_text][image_with_animation image_url="https://source.unsplash.com/featured/800x500/daily/?fashion" alignment="center" animation="None" img_link_large="yes" border_radius="10px" box_shadow="small_depth" max_width="75%" margin_bottom="40"][add_to_cart id=""][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Three Column Basic Fullwidth Category Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/full-width-3-col-product-cats.jpg' ); 
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" shape_divider_position="bottom" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_link_target="_self" column_shadow="none" column_border_radius="none" width="1/1" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid"][nectar_category_grid post_type="products" product_category="all" text_content_alignment="middle" subtext="cat_item_count" columns="3" grid_item_spacing="5px" color_overlay="#000000" color_overlay_opacity="0.2" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" shadow_on_hover="yes" subtext_visibility="on_hover" orderby="" order="" text_style="" color_strip_bg="" color_strip_bg_hover="" color_strip_text="" color_strip_text_hover="" block_sizing="square"][/vc_column][/vc_row]
CONTENT;
	
vc_add_default_templates( $data );


/* WooCommerce specific templates end */

}

}



?>