/**
 * WordPress dependencies
 */
import { __, sprintf } from '@wordpress/i18n';
import { Fragment } from '@wordpress/element';

/**
 * Internal dependencies
 */
import WrappedSection from './wrapped-section';
import { castWPError } from 'packages/utils/src';

function WPErrorDetails( { results, showErrorDetails = false } ) {
	const wpError = castWPError( results );

	return (
		<WrappedSection status="error" description={ __( 'The scan failed to properly scan the site.', 'ithemes-security-pro' ) }>
			<p>{ sprintf( __( 'Error Message: %s', 'ithemes-security-pro' ), wpError.getErrorMessage() ) }</p>
			<p>{ sprintf( __( 'Error Code: %s', 'ithemes-security-pro' ), wpError.getErrorCode() ) }</p>

			{ showErrorDetails && wpError.getErrorData() && (
				<Fragment>
					<p>{ __( 'If you contact support about this error, please provide the following debug details:', 'ithemes-security-pro' ) }</p>
					<pre>
						{ JSON.stringify( { code: wpError.getErrorCode(), data: wpError.getErrorData() }, null, 2 ) }
					</pre>
				</Fragment>
			) }
		</WrappedSection>
	);
}

export default WPErrorDetails;
